// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 

using Microsoft.FSharp;
using Microsoft.FSharp.Core;
using Microsoft.FSharp.Collections;
using System;

//--------------------------------------------------------------------
// This file demonstrates how to write a C# application which is 
// a client of an F# assembly. We call one of the published functions, 
// we create F# data values, we call an F# function that accepts 
// a delegate value as an argument and we discriminate over the 
// data produced as a result. 
//--------------------------------------------------------------------

class Tester {
   static void Main() { 
      System.Console.WriteLine("Testing interop between F# and C#");
      FSharpLibrary.PrintIntegers(10); 
      FSharpLibrary.MyData x1 = FSharpLibrary.MyData.A("abba");
      FSharpLibrary.MyData x2 = FSharpLibrary.MyData.B(3,x1);
      FSharpLibrary.MyData x3 = FSharpLibrary.MyData.B(2,x2);
      FSharpLibrary.MyData x4 = FSharpLibrary.MyData.B(1,x3);
      FSharpLibrary.MyDataPrint(x4);

#if NOGENERICS
      FSharpLibrary.MyData x5 = FSharpLibrary.MyDataMap(FuncConvert.ToFastFunc(new Converter(square)), x4);
#else
      FSharpLibrary.MyData x5 = FSharpLibrary.MyDataMap(new Converter<int,int>(square), x4);
#endif

      FSharpLibrary.MyDataPrint(x5);

      Console.WriteLine("x5.IsA = {0}", x5.IsA());
      Console.WriteLine("x5.IsB = {0}", x5.IsB());
      switch (x5.Tag)
      {
	  case FSharpLibrary.MyData.tag_A:
	      Console.WriteLine("A");
	      break;
	  case FSharpLibrary.MyData.tag_B:
	      Console.WriteLine("B");
	      break;
	  default:
	      Console.WriteLine("Hmmm... F# data of this type must be either an A or a B");
	      break;
      }

      if (x5.IsB())
         System.Console.WriteLine("Correct!");
     
   }

#if NOGENERICS
   static object square(object x) { return (int) x * (int) x; }
#else
   static int square(int x) { return x * x; }
#endif
}


