
#include "common.h"
// The PAL_CoCreateInstance from the Rotor SSCLI PAL is used if
// we are compiling against the PAL.  However, if we're compiling on
// a Windows platform we still want to be able to emit binaries 
// and debug information for the SSCLI, e.g. by specifying a command line
// switch such as "--sscli" to our AbstractIL-based tool.  Thus even when we don't
// have the Rotor PAL available we want to be able to dynamically link
// to the Rotor PAL DLL and do a dynamic CoCreateInstance.

typedef HRESULT __stdcall GetClassObjectProc(REFCLSID rclsid,
                                            REFIID   riid,
                                            void   **ppv);

// Call into the palrt to CoCreate the clsid
HRESULT PAL_MyCoCreateInstance(REFCLSID   rclsid,
                             REFIID     riid,
                             void     **ppv)
{

    static HINSTANCE  g_PalRtDll = NULL; // PalRt Dll handle
    GetClassObjectProc   *dllGetClassObject;
    g_PalRtDll = LoadLibraryW(L"rotor_palrt.dll");
    if (g_PalRtDll == NULL)
        return E_FAIL;

    dllGetClassObject = (GetClassObjectProc*)GetProcAddress(g_PalRtDll, "PAL_CoCreateInstance");

    if (dllGetClassObject == NULL) 
        return E_FAIL;

    return (*dllGetClassObject)(rclsid, riid, ppv);

}

