(* (c) Microsoft Corporation. All rights reserved *)

(*F# 
/// Configurable AppDomain-global diagnostics channel for the Abstract IL library
module Microsoft.Research.AbstractIL.Diagnostics 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
F#*)

let diagnosticsLog = ref (Some stderr)
let dflush () = match !diagnosticsLog with None -> () | Some d -> flush d
let dprintf0 (fmt: (_,_,_,_) format4) = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt; dflush()
let dprintf1 (fmt: (_,_,_,_) format4) x = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt x; dflush()
let dprintf2 (fmt: (_,_,_,_) format4) x1 x2 = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt x1 x2; dflush()
let dprintf3 (fmt: (_,_,_,_) format4) x1 x2 x3 = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt x1 x2 x3; dflush()
let dprintf4 (fmt: (_,_,_,_) format4) x1 x2 x3 x4 = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt x1 x2 x3 x4; dflush()
let dprintf5 (fmt: (_,_,_,_) format4) x1 x2 x3 x4 x5 = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt x1 x2 x3 x4 x5; dflush()
let dprintf6 (fmt: (_,_,_,_) format4) x1 x2 x3 x4 x5 x6 = match !diagnosticsLog with None -> () | Some d -> Printf.fprintf d fmt x1 x2 x3 x4 x5 x6; dflush()
let dprint_endline s = 
  match !diagnosticsLog with None -> () | Some d -> output_string d s; output_string d "\n"; dflush()
let dprint_string s = 
  match !diagnosticsLog with None -> () | Some d -> output_string d s; dflush()

let getDiagnosticsChannel () = !diagnosticsLog
let setDiagnosticsChannel s = diagnosticsLog := s
