// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Compatibility

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Math
open Microsoft.FSharp.Math.Matrix
open Microsoft.FSharp.Primitives.Basics

/// Functions to make F# math-related code look similar to code in other systems
module MATLAB = 
#if CLI_AT_MOST_1_1
    let triun (a:matrix) n = mapi (fun i j x -> if i+n <= j then x else 0.0) a
    let triln (a:matrix) n = mapi (fun i j x -> if i+n >= j then x else 0.0) a
    let triu a = triun a 0
    let tril a = triln a 0

    let diagn (v:vector) n = 
        let nV = Vector.length v + (if n < 0 then -n else n) 
        Matrix.init nV nV (fun i j -> if i+n=j then v.Item(i) else 0.0)
#else
    open Matrix.Generic
    let triun (a:Matrix<_>) n = 
        let ops = eops a 
        let zero = ops.Zero 
        mapi (fun i j x -> if i+n <= j then x else zero) a

    let triln (a:Matrix<_>) n = 
        let ops = a.ElementOps 
        let zero = ops.Zero 
        mapi (fun i j x -> if i+n >= j then x else zero) a

    let triu a = triun a 0
    let tril a = triln a 0

    let diagn v n = 
        let ops = Vector.Generic.eops v 
        let zero = ops.Zero 
        let nV = Vector.Generic.length v + (if n < 0 then -n else n) 
        Matrix.Generic.init nV nV (fun i j -> if i+n=j then v.Item(i) else zero)

#endif

  
