// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Math

    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Math
    open System
      
    /// The type of arbitrary-sized rational numbers
    type BigNum
      with 
        static member ( + ) : BigNum * BigNum -> BigNum
        static member ( * ) : BigNum * BigNum -> BigNum
        static member ( - ) : BigNum * BigNum -> BigNum
        static member ( / ) : BigNum * BigNum -> BigNum
        static member ( ~- ): BigNum          -> BigNum
        static member ( ~+ ): BigNum          -> BigNum
        static member (..)       : BigNum * BigNum -> BigNum seq
        static member (.. ..)    : BigNum * BigNum * BigNum-> BigNum seq
        override ToString: unit -> string
        override GetHashCode: unit -> int
        interface System.IComparable
        interface IStructuralHash
      end
    type BigRational = BigNum


namespace Microsoft.FSharp.Core

    type bignum = Microsoft.FSharp.Math.BigNum


namespace Microsoft.FSharp.Math

    open System
    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Math
    
    [<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
    module BigNum =

        val zero        : bignum  
        val one         : bignum  
        val of_int      : int         -> bignum  
        val of_bigint   : bigint      -> bignum  

        val neg         : bignum -> bignum
        
        val add         : bignum -> bignum -> bignum 
        val sub         : bignum -> bignum -> bignum 
        val mul         : bignum -> bignum -> bignum 
        val div         : bignum -> bignum -> bignum
        val powi        : bignum -> int    -> bignum

        val equal       : bignum -> bignum -> bool 
        val lt          : bignum -> bignum -> bool 
        val gt          : bignum -> bignum -> bool 
        val lte         : bignum -> bignum -> bool 
        val gte         : bignum -> bignum -> bool
        val compare     : bignum -> bignum -> int
        
        val negative    : bignum -> bool 
        val positive    : bignum -> bool
        val abs         : bignum -> bignum

        val max         : bignum -> bignum -> bignum 
        val min         : bignum -> bignum -> bignum

        val sign        : bignum -> int 
        val to_float    : bignum -> float 
        val to_bigint   : bignum -> bigint
        val to_int      : bignum -> int

        val to_string   : bignum -> string
        val of_string   : string -> bignum


namespace Microsoft.FSharp.Math.Types

    type BigRational = Microsoft.FSharp.Math.BigRational
    type BigNum = Microsoft.FSharp.Math.BigNum
