(* (c) Microsoft Corporation. All rights reserved *)

type layout (*F# = StructuredFormat.layout F#*)
val emptyL     : layout
val isEmptyL   : layout -> bool
  
val wordL      : string -> layout
val sepL       : string -> layout
val rightL     : string -> layout
val leftL      : string -> layout

val ( $$ )     : layout -> layout -> layout   (* never break "glue" *)
val ( ++ )     : layout -> layout -> layout   (* if break, indent=0 *)
val ( -- )     : layout -> layout -> layout   (* if break, indent=1 *)
val ( --- )    : layout -> layout -> layout   (* if break, indent=2 *)
val ( ---- )   : layout -> layout -> layout   (* if break, indent=2 *)
val ( ----- )  : layout -> layout -> layout   (* if break, indent=2 *)
val ( @@ )     : layout -> layout -> layout   (* broken ident=0 *)
val ( @@- )    : layout -> layout -> layout   (* broken ident=1 *)
val ( @@-- )   : layout -> layout -> layout   (* broken ident=2 *)

val commaListL : layout list -> layout
val spaceListL : layout list -> layout
val semiListL  : layout list -> layout
val sepListL   : layout -> layout list -> layout

val bracketL   : layout -> layout
val tupleL     : layout list -> layout
val aboveL     : layout -> layout -> layout
val aboveListL : layout list -> layout

val optionL    : ('a -> layout) -> 'a option -> layout    
val listL      : ('a -> layout) -> 'a list   -> layout

val tagL      : string -> layout -> layout
val linkL      : string -> layout -> layout

val squashTo   : int -> layout -> layout

val showL      : layout -> string
val outL       : out_channel -> layout -> unit
val bufferL    : Buffer.t -> layout -> unit

(* render a layout yielding an 'a using a 'b (hidden state) type *)
type ('a,'b) render =
    { start        : unit -> 'b;
      addText      : 'b -> string -> 'b;
      addBreak     : 'b -> int -> 'b;
      addTag       : 'b -> string * (string * string) list * bool -> 'b;
      finish       : 'b -> 'a
    }

(* Run a render on a layout *)      
val renderL  : ('b,'a) render -> layout -> 'b

(* Primitive renders *)
val stringR  : (string,string list) render
val channelR : out_channel -> (unit,unit) render
val bufferR  : Buffer.t -> (unit,unit) render

(* Combinator renders *)  
val htmlR    :        ('a,'b) render -> ('a,'b) render (* assumes in <pre> context *)
val indentR  : int -> ('a,'b) render -> ('a,'b) render
