(* (c) Microsoft Corporation. All rights reserved *)

(*F# 
module Microsoft.FSharp.Compiler.Lowertop 
open Microsoft.Research.AbstractIL
open Microsoft.Research.AbstractIL.Internal
open Microsoft.FSharp.Compiler 
module Ildiag = Microsoft.Research.AbstractIL.Diagnostics 
F#*) 
open Ildiag
open Range
open List
open Ast
open Tast
open Tastops
open Lib

(*-------------------------------------------------------------------------
!* OVERVIEW:
 *
 * An "expr -> expr" pass that eta-expands under-applied values of 
 * known arity to lambda expressions and beta-var-reduces to bind 
 * any known arguments.  The results are later optimized by the peephole 
 * optimizer in opt.ml.
 *-------------------------------------------------------------------------*)

let intercept_expr g cont expr =
  if verbose then dprintf2 "lower_expr@%a\n" output_range (range_of_expr expr);
  match expr with
  | TExpr_val(vref,flags,m) -> 
      begin match arity_of_vref vref with 
      | Some(arity) -> Some (fst (adjust_val_for_expected_arity g m vref flags arity))
      | None -> None
      end
  (* App (Val v,tys,args) *)
  | TExpr_app((TExpr_val (vref,flags,mv) as f0),f0ty,tyargsl,argsl,m) -> 
      (* Only transform if necessary, i.e. there are not enough arguments *)
      begin match arity_of_vref vref with
      | Some(arity_info) ->
          let argsl = map cont argsl in 
          let f0 = 
            if length (TopValData.aritiesOfArgs arity_info) > length argsl 
            then fst(adjust_val_for_expected_arity g m vref flags arity_info) 
            else f0 in 
          Some (beta_mk_appl g nng (f0,f0ty,[tyargsl],argsl,m))
      | None -> None
      end
  | TExpr_app(f0,f0ty,tyargsl,argsl,m) -> 
      Some (beta_mk_appl g nng (f0,f0ty, [tyargsl],argsl,m) )
  | _ -> None

let lower_assembly g ass = 
    rewrite_assembly {pre_intercept = Some(intercept_expr g);
                      post_transform= (fun _ -> None);
                      underQuotations=false } ass


