(* (c) Microsoft Corporation 2005-2007.  *)

module Microsoft.FSharp.Compatibility.OCaml.Buffer
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

type t = System.Text.StringBuilder

let create (n:int) = new System.Text.StringBuilder(n)
    
let contents (t:t) = t.ToString()
let length (t:t) = t.Length
let clear (t:t) = ignore (t.Remove(0,length t))
let reset (t:t) = ignore (t.Remove(0,length t))
let add_char (t:t) (c:char) = ignore (t.Append(c))
let add_string (t:t) (s:string) = ignore (t.Append(s))
let add_substring (t:t) (s:string) n m = ignore (t.Append(String.sub s n m))
let add_buffer (t:t) (t2:t) = ignore (t.Append(t2.ToString()))
let add_channel (t:t) c n = 
  let b = Bytearray.zero_create n  in 
  really_input c b 0 n;
  ignore (t.Append(Bytearray.ascii_to_string b))

let output_buffer os (t:t) = 
  output_string os (t.ToString())
