(* (c) Microsoft Corporation. All rights reserved *)
(*F# open Microsoft.Research.AbstractIL F#*)
(*F# open Microsoft.Research.AbstractIL.Internal F#*)
(*F# open Microsoft.FSharp.Compiler F#*)

open Tast
open Tastops

(* What should the decision tree contain for any incomplete match? *)
type actionOnFailure = 
  | IncompleteWarnOnLast
  | Incomplete 
  | Throw 
  | Rethrow 
  | FailFilter

type pat =
  | TPat_const of tconst * Range.range
  | TPat_wild of Range.range
  | TPat_as of  pat * pbind * Range.range
  | TPat_disjs of  pat list * Range.range
  | TPat_conjs of  pat list * Range.range
  | TPat_query of (expr * typ list * val_ref option * int * apinfo) * pat * Range.range
  | TPat_unionconstr of unionconstr_ref * tinst * pat list * Range.range
  | TPat_exnconstr of tycon_ref * pat list * Range.range
  | TPat_tuple of  pat list * typ list * Range.range
  | TPat_array of  pat list * typ * Range.range
  | TPat_recd of tycon_ref * tinst * (tinst * pat) list * Range.range
  | TPat_range of Nums.unichar * Nums.unichar * Range.range
  | TPat_null of Range.range
  | TPat_isinst of typ * typ * pbind option * Range.range
and pbind = PBind of val_spec * typ_scheme

and tclause =  TClause of pat * expr option * dtree_target * Range.range

val range_of_pat : pat -> Range.range

val compilePattern : 
    Ast.niceNameGenerator ->
    Env.tcGlobals ->
    Tastops.displayEnv ->
    Import.importMap -> 
    Range.range ->  (* range of the expression we are matching on *)
    Range.range ->  (* range of the whole match clause on *)
    bool ->  (* warn on unused? *)
    actionOnFailure -> 
    val_spec * typar_spec list -> (* the value being matched against, perhaps polymorphic *)
    tclause list -> 
    typ -> 
    dtree * dtree_target list
	

exception MatchIncomplete of bool *string option * Range.range
exception RuleNeverMatched of Range.range
