/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springsource.loaded.FieldDelta;
import org.springsource.loaded.MethodDelta;
import org.springsource.loaded.TypeDelta;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.Opcodes;
import sl.org.objectweb.asm.Type;
import sl.org.objectweb.asm.tree.AbstractInsnNode;
import sl.org.objectweb.asm.tree.AnnotationNode;
import sl.org.objectweb.asm.tree.ClassNode;
import sl.org.objectweb.asm.tree.FieldInsnNode;
import sl.org.objectweb.asm.tree.FieldNode;
import sl.org.objectweb.asm.tree.IincInsnNode;
import sl.org.objectweb.asm.tree.InsnList;
import sl.org.objectweb.asm.tree.InsnNode;
import sl.org.objectweb.asm.tree.IntInsnNode;
import sl.org.objectweb.asm.tree.JumpInsnNode;
import sl.org.objectweb.asm.tree.LabelNode;
import sl.org.objectweb.asm.tree.LdcInsnNode;
import sl.org.objectweb.asm.tree.LineNumberNode;
import sl.org.objectweb.asm.tree.LookupSwitchInsnNode;
import sl.org.objectweb.asm.tree.MethodInsnNode;
import sl.org.objectweb.asm.tree.MethodNode;
import sl.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import sl.org.objectweb.asm.tree.TableSwitchInsnNode;
import sl.org.objectweb.asm.tree.TypeInsnNode;
import sl.org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDiffComputer
implements Opcodes {
    public static TypeDelta computeDifferences(byte[] oldbytes, byte[] newbytes) {
        ClassNode oldClassNode = new ClassNode();
        new ClassReader(oldbytes).accept(oldClassNode, 0);
        ClassNode newClassNode = new ClassNode();
        new ClassReader(newbytes).accept(newClassNode, 0);
        TypeDelta delta = TypeDiffComputer.computeDelta(oldClassNode, newClassNode);
        return delta;
    }

    private static TypeDelta computeDelta(ClassNode oldClassNode, ClassNode newClassNode) {
        TypeDelta td = new TypeDelta();
        TypeDiffComputer.computeTypeDelta(oldClassNode, newClassNode, td);
        TypeDiffComputer.computeFieldDelta(oldClassNode, newClassNode, td);
        TypeDiffComputer.computeMethodDelta(oldClassNode, newClassNode, td);
        return td;
    }

    private static void computeMethodDelta(ClassNode oldClassNode, ClassNode newClassNode, TypeDelta td) {
        List nMethods = newClassNode.methods;
        ArrayList oMethods = new ArrayList(oldClassNode.methods);
        if (nMethods != null) {
            for (MethodNode nMethod : nMethods) {
                MethodNode found = null;
                for (MethodNode oMethod : oMethods) {
                    if (!oMethod.name.equals(nMethod.name) || !oMethod.desc.equals(nMethod.desc)) continue;
                    found = oMethod;
                    TypeDiffComputer.computeAnyMethodDifferences(oMethod, nMethod, td);
                }
                if (found == null) {
                    td.addNewMethod(nMethod);
                    continue;
                }
                oMethods.remove(found);
            }
        }
        for (MethodNode lostMethod : oMethods) {
            td.addLostMethod(lostMethod);
        }
    }

    private static void computeFieldDelta(ClassNode oldClassNode, ClassNode newClassNode, TypeDelta td) {
        int nSize = newClassNode.fields.size();
        ArrayList oFields = new ArrayList(oldClassNode.fields);
        int n = 0;
        while (n < nSize) {
            FieldNode nField = (FieldNode)newClassNode.fields.get(n);
            FieldNode found = null;
            for (FieldNode oField : oFields) {
                if (!oField.name.equals(nField.name)) continue;
                found = oField;
                TypeDiffComputer.computeAnyFieldDifferences(oField, nField, td);
            }
            if (found == null) {
                td.addNewField(nField);
            } else {
                oFields.remove(found);
            }
            ++n;
        }
        for (FieldNode lostField : oFields) {
            td.addLostField(lostField);
        }
    }

    private static void computeAnyFieldDifferences(FieldNode oField, FieldNode nField, TypeDelta td) {
        FieldDelta fd = new FieldDelta(oField.name);
        if (oField.access != nField.access) {
            fd.setAccessChanged(oField.access, nField.access);
        }
        if (!oField.desc.equals(nField.desc)) {
            fd.setTypeChanged(oField.desc, nField.desc);
        }
        String annotationChange = TypeDiffComputer.compareAnnotations(oField.invisibleAnnotations, nField.invisibleAnnotations);
        if ((annotationChange = String.valueOf(annotationChange) + TypeDiffComputer.compareAnnotations(oField.visibleAnnotations, nField.visibleAnnotations)).length() != 0) {
            fd.setAnnotationsChanged(annotationChange);
        }
        if (fd.hasAnyChanges()) {
            td.addChangedField(fd);
        }
    }

    private static void computeAnyMethodDifferences(MethodNode oMethod, MethodNode nMethod, TypeDelta td) {
        MethodDelta md = new MethodDelta(oMethod.name, oMethod.desc);
        if (oMethod.access != nMethod.access) {
            md.setAccessChanged(oMethod.access, nMethod.access);
        }
        InsnList oInstructions = oMethod.instructions;
        InsnList nInstructions = nMethod.instructions;
        if (oInstructions.size() != nInstructions.size()) {
            md.setInstructionsChanged(oInstructions.toArray(), nInstructions.toArray());
        } else if (oMethod.name.charAt(0) == '<') {
            String oInvokeSpecialDescriptor = null;
            String nInvokeSpecialDescriptor = null;
            int oUninitCount = 0;
            int nUninitCount = 0;
            boolean codeChange = false;
            int i = 0;
            int max = oInstructions.size();
            while (i < max) {
                MethodInsnNode mi;
                AbstractInsnNode oInstruction = oInstructions.get(i);
                AbstractInsnNode nInstruction = nInstructions.get(i);
                if (!codeChange && !TypeDiffComputer.sameInstruction(oInstruction, nInstruction)) {
                    codeChange = true;
                }
                if (oInstruction.getType() == 3 && oInstruction.getOpcode() == 187) {
                    ++oUninitCount;
                }
                if (nInstruction.getType() == 3 && nInstruction.getOpcode() == 187) {
                    ++nUninitCount;
                }
                if (oInstruction.getType() == 5 && (mi = (MethodInsnNode)oInstruction).getOpcode() == 183 && mi.name.equals("<init>")) {
                    if (oUninitCount == 0) {
                        oInvokeSpecialDescriptor = mi.desc;
                    } else {
                        --oUninitCount;
                    }
                }
                if (nInstruction.getType() == 5 && (mi = (MethodInsnNode)nInstruction).getOpcode() == 183 && mi.name.equals("<init>")) {
                    if (nUninitCount == 0) {
                        nInvokeSpecialDescriptor = mi.desc;
                    } else {
                        --nUninitCount;
                    }
                }
                ++i;
            }
            if (oInvokeSpecialDescriptor == null) {
                if (nInvokeSpecialDescriptor != null) {
                    md.setInvokespecialChanged(oInvokeSpecialDescriptor, nInvokeSpecialDescriptor);
                }
            } else if (!oInvokeSpecialDescriptor.equals(nInvokeSpecialDescriptor)) {
                md.setInvokespecialChanged(oInvokeSpecialDescriptor, nInvokeSpecialDescriptor);
            }
            if (codeChange) {
                md.setCodeChanged(oInstructions.toArray(), nInstructions.toArray());
            }
        }
        if (md.hasAnyChanges()) {
            td.addChangedMethod(md);
        }
    }

    private static boolean sameInstruction(AbstractInsnNode o, AbstractInsnNode n) {
        if (o.getType() != o.getType() || o.getOpcode() != n.getOpcode()) {
            return false;
        }
        switch (o.getType()) {
            case 0: {
                if (TypeDiffComputer.sameInsnNode(o, n)) break;
                return false;
            }
            case 1: {
                if (TypeDiffComputer.sameIntInsnNode(o, n)) break;
                return false;
            }
            case 2: {
                if (TypeDiffComputer.sameVarInsn(o, n)) break;
                return false;
            }
            case 3: {
                if (TypeDiffComputer.sameTypeInsn(o, n)) break;
                return false;
            }
            case 4: {
                if (TypeDiffComputer.sameFieldInsn(o, n)) break;
                return false;
            }
            case 5: {
                if (TypeDiffComputer.sameMethodInsnNode(o, n)) break;
                return false;
            }
            case 6: {
                if (TypeDiffComputer.sameJumpInsnNode(o, n)) break;
                return false;
            }
            case 7: {
                if (TypeDiffComputer.sameLabelNode(o, n)) break;
                return false;
            }
            case 8: {
                if (TypeDiffComputer.sameLdcInsnNode(o, n)) break;
                return false;
            }
            case 9: {
                if (TypeDiffComputer.sameIincInsn(o, n)) break;
                return false;
            }
            case 10: {
                if (TypeDiffComputer.sameTableSwitchInsn(o, n)) break;
                return false;
            }
            case 11: {
                if (TypeDiffComputer.sameLookupSwitchInsn(o, n)) break;
                return false;
            }
            case 12: {
                if (TypeDiffComputer.sameMultiANewArrayInsn(o, n)) break;
                return false;
            }
            case 13: {
                if (TypeDiffComputer.sameFrameInsn(o, n)) break;
                return false;
            }
            case 14: {
                if (TypeDiffComputer.sameLineNumberNode(o, n)) break;
                return false;
            }
            default: {
                throw new IllegalStateException("nyi " + o.getType());
            }
        }
        return true;
    }

    private static boolean sameFrameInsn(AbstractInsnNode o, AbstractInsnNode n) {
        return true;
    }

    private static boolean sameMultiANewArrayInsn(AbstractInsnNode o, AbstractInsnNode n) {
        if (!(n instanceof MultiANewArrayInsnNode)) {
            return false;
        }
        MultiANewArrayInsnNode mnao = (MultiANewArrayInsnNode)o;
        MultiANewArrayInsnNode mnan = (MultiANewArrayInsnNode)n;
        if (!mnao.desc.equals(mnan.desc)) {
            return false;
        }
        return mnao.dims == mnan.dims;
    }

    private static boolean sameLookupSwitchInsn(AbstractInsnNode o, AbstractInsnNode n) {
        if (!(n instanceof LookupSwitchInsnNode)) {
            return false;
        }
        LookupSwitchInsnNode lsio = (LookupSwitchInsnNode)o;
        LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)n;
        if (TypeDiffComputer.sameLabels(lsio.dflt, lsin.dflt)) {
            return false;
        }
        List keyso = lsio.keys;
        List keysn = lsin.keys;
        if (keyso.size() != keysn.size()) {
            return false;
        }
        int i = 0;
        int max = keyso.size();
        while (i < max) {
            if (keyso.get(i) != keysn.get(i)) {
                return false;
            }
            ++i;
        }
        List labelso = lsio.labels;
        List labelsn = lsin.labels;
        if (labelso.size() != labelsn.size()) {
            return false;
        }
        int i2 = 0;
        int max2 = labelso.size();
        while (i2 < max2) {
            if (!TypeDiffComputer.sameLabelNode((AbstractInsnNode)labelso.get(i2), (AbstractInsnNode)labelsn.get(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static boolean sameTableSwitchInsn(AbstractInsnNode o, AbstractInsnNode n) {
        if (!(n instanceof TableSwitchInsnNode)) {
            return false;
        }
        TableSwitchInsnNode tsio = (TableSwitchInsnNode)o;
        TableSwitchInsnNode tsin = (TableSwitchInsnNode)n;
        if (TypeDiffComputer.sameLabels(tsio.dflt, tsin.dflt)) {
            return false;
        }
        if (tsio.min != tsin.min) {
            return false;
        }
        if (tsio.max != tsin.max) {
            return false;
        }
        List labelso = tsio.labels;
        List labelsn = tsin.labels;
        if (labelso.size() != labelsn.size()) {
            return false;
        }
        int i = 0;
        int max = labelso.size();
        while (i < max) {
            if (!TypeDiffComputer.sameLabelNode((AbstractInsnNode)labelso.get(i), (AbstractInsnNode)labelsn.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean sameLabels(LabelNode lno, LabelNode lnn) {
        return false;
    }

    private static boolean sameFieldInsn(AbstractInsnNode o, AbstractInsnNode n) {
        FieldInsnNode oi = (FieldInsnNode)o;
        if (!(n instanceof FieldInsnNode)) {
            return false;
        }
        FieldInsnNode ni = (FieldInsnNode)n;
        return oi.name.equals(ni.name) && oi.desc.equals(ni.desc) && oi.owner.equals(ni.owner);
    }

    private static boolean sameMethodInsnNode(AbstractInsnNode o, AbstractInsnNode n) {
        MethodInsnNode oi = (MethodInsnNode)o;
        if (!(n instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode ni = (MethodInsnNode)n;
        return oi.name.equals(ni.name) && oi.desc.equals(ni.desc) && oi.owner.equals(ni.owner);
    }

    private static boolean sameVarInsn(AbstractInsnNode o, AbstractInsnNode n) {
        VarInsnNode oi = (VarInsnNode)o;
        if (!(n instanceof VarInsnNode)) {
            return false;
        }
        VarInsnNode ni = (VarInsnNode)n;
        return oi.var == ni.var;
    }

    private static boolean sameInsnNode(AbstractInsnNode o, AbstractInsnNode n) {
        InsnNode oi = (InsnNode)o;
        if (!(n instanceof InsnNode)) {
            return false;
        }
        InsnNode ni = (InsnNode)n;
        return oi.getOpcode() == ni.getOpcode();
    }

    private static boolean sameJumpInsnNode(AbstractInsnNode o, AbstractInsnNode n) {
        return n instanceof JumpInsnNode;
    }

    private static boolean sameLdcInsnNode(AbstractInsnNode o, AbstractInsnNode n) {
        LdcInsnNode oi = (LdcInsnNode)o;
        if (!(n instanceof LdcInsnNode)) {
            return false;
        }
        LdcInsnNode ni = (LdcInsnNode)n;
        Object ocst = oi.cst;
        if (ocst instanceof Integer) {
            if (!(ni.cst instanceof Integer)) {
                return false;
            }
            return ((Integer)ocst).equals(ni.cst);
        }
        if (ocst instanceof Float) {
            if (!(ni.cst instanceof Float)) {
                return false;
            }
            return ((Float)ocst).equals(ni.cst);
        }
        if (ocst instanceof Long) {
            if (!(ni.cst instanceof Long)) {
                return false;
            }
            return ((Long)ocst).equals(ni.cst);
        }
        if (ocst instanceof Double) {
            if (!(ni.cst instanceof Double)) {
                return false;
            }
            return ((Double)ocst).equals(ni.cst);
        }
        if (ocst instanceof String) {
            if (!(ni.cst instanceof String)) {
                return false;
            }
            return ((String)ocst).equals(ni.cst);
        }
        return ((Type)ocst).equals(ni.cst);
    }

    private static boolean sameIntInsnNode(AbstractInsnNode o, AbstractInsnNode n) {
        IntInsnNode oi = (IntInsnNode)o;
        if (!(n instanceof IntInsnNode)) {
            return false;
        }
        IntInsnNode ni = (IntInsnNode)n;
        return oi.operand == ni.operand;
    }

    private static boolean sameLineNumberNode(AbstractInsnNode o, AbstractInsnNode n) {
        LineNumberNode oi = (LineNumberNode)o;
        if (!(n instanceof LineNumberNode)) {
            return false;
        }
        LineNumberNode ni = (LineNumberNode)n;
        return oi.line == ni.line;
    }

    private static boolean sameIincInsn(AbstractInsnNode o, AbstractInsnNode n) {
        IincInsnNode oi = (IincInsnNode)o;
        if (!(n instanceof IincInsnNode)) {
            return false;
        }
        IincInsnNode ni = (IincInsnNode)n;
        return oi.var == ni.var && oi.incr == ni.incr;
    }

    private static boolean sameTypeInsn(AbstractInsnNode o, AbstractInsnNode n) {
        TypeInsnNode oi = (TypeInsnNode)o;
        if (!(n instanceof TypeInsnNode)) {
            return false;
        }
        TypeInsnNode ni = (TypeInsnNode)n;
        return oi.desc.equals(ni.desc);
    }

    private static boolean sameLabelNode(AbstractInsnNode o, AbstractInsnNode n) {
        return n instanceof LabelNode;
    }

    private static String compareAnnotations(List<AnnotationNode> oldAnnos, List<AnnotationNode> newAnnos) {
        boolean found;
        if (oldAnnos == null) {
            if (newAnnos == null) {
                return "";
            }
            oldAnnos = Collections.emptyList();
        }
        if (newAnnos == null) {
            newAnnos = Collections.emptyList();
        }
        StringBuilder diff = new StringBuilder();
        for (AnnotationNode o : oldAnnos) {
            found = false;
            String oFormatted = Utils.annotationNodeFormat(o);
            for (AnnotationNode n : newAnnos) {
                String nFormatted = Utils.annotationNodeFormat(n);
                if (!oFormatted.equals(nFormatted)) continue;
                found = true;
                break;
            }
            if (found) continue;
            diff.append("-").append(oFormatted);
        }
        for (AnnotationNode n : newAnnos) {
            found = false;
            String nFormatted = Utils.annotationNodeFormat(n);
            for (AnnotationNode o : oldAnnos) {
                String oFormatted = Utils.annotationNodeFormat(o);
                if (!oFormatted.equals(nFormatted)) continue;
                found = true;
                break;
            }
            if (found) continue;
            diff.append("+").append(nFormatted);
        }
        return diff.toString();
    }

    private static void computeTypeDelta(ClassNode oldClassNode, ClassNode newClassNode, TypeDelta td) {
        if (oldClassNode.access != newClassNode.access) {
            td.setTypeAccessChange(oldClassNode.access, newClassNode.access);
        }
        if (!oldClassNode.name.equals(newClassNode.name)) {
            td.setTypeNameChange(oldClassNode.name, newClassNode.name);
        }
        if (oldClassNode.superName == null) {
            if (newClassNode.superName != null) {
                td.setTypeSuperNameChange(oldClassNode.superName, newClassNode.superName);
            }
        } else if (newClassNode.superName == null) {
            if (oldClassNode.superName != null) {
                td.setTypeSuperNameChange(oldClassNode.superName, newClassNode.superName);
            }
        } else if (!oldClassNode.superName.equals(newClassNode.superName)) {
            td.setTypeSuperNameChange(oldClassNode.superName, newClassNode.superName);
        }
        if (oldClassNode.interfaces.size() == 0) {
            if (newClassNode.interfaces.size() != 0) {
                td.setTypeInterfacesChange(oldClassNode.interfaces, newClassNode.interfaces);
            }
        } else if (newClassNode.interfaces.size() == 0) {
            if (oldClassNode.interfaces.size() != 0) {
                td.setTypeInterfacesChange(oldClassNode.interfaces, newClassNode.interfaces);
            }
        } else {
            HashSet newInterfaceSet;
            HashSet oldInterfaceSet;
            if (oldClassNode.interfaces.size() != newClassNode.interfaces.size()) {
                td.setTypeInterfacesChange(oldClassNode.interfaces, newClassNode.interfaces);
            }
            if (!(oldInterfaceSet = new HashSet(oldClassNode.interfaces)).equals(newInterfaceSet = new HashSet(newClassNode.interfaces))) {
                td.setTypeInterfacesChange(oldClassNode.interfaces, newClassNode.interfaces);
            }
        }
    }
}

