/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.statement.DatabaseFunction;

public class OracleDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "oracle";
    private Set<String> reservedWords = new HashSet<String>();

    public OracleDatabase() {
        this.databaseFunctions.add(new DatabaseFunction("SYSDATE"));
        this.databaseFunctions.add(new DatabaseFunction("SYSTIMESTAMP"));
        this.databaseFunctions.add(new DatabaseFunction("CURRENT_TIMESTAMP"));
    }

    public int getPriority() {
        return 1;
    }

    public void setConnection(DatabaseConnection conn) {
        try {
            Method wrappedConn = conn.getClass().getMethod("getWrappedConnection", new Class[0]);
            wrappedConn.setAccessible(true);
            Connection sqlConn = (Connection)wrappedConn.invoke((Object)conn, new Object[0]);
            Method method = sqlConn.getClass().getMethod("setRemarksReporting", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)sqlConn, true);
            this.reservedWords.addAll(Arrays.asList(sqlConn.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*")));
            this.reservedWords.addAll(Arrays.asList("USER", "SESSION", "RESOURCE"));
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Could not set remarks reporting on OracleDatabase: " + e.getMessage());
        }
        super.setConnection(conn);
    }

    public String getTypeName() {
        return PRODUCT_NAME;
    }

    public String generatePrimaryKeyName(String tableName) {
        if (tableName.length() > 27) {
            return "PK_" + tableName.toUpperCase().substring(0, 27);
        }
        return "PK_" + tableName.toUpperCase();
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    public String escapeDatabaseObject(String objectName) {
        if (objectName != null && (Pattern.compile("\\W").matcher(objectName).find() || this.isReservedWord(objectName))) {
            return "\"" + objectName.trim().toUpperCase() + "\"";
        }
        return objectName;
    }

    public boolean isReservedWord(String objectName) {
        return this.reservedWords.contains(objectName.toUpperCase());
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "SYSTIMESTAMP";
    }

    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    public String escapeIndexName(String schemaName, String indexName) {
        String escapedIndexName = indexName;
        if (schemaName != null) {
            escapedIndexName = schemaName + "." + escapedIndexName;
        }
        return escapedIndexName;
    }

    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        if (this.isDateOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD')");
            return val.toString();
        }
        if (this.isTimeOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'HH24:MI:SS')");
            return val.toString();
        }
        if (this.isDateTime(isoDate)) {
            normalLiteral = normalLiteral.substring(0, normalLiteral.lastIndexOf(46)) + "'";
            StringBuffer val = new StringBuffer(26);
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD HH24:MI:SS')");
            return val.toString();
        }
        return "UNSUPPORTED:" + isoDate;
    }

    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if (super.isSystemTable(catalogName, schemaName, tableName)) {
            return true;
        }
        if (tableName.startsWith("BIN$")) {
            return true;
        }
        if (tableName.startsWith("AQ$")) {
            return true;
        }
        if (tableName.startsWith("DR$")) {
            return true;
        }
        return tableName.startsWith("SYS_IOT_OVER");
    }

    public boolean shouldQuoteValue(String value) {
        return super.shouldQuoteValue(value) && !value.startsWith("to_date(") && !value.equalsIgnoreCase(this.getCurrentDateTimeFunction());
    }

    public boolean supportsTablespaces() {
        return true;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }
}

