/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddUniqueConstraintGenerator;
import liquibase.statement.core.AddUniqueConstraintStatement;

public class AddUniqueConstraintGeneratorTDS
extends AddUniqueConstraintGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddUniqueConstraintStatement statement, Database database) {
        return database instanceof MSSQLDatabase || database instanceof SybaseDatabase || database instanceof SybaseASADatabase;
    }

    public Sql[] generateSql(AddUniqueConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sqlTemplate = "ALTER TABLE %s ADD CONSTRAINT %s UNIQUE (%s)";
        String sqlNoContraintNameTemplate = "ALTER TABLE %s ADD UNIQUE (%s)";
        if (statement.getConstraintName() == null) {
            return new Sql[]{new UnparsedSql(String.format("ALTER TABLE %s ADD UNIQUE (%s)", database.escapeTableName(statement.getSchemaName(), statement.getTableName()), database.escapeColumnNameList(statement.getColumnNames())), new DatabaseObject[0])};
        }
        return new Sql[]{new UnparsedSql(String.format("ALTER TABLE %s ADD CONSTRAINT %s UNIQUE (%s)", database.escapeTableName(statement.getSchemaName(), statement.getTableName()), database.escapeConstraintName(statement.getConstraintName()), database.escapeColumnNameList(statement.getColumnNames())), new DatabaseObject[0])};
    }
}

