/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.archive;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

class ResourceMatcher {
    private static final String[] DEFAULT_INCLUDES = new String[]{"public/**", "resources/**", "static/**", "templates/**", "META-INF/**", "*"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{".*", "repository/**", "build/**", "target/**", "**/*.jar", "**/*.groovy"};
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final List<String> includes;
    private final List<String> excludes;

    ResourceMatcher(List<String> includes, List<String> excludes) {
        this.includes = this.getOptions(includes, DEFAULT_INCLUDES);
        this.excludes = this.getOptions(excludes, DEFAULT_EXCLUDES);
    }

    public List<MatchedResource> find(List<File> roots) throws IOException {
        ArrayList<MatchedResource> matchedResources = new ArrayList<MatchedResource>();
        for (File root : roots) {
            if (root.isFile()) {
                matchedResources.add(new MatchedResource(root));
                continue;
            }
            matchedResources.addAll(this.findInFolder(root));
        }
        return matchedResources;
    }

    private List<MatchedResource> findInFolder(File folder) throws IOException {
        ArrayList<MatchedResource> matchedResources = new ArrayList<MatchedResource>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new FolderResourceLoader(folder));
        for (String include : this.includes) {
            for (Resource candidate : resolver.getResources(include)) {
                MatchedResource matchedResource;
                File file = candidate.getFile();
                if (!file.isFile() || this.isExcluded(matchedResource = new MatchedResource(folder, file))) continue;
                matchedResources.add(matchedResource);
            }
        }
        return matchedResources;
    }

    private boolean isExcluded(MatchedResource matchedResource) {
        for (String exclude : this.excludes) {
            if (!this.pathMatcher.match(exclude, matchedResource.getName())) continue;
            return true;
        }
        return false;
    }

    private List<String> getOptions(List<String> values, String[] defaults) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LinkedHashSet<String> minus = new LinkedHashSet<String>();
        boolean deltasFound = false;
        for (String value : values) {
            if (value.startsWith("+")) {
                deltasFound = true;
                value = value.substring(1);
                result.add(value);
                continue;
            }
            if (value.startsWith("-")) {
                deltasFound = true;
                value = value.substring(1);
                minus.add(value);
                continue;
            }
            if (value.trim().isEmpty()) continue;
            result.add(value);
        }
        for (String value : defaults) {
            if (minus.contains(value) && deltasFound) continue;
            result.add(value);
        }
        return new ArrayList<String>(result);
    }

    public static final class MatchedResource {
        private final File file;
        private final String name;
        private final boolean root;

        private MatchedResource(File file) {
            this.name = file.getName();
            this.file = file;
            this.root = this.name.endsWith(".jar");
        }

        private MatchedResource(File rootFolder, File file) {
            this.name = StringUtils.cleanPath((String)file.getAbsolutePath().substring(rootFolder.getAbsolutePath().length() + 1));
            this.file = file;
            this.root = false;
        }

        private MatchedResource(File resourceFile, String path, boolean root) {
            this.file = resourceFile;
            this.name = path;
            this.root = root;
        }

        public String getName() {
            return this.name;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isRoot() {
            return this.root;
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }

    private static class FolderClassLoader
    extends URLClassLoader {
        FolderClassLoader(File rootFolder) throws MalformedURLException {
            super(new URL[]{rootFolder.toURI().toURL()});
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.findResources(name);
        }

        @Override
        public URL getResource(String name) {
            return this.findResource(name);
        }
    }

    private static class FolderResourceLoader
    extends DefaultResourceLoader {
        private final File rootFolder;

        FolderResourceLoader(File root) throws MalformedURLException {
            super((ClassLoader)new FolderClassLoader(root));
            this.rootFolder = root;
        }

        protected Resource getResourceByPath(String path) {
            return new FileSystemResource(new File(this.rootFolder, path));
        }
    }
}

