/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.MapPropertyResolver;
import io.micronaut.core.value.PropertyResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PropertySourcePropertyResolver
implements PropertyResolver {
    private static final Logger LOG = ClassUtils.getLogger(PropertySourcePropertyResolver.class);
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final Pattern RANDOM_PATTERN = Pattern.compile("\\$\\{\\s?random\\.(\\S+?)\\}");
    private static final char[] DOT_DASH = new char[]{'.', '-'};
    private static final Object NO_VALUE = new Object();
    protected final ConversionService<?> conversionService;
    protected final PropertyPlaceholderResolver propertyPlaceholderResolver;
    protected final Map<String, PropertySource> propertySources = new ConcurrentHashMap<String, PropertySource>(10);
    protected final Map<String, Object>[] catalog = new Map[58];
    protected final Map<String, Object>[] rawCatalog = new Map[58];
    private final Random random = new Random();
    private final Map<String, Boolean> containsCache = new ConcurrentHashMap<String, Boolean>(20);
    private final Map<String, Object> resolvedValueCache = new ConcurrentHashMap<String, Object>(20);

    public PropertySourcePropertyResolver(ConversionService<?> conversionService) {
        this.conversionService = conversionService;
        this.propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(this, conversionService);
    }

    public PropertySourcePropertyResolver() {
        this(ConversionService.SHARED);
    }

    public PropertySourcePropertyResolver(PropertySource ... propertySources) {
        this(ConversionService.SHARED);
        if (propertySources != null) {
            for (PropertySource propertySource : propertySources) {
                this.addPropertySource(propertySource);
            }
        }
    }

    public PropertySourcePropertyResolver addPropertySource(@Nullable PropertySource propertySource) {
        if (propertySource != null) {
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
        return this;
    }

    public PropertySourcePropertyResolver addPropertySource(String name, @Nullable Map<String, ? super Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            return this.addPropertySource(PropertySource.of(name, values));
        }
        return this;
    }

    public boolean containsProperty(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Boolean result = this.containsCache.get(name);
        if (result == null) {
            String finalName = this.trimIndex(name);
            result = Stream.of(null, StringConvention.RAW).anyMatch(convention -> {
                Map<String, Object> entries = this.resolveEntriesForKey(finalName, false, (StringConvention)convention);
                if (entries == null) {
                    return false;
                }
                return entries.containsKey(finalName);
            });
            this.containsCache.put(name, result);
        }
        return result;
    }

    public boolean containsProperties(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        String trimmedName = this.trimIndex(name);
        return Stream.of(null, StringConvention.RAW).anyMatch(convention -> {
            Map<String, Object> entries = this.resolveEntriesForKey(trimmedName, false, (StringConvention)convention);
            if (entries == null) {
                return false;
            }
            if (entries.containsKey(trimmedName)) {
                return true;
            }
            String finalName = trimmedName + ".";
            return entries.keySet().stream().anyMatch(key -> key.startsWith(finalName));
        });
    }

    @Nonnull
    public Map<String, Object> getProperties(String name, StringConvention keyFormat) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            Map<String, Object> entries = this.resolveEntriesForKey(name, false, keyFormat);
            if (entries != null) {
                if (keyFormat == null) {
                    keyFormat = StringConvention.RAW;
                }
                return this.resolveSubMap(name, entries, ConversionContext.of(Map.class), keyFormat, MapFormat.MapTransformation.FLAT);
            }
            entries = this.resolveEntriesForKey(name, false, null);
            if (keyFormat == null) {
                keyFormat = StringConvention.RAW;
            }
            if (entries == null) {
                return Collections.emptyMap();
            }
            return this.resolveSubMap(name, entries, ConversionContext.of(Map.class), keyFormat, MapFormat.MapTransformation.FLAT);
        }
        return Collections.emptyMap();
    }

    public <T> Optional<T> getProperty(@Nonnull String name, @Nonnull ArgumentConversionContext<T> conversionContext) {
        Object cached;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.empty();
        }
        Objects.requireNonNull(conversionContext, "Conversion context should not be null");
        Class requiredType = conversionContext.getArgument().getType();
        boolean cacheableType = ClassUtils.isJavaLangType((Class)requiredType);
        Object object = cached = cacheableType ? this.resolvedValueCache.get(this.cacheKey(name, requiredType)) : null;
        if (cached != null) {
            return cached == NO_VALUE ? Optional.empty() : Optional.of(cached);
        }
        Map<String, Object> entries = this.resolveEntriesForKey(name, false, null);
        if (entries == null) {
            entries = this.resolveEntriesForKey(name, false, StringConvention.RAW);
        }
        if (entries != null) {
            Map<String, Object> subMap;
            int i;
            Object value = entries.get(name);
            if (value == null && (value = entries.get(this.normalizeName(name))) == null && name.indexOf(91) == -1) {
                Map<String, Object> rawEntries = this.resolveEntriesForKey(name, false, StringConvention.RAW);
                Object object2 = value = rawEntries != null ? rawEntries.get(name) : null;
                if (value != null) {
                    entries = rawEntries;
                }
            }
            if (value == null && (i = name.indexOf(91)) > -1 && name.endsWith("]")) {
                String newKey = name.substring(0, i);
                value = entries.get(newKey);
                String index = name.substring(i + 1, name.length() - 1);
                if (value != null) {
                    if (StringUtils.isNotEmpty((CharSequence)index)) {
                        if (value instanceof List) {
                            try {
                                value = ((List)value).get(Integer.valueOf(index));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (value instanceof Map) {
                            try {
                                value = ((Map)value).get(index);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)index)) {
                    String subKey = newKey + '.' + index;
                    value = entries.get(subKey);
                }
            }
            if (value != null) {
                value = this.resolvePlaceHoldersIfNecessary(value);
                Optional converted = this.conversionService.convert(value, conversionContext);
                if (LOG.isTraceEnabled()) {
                    if (converted.isPresent()) {
                        LOG.trace("Resolved value [{}] for property: {}", converted.get(), (Object)name);
                    } else {
                        LOG.trace("Resolved value [{}] cannot be converted to type [{}] for property: {}", new Object[]{value, conversionContext.getArgument(), name});
                    }
                }
                if (cacheableType) {
                    this.resolvedValueCache.put(this.cacheKey(name, requiredType), converted.orElse(NO_VALUE));
                }
                return converted;
            }
            if (cacheableType) {
                this.resolvedValueCache.put(this.cacheKey(name, requiredType), NO_VALUE);
                return Optional.empty();
            }
            if (Properties.class.isAssignableFrom(requiredType)) {
                Properties properties = this.resolveSubProperties(name, entries, conversionContext);
                return Optional.of(properties);
            }
            if (Map.class.isAssignableFrom(requiredType)) {
                subMap = this.resolveSubMap(name, entries, conversionContext);
                return this.conversionService.convert(subMap, requiredType, conversionContext);
            }
            if (PropertyResolver.class.isAssignableFrom(requiredType)) {
                subMap = this.resolveSubMap(name, entries, conversionContext);
                return Optional.of(new MapPropertyResolver(subMap, this.conversionService));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No value found for property: {}", (Object)name);
        }
        if (Properties.class.isAssignableFrom(requiredType = conversionContext.getArgument().getType())) {
            return Optional.of(new Properties());
        }
        if (Map.class.isAssignableFrom(requiredType)) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    @NotNull
    private <T> String cacheKey(@Nonnull String name, Class<T> requiredType) {
        return name + '|' + requiredType.getSimpleName();
    }

    @Deprecated
    public Map<String, Object> getAllProperties() {
        return this.getAllProperties(StringConvention.RAW, MapFormat.MapTransformation.NESTED);
    }

    public Map<String, Object> getAllProperties(StringConvention keyConvention, MapFormat.MapTransformation transformation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isNested = transformation == MapFormat.MapTransformation.NESTED;
        Arrays.stream(this.catalog).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> {
            String k = keyConvention.format((String)entry.getKey());
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            Map finalMap = map;
            int index = k.indexOf(46);
            if (index != -1 && isNested) {
                String[] keys = DOT_PATTERN.split(k);
                for (int i = 0; i < keys.length - 1; ++i) {
                    Object next;
                    if (!finalMap.containsKey(keys[i])) {
                        finalMap.put(keys[i], new HashMap());
                    }
                    if (!((next = finalMap.get(keys[i])) instanceof Map)) continue;
                    finalMap = (Map)next;
                }
                finalMap.put(keys[keys.length - 1], value);
            } else {
                finalMap.put(k, value);
            }
        });
        return map;
    }

    protected Properties resolveSubProperties(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        Properties properties = new Properties();
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.enumValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(null);
        if (keyConvention == StringConvention.RAW) {
            entries = this.resolveEntriesForKey(name, false, keyConvention);
        }
        String prefix = name + '.';
        entries.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith(prefix)).forEach(entry -> {
            Object value = entry.getValue();
            if (value != null) {
                String key = ((String)entry.getKey()).substring(prefix.length());
                key = keyConvention != null ? keyConvention.format(key) : key;
                properties.put(key, this.resolvePlaceHoldersIfNecessary(value.toString()));
            }
        });
        return properties;
    }

    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.enumValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(null);
        if (keyConvention == StringConvention.RAW) {
            entries = this.resolveEntriesForKey(name, false, keyConvention);
        }
        MapFormat.MapTransformation transformation = annotationMetadata.enumValue(MapFormat.class, "transformation", MapFormat.MapTransformation.class).orElse(conversionContext.isAnnotationPresent(Property.class) ? MapFormat.MapTransformation.FLAT : MapFormat.MapTransformation.NESTED);
        return this.resolveSubMap(name, entries, conversionContext, keyConvention, transformation);
    }

    @Nonnull
    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext, @Nullable StringConvention keyConvention, MapFormat.MapTransformation transformation) {
        Argument valueType = conversionContext.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
        LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>(entries.size());
        String prefix = name + '.';
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            String subMapKey = key.substring(prefix.length());
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            if (transformation == MapFormat.MapTransformation.FLAT) {
                subMapKey = keyConvention != null ? keyConvention.format(subMapKey) : subMapKey;
                value = this.conversionService.convert(value, valueType).orElse(null);
                subMap.put(subMapKey, value);
                continue;
            }
            this.processSubmapKey(subMap, subMapKey, value, keyConvention);
        }
        return subMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPropertySource(PropertySource properties, PropertySource.PropertyConvention convention) {
        this.propertySources.put(properties.getName(), properties);
        Map<String, Object>[] mapArray = this.catalog;
        synchronized (this.catalog) {
            for (String property : properties) {
                Object value;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing property key {}", (Object)property);
                }
                if ((value = properties.get(property)) instanceof CharSequence) {
                    value = this.processRandomExpressions(convention, property, (CharSequence)value);
                } else if (value instanceof List) {
                    ListIterator<CharSequence> i = ((List)value).listIterator();
                    while (i.hasNext()) {
                        CharSequence newValue;
                        Iterator<String> o = i.next();
                        if (!(o instanceof CharSequence) || (newValue = this.processRandomExpressions(convention, property, (CharSequence)((Object)o))) == o) continue;
                        i.set(newValue);
                    }
                }
                List<String> resolvedProperties = this.resolvePropertiesForConvention(property, convention);
                for (String resolvedProperty : resolvedProperties) {
                    int i = resolvedProperty.indexOf(91);
                    if (i > -1) {
                        String propertyName = resolvedProperty.substring(0, i);
                        Map<String, Object> entries = this.resolveEntriesForKey(propertyName, true, null);
                        if (entries == null) continue;
                        this.processProperty(resolvedProperty.substring(i), val -> entries.put(propertyName, val), () -> entries.get(propertyName), value);
                        continue;
                    }
                    Map<String, Object> entries = this.resolveEntriesForKey(resolvedProperty, true, null);
                    if (entries == null) continue;
                    entries.put(resolvedProperty, value);
                }
                Map<String, Object> rawEntries = this.resolveEntriesForKey(property, true, StringConvention.RAW);
                if (rawEntries == null) continue;
                rawEntries.put(property, value);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void processProperty(String property, Consumer<Object> containerSet, Supplier<Object> containerGet, Object actualValue) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            containerSet.accept(actualValue);
            return;
        }
        int i = property.indexOf(91);
        int li = property.indexOf(93);
        if (i == 0 && li > -1) {
            String propertyIndex = property.substring(1, li);
            String propertyRest = property.substring(li + 1);
            Object container = containerGet.get();
            if (StringUtils.isDigits((String)propertyIndex)) {
                ArrayList list;
                Integer number = Integer.valueOf(propertyIndex);
                if (container instanceof List) {
                    list = (ArrayList)container;
                } else {
                    list = new ArrayList(10);
                    containerSet.accept(list);
                }
                this.fill(list, number, null);
                this.processProperty(propertyRest, val -> list.set(number, val), () -> list.get(number), actualValue);
            } else {
                LinkedHashMap map;
                if (container instanceof Map) {
                    map = (LinkedHashMap)container;
                } else {
                    map = new LinkedHashMap(10);
                    containerSet.accept(map);
                }
                this.processProperty(propertyRest, val -> map.put(propertyIndex, val), () -> map.get(propertyIndex), actualValue);
            }
        } else if (property.startsWith(".")) {
            LinkedHashMap map;
            String propertyRest;
            String propertyName;
            if (i > -1) {
                propertyName = property.substring(1, i);
                propertyRest = property.substring(i);
            } else {
                propertyName = property.substring(1);
                propertyRest = "";
            }
            Object v = containerGet.get();
            if (v instanceof Map) {
                map = (LinkedHashMap)v;
            } else {
                map = new LinkedHashMap(10);
                containerSet.accept(map);
            }
            this.processProperty(propertyRest, val -> map.put(propertyName, val), () -> map.get(propertyName), actualValue);
        }
    }

    private CharSequence processRandomExpressions(PropertySource.PropertyConvention convention, String property, CharSequence str) {
        if (convention != PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE && str.toString().contains(this.propertyPlaceholderResolver.getPrefix())) {
            StringBuffer newValue = new StringBuffer();
            Matcher matcher = RANDOM_PATTERN.matcher(str);
            boolean hasRandoms = false;
            while (matcher.find()) {
                String randomValue;
                String type;
                hasRandoms = true;
                switch (type = matcher.group(1).trim().toLowerCase()) {
                    case "port": {
                        randomValue = String.valueOf(SocketUtils.findAvailableTcpPort());
                        break;
                    }
                    case "int": 
                    case "integer": {
                        randomValue = String.valueOf(this.random.nextInt());
                        break;
                    }
                    case "long": {
                        randomValue = String.valueOf(this.random.nextLong());
                        break;
                    }
                    case "float": {
                        randomValue = String.valueOf(this.random.nextFloat());
                        break;
                    }
                    case "shortuuid": {
                        randomValue = UUID.randomUUID().toString().substring(25, 35);
                        break;
                    }
                    case "uuid": {
                        randomValue = UUID.randomUUID().toString();
                        break;
                    }
                    case "uuid2": {
                        randomValue = UUID.randomUUID().toString().replace("-", "");
                        break;
                    }
                    default: {
                        throw new ConfigurationException("Invalid random expression " + matcher.group(0) + " for property: " + property);
                    }
                }
                matcher.appendReplacement(newValue, randomValue);
            }
            if (hasRandoms) {
                matcher.appendTail(newValue);
                return newValue.toString();
            }
        }
        return str;
    }

    protected Map<String, Object> resolveEntriesForKey(String name, boolean allowCreate) {
        return this.resolveEntriesForKey(name, allowCreate, null);
    }

    protected Map<String, Object> resolveEntriesForKey(String name, boolean allowCreate, @Nullable StringConvention convention) {
        int index;
        Map<String, Object> entries = null;
        if (name.length() == 0) {
            return null;
        }
        Map<String, Object>[] catalog = convention == StringConvention.RAW ? this.rawCatalog : this.catalog;
        char firstChar = name.charAt(0);
        if (Character.isLetter(firstChar) && (index = firstChar - 65) < catalog.length && index > 0) {
            entries = catalog[index];
            if (allowCreate && entries == null) {
                catalog[index] = entries = new LinkedHashMap<String, Object>(5);
            }
        }
        return entries;
    }

    protected void resetCaches() {
        this.containsCache.clear();
        this.resolvedValueCache.clear();
    }

    private void processSubmapKey(Map<String, Object> map, String key, Object value, @Nullable StringConvention keyConvention) {
        boolean hasKeyConvention;
        int index = key.indexOf(46);
        boolean bl = hasKeyConvention = keyConvention != null;
        if (index == -1) {
            key = hasKeyConvention ? keyConvention.format(key) : key;
            map.put(key, value);
        } else {
            Object v;
            String mapKey = key.substring(0, index);
            String string = mapKey = hasKeyConvention ? keyConvention.format(mapKey) : mapKey;
            if (!map.containsKey(mapKey)) {
                map.put(mapKey, new LinkedHashMap());
            }
            if ((v = map.get(mapKey)) instanceof Map) {
                Map nestedMap = (Map)v;
                String nestedKey = key.substring(index + 1);
                this.processSubmapKey(nestedMap, nestedKey, value, keyConvention);
            } else {
                map.put(mapKey, v);
            }
        }
    }

    private String normalizeName(String name) {
        return name.replace('-', '.');
    }

    private Object resolvePlaceHoldersIfNecessary(Object value) {
        if (value instanceof CharSequence) {
            return this.propertyPlaceholderResolver.resolveRequiredPlaceholders(((Object)value).toString());
        }
        if (value instanceof List) {
            List list = value;
            ArrayList newList = new ArrayList(list);
            ListIterator<Object> i = newList.listIterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof CharSequence) {
                    i.set(this.resolvePlaceHoldersIfNecessary(o));
                    continue;
                }
                if (!(o instanceof Map)) continue;
                Map submap = (Map)o;
                LinkedHashMap newMap = new LinkedHashMap(submap.size());
                for (Map.Entry entry : submap.entrySet()) {
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    newMap.put(k, this.resolvePlaceHoldersIfNecessary(v));
                }
                i.set(newMap);
            }
            value = newList;
        }
        return value;
    }

    private List<String> resolvePropertiesForConvention(String property, PropertySource.PropertyConvention convention) {
        if (convention == PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE) {
            property = property.toLowerCase(Locale.ENGLISH);
            ArrayList<Integer> separatorIndexList = new ArrayList<Integer>();
            char[] propertyArr = property.toCharArray();
            for (int i = 0; i < propertyArr.length; ++i) {
                if (propertyArr[i] != '_') continue;
                separatorIndexList.add(i);
            }
            if (!separatorIndexList.isEmpty()) {
                int[] separatorIndexes = separatorIndexList.stream().mapToInt(Integer::intValue).toArray();
                int separatorCount = separatorIndexes.length;
                int[] halves = new int[separatorCount];
                byte[] separator = new byte[separatorCount];
                int permutations = (int)Math.pow(2.0, separatorCount);
                for (int i = 0; i < halves.length; ++i) {
                    int start = i == 0 ? permutations : halves[i - 1];
                    halves[i] = start / 2;
                }
                String[] properties = new String[permutations];
                for (int i = 0; i < permutations; ++i) {
                    int round = i + 1;
                    for (int s = 0; s < separatorCount; ++s) {
                        propertyArr[separatorIndexes[s]] = DOT_DASH[separator[s]];
                        if (round % halves[s] != 0) continue;
                        int n = s;
                        separator[n] = (byte)(separator[n] ^ 1);
                    }
                    properties[i] = new String(propertyArr);
                }
                return Arrays.asList(properties);
            }
            return Collections.singletonList(property);
        }
        return Collections.singletonList(NameUtils.hyphenate((String)property, (boolean)true));
    }

    private String trimIndex(String name) {
        int i = name.indexOf(91);
        if (i > -1 && name.endsWith("]")) {
            name = name.substring(0, i);
        }
        return name;
    }

    private void fill(List list, Integer toIndex, Object value) {
        if (toIndex >= list.size()) {
            for (int i = list.size(); i <= toIndex; ++i) {
                list.add(i, value);
            }
        }
    }
}

