/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.beans.visitor.BeanPropertyWriter;
import java.util.Objects;

@Internal
final class BeanFieldWriter
extends BeanPropertyWriter {
    private final FieldElement fieldElement;

    BeanFieldWriter(@NonNull BeanIntrospectionWriter introspectionWriter, @NonNull Type fieldType, @NonNull Type fieldGenericType, FieldElement fieldElement, int index) {
        super(introspectionWriter, fieldElement.getType(), fieldType, fieldGenericType, fieldElement.getName(), null, null, null, fieldElement.isFinal(), index, fieldElement.getAnnotationMetadata(), fieldElement.getGenericField().getTypeArguments());
        this.fieldElement = Objects.requireNonNull(fieldElement, "Field element cannot be null");
    }

    @Override
    protected void writeWriteMethod(GeneratorAdapter writeMethod) {
        writeMethod.putField(this.beanType, this.fieldElement.getName(), this.propertyType);
    }

    @Override
    protected void writeReadMethod(GeneratorAdapter readMethod) {
        readMethod.getField(this.beanType, this.fieldElement.getName(), this.propertyType);
    }
}

