/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class AbstractInterceptorChain<B, R>
implements InvocationContext<B, R> {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    protected final Interceptor<B, R>[] interceptors;
    protected final Object[] originalParameters;
    protected final int interceptorCount;
    protected volatile MutableConvertibleValues<Object> attributes;
    protected int index = 0;
    protected volatile Map<String, MutableArgumentValue<?>> parameters;

    AbstractInterceptorChain(Interceptor<B, R>[] interceptors, Object ... originalParameters) {
        this.interceptors = interceptors;
        this.interceptorCount = interceptors.length;
        this.originalParameters = originalParameters;
    }

    @Override
    @NonNull
    public Object[] getParameterValues() {
        return this.originalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues localAttributes = this.attributes;
        if (localAttributes == null) {
            AbstractInterceptorChain abstractInterceptorChain = this;
            synchronized (abstractInterceptorChain) {
                localAttributes = this.attributes;
                if (localAttributes == null) {
                    this.attributes = localAttributes = MutableConvertibleValues.of(new ConcurrentHashMap(5));
                }
            }
        }
        return localAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map<String, MutableArgumentValue<?>> getParameters() {
        Map<String, MutableArgumentValue<?>> localParameters = this.parameters;
        if (localParameters == null) {
            AbstractInterceptorChain abstractInterceptorChain = this;
            synchronized (abstractInterceptorChain) {
                localParameters = this.parameters;
                if (localParameters == null) {
                    Argument[] arguments = this.getArguments();
                    localParameters = new LinkedHashMap(arguments.length);
                    int i = 0;
                    while (i < arguments.length) {
                        final Argument argument = arguments[i];
                        final int finalIndex = i++;
                        localParameters.put(argument.getName(), new MutableArgumentValue<Object>(){

                            public AnnotationMetadata getAnnotationMetadata() {
                                return argument.getAnnotationMetadata();
                            }

                            public Optional<Argument<?>> getFirstTypeVariable() {
                                return argument.getFirstTypeVariable();
                            }

                            public Argument[] getTypeParameters() {
                                return argument.getTypeParameters();
                            }

                            public Map<String, Argument<?>> getTypeVariables() {
                                return argument.getTypeVariables();
                            }

                            @NonNull
                            public String getName() {
                                return argument.getName();
                            }

                            @NonNull
                            public Class<Object> getType() {
                                return argument.getType();
                            }

                            public boolean equalsType(@Nullable Argument<?> other) {
                                return argument.equalsType(other);
                            }

                            public int typeHashCode() {
                                return argument.typeHashCode();
                            }

                            public Object getValue() {
                                return AbstractInterceptorChain.this.originalParameters[finalIndex];
                            }

                            public void setValue(Object value) {
                                AbstractInterceptorChain.this.originalParameters[finalIndex] = value;
                            }
                        });
                    }
                    localParameters = Collections.unmodifiableMap(localParameters);
                    this.parameters = localParameters;
                }
            }
        }
        return localParameters;
    }

    @Override
    public R proceed(@NonNull Interceptor from) throws RuntimeException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            Interceptor<B, R> interceptor = this.interceptors[i];
            if (interceptor != from) continue;
            this.index = i + 1;
            return this.proceed();
        }
        throw new IllegalArgumentException("Argument [" + from + "] is not within the interceptor chain");
    }

    @NonNull
    protected static Collection<AnnotationValue<?>> resolveInterceptorValues(@NonNull AnnotationMetadata annotationMetadata, @NonNull InterceptorKind kind) {
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            List declaredValues = annotationMetadata.getDeclaredMetadata().getAnnotationValuesByType(InterceptorBinding.class);
            List parentValues = ((AnnotationMetadataHierarchy)annotationMetadata).getRootMetadata().getAnnotationValuesByType(InterceptorBinding.class);
            if (CollectionUtils.isNotEmpty((Collection)declaredValues) || CollectionUtils.isNotEmpty((Collection)parentValues)) {
                InterceptorKind specifiedkind;
                String annotationName;
                HashSet resolved = new HashSet(declaredValues.size() + parentValues.size());
                HashSet<String> declared = new HashSet<String>(declaredValues.size());
                for (AnnotationValue declaredValue : declaredValues) {
                    annotationName = declaredValue.stringValue().orElse(null);
                    if (annotationName == null || (specifiedkind = (InterceptorKind)declaredValue.enumValue("kind", InterceptorKind.class).orElse(null)) != null && !specifiedkind.equals((Object)kind)) continue;
                    if (!annotationMetadata.isRepeatableAnnotation(annotationName)) {
                        declared.add(annotationName);
                    }
                    resolved.add(declaredValue);
                }
                for (AnnotationValue parentValue : parentValues) {
                    annotationName = parentValue.stringValue().orElse(null);
                    if (annotationName == null || declared.contains(annotationName) || (specifiedkind = (InterceptorKind)parentValue.enumValue("kind", InterceptorKind.class).orElse(null)) != null && !specifiedkind.equals((Object)kind)) continue;
                    resolved.add(parentValue);
                }
                return resolved;
            }
            return Collections.emptyList();
        }
        List bindings = annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class);
        if (CollectionUtils.isNotEmpty((Collection)bindings)) {
            return bindings.stream().filter(av -> {
                if (!av.stringValue().isPresent()) {
                    return false;
                }
                InterceptorKind specifiedkind = av.enumValue("kind", InterceptorKind.class).orElse(null);
                return specifiedkind == null || specifiedkind.equals((Object)kind);
            }).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }
}

