/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public abstract class PublicAbstractMethodVisitor<R, P>
extends PublicMethodVisitor<R, P> {
    private final TypeElement classElement;
    private final ModelUtils modelUtils;
    private final Elements elementUtils;
    private Map<String, List<ExecutableElement>> declaredMethods = new HashMap<String, List<ExecutableElement>>();

    PublicAbstractMethodVisitor(TypeElement classElement, JavaVisitorContext visitorContext) {
        super(visitorContext);
        this.classElement = classElement;
        this.modelUtils = visitorContext.getModelUtils();
        this.elementUtils = visitorContext.getElements();
    }

    @Override
    protected boolean isAcceptable(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            ExecutableElement executableElement = (ExecutableElement)element;
            Set<Modifier> modifiers = executableElement.getModifiers();
            String methodName = executableElement.getSimpleName().toString();
            boolean acceptable = this.isAcceptableMethod(executableElement) && !modifiers.contains((Object)Modifier.FINAL) && !modifiers.contains((Object)Modifier.STATIC);
            boolean isDeclared = executableElement.getEnclosingElement().equals(this.classElement);
            if (acceptable && !isDeclared && this.declaredMethods.containsKey(methodName)) {
                for (ExecutableElement ex : this.declaredMethods.get(methodName)) {
                    if (!this.elementUtils.overrides(ex, executableElement, this.classElement)) continue;
                    return false;
                }
            } else if (!acceptable && !this.modelUtils.isStatic(executableElement)) {
                List declaredMethodList = this.declaredMethods.computeIfAbsent(methodName, s -> new ArrayList());
                declaredMethodList.add(executableElement);
            }
            return acceptable;
        }
        return false;
    }

    protected boolean isAcceptableMethod(ExecutableElement executableElement) {
        return this.modelUtils.isAbstract(executableElement);
    }
}

