/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.core.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.spring.core.annotation.MergedAnnotationValue;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationSelector;
import org.springframework.core.annotation.MergedAnnotations;

@Internal
public class MicronautMergedAnnotations
implements MergedAnnotations {
    private final AnnotationMetadata annotationMetadata;

    public MicronautMergedAnnotations(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    public <A extends Annotation> boolean isPresent(Class<A> annotationType) {
        return this.annotationMetadata.hasAnnotation(annotationType) || this.annotationMetadata.hasStereotype(annotationType);
    }

    public boolean isPresent(String annotationType) {
        return this.annotationMetadata.hasAnnotation(annotationType) || this.annotationMetadata.hasStereotype(annotationType);
    }

    public <A extends Annotation> boolean isDirectlyPresent(Class<A> annotationType) {
        return this.annotationMetadata.hasDeclaredAnnotation(annotationType);
    }

    public boolean isDirectlyPresent(String annotationType) {
        return this.annotationMetadata.hasDeclaredAnnotation(annotationType);
    }

    public <A extends Annotation> MergedAnnotation<A> get(Class<A> annotationType) {
        AnnotationValue av = this.annotationMetadata.getAnnotation(annotationType);
        if (av != null) {
            return new MergedAnnotationValue(this.annotationMetadata, av);
        }
        return MergedAnnotation.missing();
    }

    public <A extends Annotation> MergedAnnotation<A> get(Class<A> annotationType, Predicate<? super MergedAnnotation<A>> predicate) {
        AnnotationValue av = this.annotationMetadata.getAnnotation(annotationType);
        return this.resolveAnnotationValueToMergedAnnotation(predicate, av);
    }

    public <A extends Annotation> MergedAnnotation<A> get(Class<A> annotationType, Predicate<? super MergedAnnotation<A>> predicate, MergedAnnotationSelector<A> selector) {
        AnnotationValue av = this.annotationMetadata.getAnnotation(annotationType);
        return this.resolveAnnotationValueToMergedAnnotation(predicate, av);
    }

    public <A extends Annotation> MergedAnnotation<A> get(String annotationType) {
        AnnotationValue av = this.annotationMetadata.getAnnotation(annotationType);
        if (av != null) {
            return new MergedAnnotationValue(this.annotationMetadata, av);
        }
        return MergedAnnotation.missing();
    }

    public <A extends Annotation> MergedAnnotation<A> get(String annotationType, Predicate<? super MergedAnnotation<A>> predicate) {
        AnnotationValue av = this.annotationMetadata.getAnnotation(annotationType);
        return this.resolveAnnotationValueToMergedAnnotation(predicate, av);
    }

    private <A extends Annotation> MergedAnnotation<A> resolveAnnotationValueToMergedAnnotation(Predicate<? super MergedAnnotation<A>> predicate, AnnotationValue<A> av) {
        if (av != null) {
            MergedAnnotationValue<A> ma = new MergedAnnotationValue<A>(this.annotationMetadata, av);
            if (predicate != null && !predicate.test(ma)) {
                return MergedAnnotation.missing();
            }
            return ma;
        }
        return MergedAnnotation.missing();
    }

    public <A extends Annotation> MergedAnnotation<A> get(String annotationType, Predicate<? super MergedAnnotation<A>> predicate, MergedAnnotationSelector<A> selector) {
        AnnotationValue av = this.annotationMetadata.getAnnotation(annotationType);
        return this.resolveAnnotationValueToMergedAnnotation(predicate, av);
    }

    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(Class<A> annotationType) {
        MergedAnnotation<A> ma = this.get(annotationType);
        if (ma != null) {
            return Stream.of(ma);
        }
        return Stream.empty();
    }

    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(String annotationType) {
        MergedAnnotation<A> ma = this.get(annotationType);
        if (ma != null) {
            return Stream.of(ma);
        }
        return Stream.empty();
    }

    public Stream<MergedAnnotation<Annotation>> stream() {
        return this.annotationMetadata.getAnnotationNames().stream().map(arg_0 -> ((AnnotationMetadata)this.annotationMetadata).getAnnotation(arg_0)).filter(Objects::nonNull).map(av -> new MergedAnnotationValue(this.annotationMetadata, av));
    }

    public Iterator<MergedAnnotation<Annotation>> iterator() {
        return this.stream().iterator();
    }
}

