/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.yaml.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import groovy.yaml.YamlRuntimeException;
import java.io.IOException;
import java.io.Reader;

public class YamlConverter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String convertYamlToJson(Reader yamlReader) {
        try (Reader reader = yamlReader;){
            Object yaml = new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(reader, Object.class);
            String string = new ObjectMapper().writeValueAsString(yaml);
            return string;
        }
        catch (IOException e) {
            throw new YamlRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String convertJsonToYaml(Reader jsonReader) {
        try (Reader reader = jsonReader;){
            JsonNode json = new ObjectMapper().readTree(reader);
            String string = new YAMLMapper().writeValueAsString((Object)json);
            return string;
        }
        catch (IOException e) {
            throw new YamlRuntimeException(e);
        }
    }

    private YamlConverter() {
    }
}

