/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.antlr;

import groovy.lang.groovydoc.Groovydoc;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyFieldDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAnnotationRef;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;
import org.codehaus.groovy.transform.trait.Traits;

public class GroovydocVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit unit;
    private final List<LinkArgument> links;
    private String packagePath;
    private SimpleGroovyClassDoc currentClassDoc = null;
    private Map<String, GroovyClassDoc> classDocs = new HashMap<String, GroovyClassDoc>();
    private final Properties properties;
    private static final String FS = "/";
    private static final Pattern JAVADOC_COMMENT_PATTERN = Pattern.compile("(?s)/\\*\\*(.*?)\\*/");

    public GroovydocVisitor(SourceUnit unit, String packagePath, List<LinkArgument> links) {
        this(unit, packagePath, links, new Properties());
    }

    public GroovydocVisitor(SourceUnit unit, String packagePath, List<LinkArgument> links, Properties properties) {
        this.unit = unit;
        this.packagePath = packagePath;
        this.links = links;
        this.properties = properties;
    }

    protected SourceUnit getSourceUnit() {
        return this.unit;
    }

    public void visitClass(ClassNode node) {
        String name;
        boolean isSynthetic;
        boolean bl = isSynthetic = (node.getModifiers() & 0x1000) != 0;
        if (isSynthetic || node.isSynthetic()) {
            return;
        }
        HashMap<String, String> aliases = new HashMap<String, String>();
        ArrayList<String> imports = new ArrayList<String>();
        for (ClassNode[] iNode : node.getModule().getImports()) {
            name = iNode.getClassName();
            imports.add(name.replace('.', '/'));
            if (iNode.getAlias() == null || iNode.getAlias().isEmpty()) continue;
            aliases.put(iNode.getAlias(), name.replace('.', '/'));
        }
        for (ClassNode[] iNode : node.getModule().getStarImports()) {
            name = iNode.getPackageName() + "*";
            imports.add(name.replace('.', '/'));
        }
        String name2 = node.getNameWithoutPackage();
        if (node instanceof InnerClassNode) {
            name2 = name2.replace('$', '.');
        }
        this.currentClassDoc = new SimpleGroovyClassDoc(this.withDefaultImports(imports), aliases, name2, this.links);
        if (node.isEnum()) {
            this.currentClassDoc.setTokenType(61);
        } else if (node.isRecord()) {
            this.currentClassDoc.setTokenType(16);
        } else if (node.isAnnotationDefinition()) {
            this.currentClassDoc.setTokenType(64);
        } else if (Traits.isTrait((ClassNode)node)) {
            this.currentClassDoc.setTokenType(15);
        } else if (node.isInterface()) {
            this.currentClassDoc.setTokenType(14);
        }
        if (node.isScript()) {
            if ("false".equals(this.properties.getProperty("processScripts", "true"))) {
                return;
            }
            this.currentClassDoc.setScript(true);
        }
        for (ClassNode iface : node.getInterfaces()) {
            this.currentClassDoc.addInterfaceName(this.makeType(iface));
        }
        this.currentClassDoc.setRawCommentText(this.getDocContent(node.getGroovydoc()));
        this.currentClassDoc.setNameWithTypeArgs(name2 + this.genericTypesAsString(node.getGenericsTypes()));
        if (!node.isInterface() && node.getSuperClass() != null) {
            String superName = this.makeType(node.getSuperClass());
            this.currentClassDoc.setSuperClassName(superName);
            String superSimpleName = node.getSuperClass().getNameWithoutPackage();
            if (!this.classDocs.containsKey(superSimpleName)) {
                SimpleGroovyClassDoc superDoc = new SimpleGroovyClassDoc(imports, superName);
                superDoc.setFullPathName(superName);
            }
        }
        this.processModifiers(this.currentClassDoc, (AnnotatedNode)node, node.getModifiers());
        this.processAnnotations(this.currentClassDoc, (AnnotatedNode)node);
        if (Modifier.isAbstract(node.getModifiers())) {
            this.currentClassDoc.setAbstract(true);
        }
        this.currentClassDoc.setFullPathName(this.packagePath + FS + name2);
        this.currentClassDoc.setGroovy(true);
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        super.visitClass(node);
        SimpleGroovyClassDoc parent = this.currentClassDoc;
        if (this.currentClassDoc.isClass() && this.currentClassDoc.constructors().length == 0) {
            SimpleGroovyConstructorDoc cons = new SimpleGroovyConstructorDoc(name2, this.currentClassDoc);
            cons.setPublic(true);
            this.currentClassDoc.add(cons);
        }
        Iterator innerClasses = node.getInnerClasses();
        while (innerClasses.hasNext()) {
            this.visitClass((ClassNode)innerClasses.next());
            parent.addNested(this.currentClassDoc);
            this.currentClassDoc = parent;
        }
    }

    private List<String> withDefaultImports(List<String> imports) {
        imports = imports != null ? imports : new ArrayList<String>();
        imports.add(this.packagePath + "/*");
        for (String pkg : ResolveVisitor.DEFAULT_IMPORTS) {
            imports.add(pkg.replace('.', '/') + "*");
        }
        return imports;
    }

    private String getDocContent(Groovydoc groovydoc) {
        Matcher m;
        if (groovydoc == null) {
            return "";
        }
        String result = groovydoc.getContent();
        if (result == null) {
            result = "";
        }
        if ((m = JAVADOC_COMMENT_PATTERN.matcher(result)).find()) {
            result = m.group(1).trim();
        }
        return result;
    }

    private void processAnnotations(SimpleGroovyProgramElementDoc element, AnnotatedNode node) {
        for (AnnotationNode an : node.getAnnotations()) {
            String name = an.getClassNode().getName();
            element.addAnnotationRef(new SimpleGroovyAnnotationRef(name, an.getText()));
        }
    }

    private void processAnnotations(SimpleGroovyParameter param, AnnotatedNode node) {
        for (AnnotationNode an : node.getAnnotations()) {
            String name = an.getClassNode().getName();
            param.addAnnotationRef(new SimpleGroovyAnnotationRef(name, an.getText()));
        }
    }

    public void visitConstructor(ConstructorNode node) {
        boolean isSynthetic;
        boolean bl = isSynthetic = (node.getModifiers() & 0x1000) != 0;
        if (isSynthetic || node.isSynthetic()) {
            return;
        }
        SimpleGroovyConstructorDoc cons = new SimpleGroovyConstructorDoc(this.currentClassDoc.simpleTypeName(), this.currentClassDoc);
        this.setConstructorOrMethodCommon((MethodNode)node, cons);
        this.currentClassDoc.add(cons);
        super.visitConstructor(node);
    }

    public void visitMethod(MethodNode node) {
        boolean isSynthetic;
        if (this.currentClassDoc.isEnum() && "$INIT".equals(node.getName())) {
            return;
        }
        boolean bl = isSynthetic = (node.getModifiers() & 0x1000) != 0;
        if (isSynthetic || node.isSynthetic()) {
            return;
        }
        if ("false".equals(this.properties.getProperty("includeMainForScripts", "true")) && this.currentClassDoc.isScript() && "main".equals(node.getName()) && node.isStatic() && node.getParameters().length == 1) {
            return;
        }
        SimpleGroovyMethodDoc meth = new SimpleGroovyMethodDoc(node.getName(), this.currentClassDoc);
        meth.setReturnType(new SimpleGroovyType(this.makeType(node.getReturnType())));
        this.setConstructorOrMethodCommon(node, meth);
        this.currentClassDoc.add(meth);
        this.processPropertiesFromGetterSetter(meth);
        super.visitMethod(node);
        meth.setTypeParameters(this.genericTypesAsString(node.getGenericsTypes()));
    }

    private String genericTypesAsString(GenericsType[] genericsTypes) {
        if (genericsTypes == null || genericsTypes.length == 0) {
            return "";
        }
        return "<" + DefaultGroovyMethods.join((Object[])genericsTypes, (String)", ") + ">";
    }

    private void processPropertiesFromGetterSetter(SimpleGroovyMethodDoc currentMethodDoc) {
        String propName;
        String prefix;
        String methodName = currentMethodDoc.name();
        int len = methodName.length();
        if (len > 3 && methodName.startsWith("get")) {
            prefix = "get";
            propName = methodName.substring(3);
        } else if (len > 3 && methodName.startsWith("set")) {
            prefix = "set";
            propName = methodName.substring(3);
        } else if (len > 2 && methodName.startsWith("is")) {
            prefix = "is";
            propName = methodName.substring(2);
        } else {
            return;
        }
        for (GroovyFieldDoc field : this.currentClassDoc.properties()) {
            if (!propName.equals(field.name())) continue;
            return;
        }
        SimpleGroovyClassDoc classDoc = this.currentClassDoc;
        if (classDoc == null) {
            return;
        }
        GroovyMethodDoc[] methods = classDoc.methods();
        String expectedMethodName = "set".equals(prefix) && currentMethodDoc.parameters().length >= 1 && !currentMethodDoc.parameters()[0].typeName().equals("boolean") ? "get" + propName : ("get".equals(prefix) && !currentMethodDoc.returnType().typeName().equals("boolean") ? "set" + propName : ("is".equals(prefix) ? "set" + propName : "is" + propName));
        for (GroovyMethodDoc methodDoc : methods) {
            if (!methodDoc.name().equals(expectedMethodName)) continue;
            String fieldName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
            SimpleGroovyFieldDoc currentFieldDoc = new SimpleGroovyFieldDoc(fieldName, classDoc);
            if (expectedMethodName.startsWith("set") && methodDoc.parameters().length >= 1) {
                String typeName = methodDoc.parameters()[0].typeName();
                currentFieldDoc.setType(new SimpleGroovyType(typeName));
            } else {
                currentFieldDoc.setType(methodDoc.returnType());
            }
            if (!methodDoc.isPublic() || !currentMethodDoc.isPublic()) continue;
            classDoc.addProperty(currentFieldDoc);
            break;
        }
    }

    public void visitProperty(PropertyNode node) {
        String name = node.getName();
        SimpleGroovyFieldDoc fieldDoc = new SimpleGroovyFieldDoc(name, this.currentClassDoc);
        fieldDoc.setType(new SimpleGroovyType(this.makeType(node.getType())));
        int mods = node.getModifiers();
        if (!this.hasAnno((AnnotatedNode)node.getField(), "PackageScope")) {
            this.processModifiers(fieldDoc, (AnnotatedNode)node.getField(), mods);
            Groovydoc groovydoc = node.getGroovydoc();
            fieldDoc.setRawCommentText(groovydoc == null ? "" : this.getDocContent(groovydoc));
            this.currentClassDoc.addProperty(fieldDoc);
        }
        this.processAnnotations(fieldDoc, (AnnotatedNode)node.getField());
        super.visitProperty(node);
    }

    private String makeType(ClassNode node) {
        ClassNode cn = node.isArray() ? node.getComponentType() : node;
        return cn.getName().replace('.', '/').replace('$', '.') + this.genericTypesAsString(cn.getGenericsTypes()) + (node.isArray() ? "[]" : "");
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        if (this.currentClassDoc.isScript() && this.hasAnno((AnnotatedNode)expression, "Field")) {
            boolean isProp;
            VariableExpression varx = expression.getVariableExpression();
            SimpleGroovyFieldDoc field = new SimpleGroovyFieldDoc(varx.getName(), this.currentClassDoc);
            field.setType(new SimpleGroovyType(this.makeType(varx.getType())));
            int mods = varx.getModifiers();
            this.processModifiers(field, (AnnotatedNode)varx, mods);
            boolean bl = isProp = (mods & 7) == 0;
            if (isProp) {
                this.currentClassDoc.addProperty(field);
            } else {
                this.currentClassDoc.add(field);
            }
        }
        super.visitDeclarationExpression(expression);
    }

    private void processModifiers(SimpleGroovyProgramElementDoc element, AnnotatedNode node, int mods) {
        if (Modifier.isStatic(mods)) {
            element.setStatic(true);
        }
        if (this.hasAnno(node, "PackageScope")) {
            element.setPackagePrivate(true);
        } else if (Modifier.isPublic(mods)) {
            element.setPublic(true);
        } else if (Modifier.isProtected(mods)) {
            element.setProtected(true);
        } else if (Modifier.isPrivate(mods)) {
            element.setPrivate(true);
        } else {
            element.setPackagePrivate(true);
        }
        if (Modifier.isFinal(mods)) {
            element.setFinal(true);
        }
    }

    public void visitField(FieldNode node) {
        boolean isSynthetic;
        boolean bl = isSynthetic = (node.getModifiers() & 0x1000) != 0;
        if (isSynthetic || node.isSynthetic()) {
            return;
        }
        String name = node.getName();
        SimpleGroovyFieldDoc fieldDoc = new SimpleGroovyFieldDoc(name, this.currentClassDoc);
        fieldDoc.setType(new SimpleGroovyType(this.makeType(node.getType())));
        this.processModifiers(fieldDoc, (AnnotatedNode)node, node.getModifiers());
        this.processAnnotations(fieldDoc, (AnnotatedNode)node);
        fieldDoc.setRawCommentText(this.getDocContent(node.getGroovydoc()));
        this.currentClassDoc.add(fieldDoc);
        super.visitField(node);
    }

    private void setConstructorOrMethodCommon(MethodNode node, SimpleGroovyExecutableMemberDoc methOrCons) {
        methOrCons.setRawCommentText(this.getDocContent(node.getGroovydoc()));
        this.processModifiers(methOrCons, (AnnotatedNode)node, node.getModifiers());
        this.processAnnotations(methOrCons, (AnnotatedNode)node);
        if (node.isAbstract()) {
            methOrCons.setAbstract(true);
        }
        for (Parameter param : node.getParameters()) {
            SimpleGroovyParameter p = new SimpleGroovyParameter(param.getName());
            p.setType(new SimpleGroovyType(this.makeType(param.getType())));
            this.processAnnotations(p, (AnnotatedNode)param);
            methOrCons.add(p);
        }
    }

    private boolean hasAnno(AnnotatedNode node, String annoSuffix) {
        for (AnnotationNode annotationNode : node.getAnnotations()) {
            if (!annotationNode.getClassNode().getName().endsWith(annoSuffix)) continue;
            return true;
        }
        return false;
    }

    public Map<String, GroovyClassDoc> getGroovyClassDocs() {
        return this.classDocs;
    }
}

