/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcherKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "", "classpath", "", "", "checkPeriod", "", "digestCheckPeriod", "(Ljava/lang/Iterable;JJ)V", "getCheckPeriod", "()J", "getDigestCheckPeriod", "fileIds", "", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "fileIdsLock", "Ljava/util/concurrent/Semaphore;", "isChanged", "", "()Z", "lastChangedStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastDigestUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "lastUpdate", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "FileId", "daemon"})
public final class LazyClasspathWatcher {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Semaphore fileIdsLock;
    private List<FileId> fileIds;
    private final AtomicBoolean lastChangedStatus;
    private final AtomicLong lastUpdate;
    private final AtomicLong lastDigestUpdate;
    private final Lazy log$delegate;
    private final long checkPeriod;
    private final long digestCheckPeriod;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(LazyClasspathWatcher.class), "log", "getLog()Ljava/util/logging/Logger;"))};
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        LazyClasspathWatcher lazyClasspathWatcher = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Logger)lazy.getValue();
    }

    public final boolean isChanged() {
        FileId fileId;
        if (this.lastChangedStatus.get()) {
            return true;
        }
        long nowMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (nowMs - this.lastUpdate.get() < this.checkPeriod) {
            return false;
        }
        boolean checkDigest = nowMs - this.lastDigestUpdate.get() > this.digestCheckPeriod;
        this.fileIdsLock.acquire();
        this.fileIdsLock.release();
        List<FileId> list2 = this.fileIds;
        if (list2 != null) {
            Object v2;
            block12: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)list2;
                for (Object t : iterable2) {
                    boolean bl;
                    FileId it = (FileId)t;
                    try {
                        boolean bl2;
                        if (!it.getFile().exists()) {
                            this.getLog().info("cp changed: " + it.getFile() + " doesn't exist any more");
                            bl2 = true;
                        } else if ((it.getFile().lastModified() != it.getLastModified() || checkDigest) && !Arrays.equals(it.getDigest(), LazyClasspathWatcherKt.md5Digest(it.getFile()))) {
                            this.getLog().info("cp changed: " + it.getFile() + " digests differ");
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    catch (IOException e) {
                        this.getLog().log(Level.INFO, "cp changed: " + it.getFile() + " access throws the exception", e);
                        bl = true;
                    }
                    if (!bl) continue;
                    v2 = t;
                    break block12;
                }
                v2 = null;
            }
            fileId = v2;
        } else {
            fileId = null;
        }
        boolean changed = fileId != null;
        this.lastUpdate.set(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
        if (checkDigest) {
            this.lastDigestUpdate.set(this.lastUpdate.get());
        }
        return changed;
    }

    public final long getCheckPeriod() {
        return this.checkPeriod;
    }

    public final long getDigestCheckPeriod() {
        return this.digestCheckPeriod;
    }

    public LazyClasspathWatcher(final @NotNull Iterable<String> classpath, long checkPeriod, long digestCheckPeriod) {
        Intrinsics.checkParameterIsNotNull(classpath, "classpath");
        this.checkPeriod = checkPeriod;
        this.digestCheckPeriod = digestCheckPeriod;
        this.fileIdsLock = new Semaphore(1);
        this.lastChangedStatus = new AtomicBoolean(false);
        this.lastUpdate = new AtomicLong(0L);
        this.lastDigestUpdate = new AtomicLong(0L);
        this.log$delegate = LazyKt.lazy(log.2.INSTANCE);
        this.fileIdsLock.acquire();
        Function0 function0 = new Function0<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public final void invoke() {
                try {
                    void var3_7;
                    Collection<File> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Iterable iterable = classpath;
                    LazyClasspathWatcher lazyClasspathWatcher = this;
                    void var2_6 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void p1;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        File file2 = new File((String)p1);
                        collection.add(file2);
                    }
                    collection = (List)var3_7;
                    lazyClasspathWatcher.fileIds = SequencesKt.toList(SequencesKt.map(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)collection), 2.INSTANCE), 3.INSTANCE));
                    long nowMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    lastUpdate.set(nowMs);
                    lastDigestUpdate.set(nowMs);
                }
                catch (IOException e) {
                    this.getLog().log(Level.WARNING, "Error on walking classpath", e);
                }
                finally {
                    fileIdsLock.release();
                }
            }
        };
        int n = 0;
        String string = null;
        ClassLoader classLoader = null;
        boolean bl = true;
        boolean bl2 = true;
        ThreadsKt.thread$default(bl, bl2, classLoader, string, n, function0, 28, null);
    }

    public /* synthetic */ LazyClasspathWatcher(Iterable iterable, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_WATCH_PERIOD_MS();
        }
        if ((n & 4) != 0) {
            l2 = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS();
        }
        this(iterable, l, l2);
    }

    @Nullable
    public static final /* synthetic */ List access$getFileIds$p(LazyClasspathWatcher $this) {
        return $this.fileIds;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "", "file", "Ljava/io/File;", "lastModified", "", "digest", "", "(Ljava/io/File;J[B)V", "getDigest", "()[B", "getFile", "()Ljava/io/File;", "getLastModified", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "daemon"})
    private static final class FileId {
        @NotNull
        private final File file;
        private final long lastModified;
        @NotNull
        private final byte[] digest;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] getDigest() {
            return this.digest;
        }

        public FileId(@NotNull File file2, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Intrinsics.checkParameterIsNotNull(digest, "digest");
            this.file = file2;
            this.lastModified = lastModified;
            this.digest = digest;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] component3() {
            return this.digest;
        }

        @NotNull
        public final FileId copy(@NotNull File file2, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Intrinsics.checkParameterIsNotNull(digest, "digest");
            return new FileId(file2, lastModified, digest);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ FileId copy$default(FileId fileId, File file2, long l, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                file2 = fileId.file;
            }
            if ((n & 2) != 0) {
                l = fileId.lastModified;
            }
            if ((n & 4) != 0) {
                byArray = fileId.digest;
            }
            return fileId.copy(file2, l, byArray);
        }

        public String toString() {
            return "FileId(file=" + this.file + ", lastModified=" + this.lastModified + ", digest=" + Arrays.toString(this.digest) + ")";
        }

        public int hashCode() {
            File file2 = this.file;
            long l = this.lastModified;
            return ((file2 != null ? ((Object)file2).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (this.digest != null ? Arrays.hashCode(this.digest) : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileId)) break block3;
                    FileId fileId = (FileId)object;
                    if (!Intrinsics.areEqual(this.file, fileId.file) || !(this.lastModified == fileId.lastModified) || !Intrinsics.areEqual(this.digest, fileId.digest)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

