/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BridgeForBuiltinSpecial;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.GenerateJava8ParameterNamesKt;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.JvmStaticInCompanionObjectGenerator;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithOnlyTargetedAnnotations;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DefaultImplsClassContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.SuspendFunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen {
    public final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final MemberCodegen<?> memberCodegen;
    private final Function1<CallableMemberDescriptor, Boolean> DECLARATION_AND_DEFINITION_CHECKER = new Function1<CallableMemberDescriptor, Boolean>(){

        @Override
        public Boolean invoke(CallableMemberDescriptor descriptor2) {
            return !DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) || FunctionCodegen.this.state.getTarget() != JvmTarget.JVM_1_6 && AnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2);
        }
    };

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state2, @NotNull MemberCodegen<?> memberCodegen) {
        this.owner = owner;
        this.v = v;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.memberCodegen = memberCodegen;
    }

    public void gen(@NotNull KtNamedFunction function2) {
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function2);
        if (this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor) != null) {
            functionDescriptor = (SimpleFunctionDescriptor)this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor);
        }
        if (functionDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("No descriptor for function " + function2.getName(), function2);
        }
        if (this.owner.getContextKind() != OwnerKind.DEFAULT_IMPLS || function2.hasBody()) {
            FunctionGenerationStrategy.CodegenBased strategy = functionDescriptor.isSuspend() && !functionDescriptor.isInline() ? new SuspendFunctionGenerationStrategy(this.state, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor), function2, this.v.getThisName(), this.state.getConstructorCallNormalizationMode()) : new FunctionGenerationStrategy.FunctionDefault(this.state, function2);
            this.generateMethod(JvmDeclarationOriginKt.OtherOrigin(function2, functionDescriptor), functionDescriptor, strategy);
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor, true), functionDescriptor, this.owner.getContextKind(), DefaultParameterValueLoader.DEFAULT, function2);
        this.generateOverloadsWithDefaultValues(function2, functionDescriptor, functionDescriptor);
    }

    public void generateOverloadsWithDefaultValues(@Nullable KtNamedFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionDescriptor delegateFunctionDescriptor) {
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(function2, functionDescriptor, delegateFunctionDescriptor, this.owner.getContextKind(), this.v, this.memberCodegen);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy) {
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            this.generateMethod(origin, CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(descriptor2, this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines), this.bindingContext), strategy);
            return;
        }
        this.generateMethod(origin, descriptor2, this.owner.intoFunction(descriptor2), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        boolean isOpenSuspendInClass;
        boolean staticInCompanionObject;
        OwnerKind contextKind = methodContext.getContextKind();
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isInterface(containingDeclaration) && !FunctionCodegen.processInterfaceMethod(functionDescriptor, contextKind, false, false, this.state.getJvmDefaultMode())) {
            return;
        }
        boolean hasSpecialBridge = this.hasSpecialBridgeMethod(functionDescriptor);
        JvmMethodGenericSignature jvmSignature = strategy.mapMethodSignature(functionDescriptor, this.typeMapper, contextKind, hasSpecialBridge);
        Method asmMethod = jvmSignature.getAsmMethod();
        int flags = AsmUtil.getMethodAsmFlags(functionDescriptor, contextKind, this.state);
        if (origin.getOriginKind() == JvmDeclarationOriginKind.SAM_DELEGATION) {
            flags |= 0x1000;
        }
        if (functionDescriptor.isExternal() && this.owner instanceof MultifileClassFacadeContext) {
            return;
        }
        MethodVisitor mv = strategy.wrapMethodVisitor(this.v.newMethod(origin, flags, asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper)), flags, asmMethod.getName(), asmMethod.getDescriptor());
        if (CodegenContextUtil.isImplClassOwner(this.owner)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, CodegenUtilKt.unwrapFrontendVersion(functionDescriptor), asmMethod);
        }
        this.generateMethodAnnotations(functionDescriptor, asmMethod, mv);
        this.generateParameterAnnotations(functionDescriptor, mv, jvmSignature);
        GenerateJava8ParameterNamesKt.generateParameterNames(functionDescriptor, mv, jvmSignature, this.state, (flags & 0x1000) != 0);
        if (contextKind != OwnerKind.ERASED_INLINE_CLASS) {
            this.generateBridges(functionDescriptor);
        }
        if (staticInCompanionObject = CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addAdditionalTask(new JvmStaticInCompanionObjectGenerator(functionDescriptor, origin, this.state, parentBodyCodegen));
        }
        boolean bl = isOpenSuspendInClass = functionDescriptor.isSuspend() && functionDescriptor.getModality() != Modality.ABSTRACT && ModalityKt.isOverridable(functionDescriptor) && !DescriptorUtils.isInterface(containingDeclaration) && !(containingDeclaration instanceof PackageFragmentDescriptor) && origin.getOriginKind() != JvmDeclarationOriginKind.CLASS_MEMBER_DELEGATION_TO_DEFAULT_IMPL;
        if (isOpenSuspendInClass) {
            this.generateOpenMethodInSuspendClass(origin, functionDescriptor, methodContext, strategy, mv, jvmSignature, asmMethod, flags, staticInCompanionObject);
        } else if (FunctionCodegen.shouldDelegateMethodBodyToInlineClass(origin, functionDescriptor, contextKind, containingDeclaration, this.bindingContext)) {
            this.generateMethodInsideInlineClassWrapper(origin, functionDescriptor, (ClassDescriptor)containingDeclaration, mv);
        } else {
            this.generateMethodBody(origin, functionDescriptor, methodContext, strategy, mv, jvmSignature, staticInCompanionObject);
        }
    }

    private static boolean shouldDelegateMethodBodyToInlineClass(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind contextKind, @NotNull DeclarationDescriptor containingDeclaration, @NotNull BindingContext bindingContext) {
        PropertyDescriptor property;
        if (contextKind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        if (origin.getOriginKind() == JvmDeclarationOriginKind.UNBOX_METHOD_OF_INLINE_CLASS) {
            return false;
        }
        if (functionDescriptor instanceof PropertyAccessorDescriptor && JvmCodegenUtil.hasBackingField(property = ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty(), contextKind, bindingContext)) {
            return false;
        }
        boolean isInlineClass = DescriptorUtils.isClass(containingDeclaration) && ((ClassDescriptor)containingDeclaration).isInline();
        boolean simpleFunctionOrProperty = !(functionDescriptor instanceof ConstructorDescriptor) && !KotlinTypeMapper.isAccessor(functionDescriptor);
        return isInlineClass && simpleFunctionOrProperty;
    }

    private void generateMethodInsideInlineClassWrapper(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, ClassDescriptor containingDeclaration, MethodVisitor mv) {
        mv.visitCode();
        Type inlineErasedType = this.typeMapper.mapErasedInlineClass(containingDeclaration);
        Method erasedMethodImpl = this.typeMapper.mapAsmMethod(functionDescriptor.getOriginal(), OwnerKind.ERASED_INLINE_CLASS);
        Type fieldOwnerType = this.typeMapper.mapClass(containingDeclaration);
        ValueParameterDescriptor valueRepresentation = InlineClassesUtilsKt.underlyingRepresentation(containingDeclaration);
        if (valueRepresentation == null) {
            return;
        }
        Type fieldType = this.typeMapper.mapType(valueRepresentation);
        FunctionCodegen.generateDelegateToStaticErasedVersion(mv, erasedMethodImpl, inlineErasedType.getInternalName(), fieldOwnerType, valueRepresentation.getName().asString(), fieldType);
        FunctionCodegen.endVisit(mv, null, origin.getElement());
    }

    private void generateOpenMethodInSuspendClass(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull Method asmMethod, int flags, boolean staticInCompanionObject) {
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        int index2 = 1;
        for (Type type2 : asmMethod.getArgumentTypes()) {
            mv.visitVarInsn(type2.getOpcode(21), index2);
            index2 += type2.getSize();
        }
        Method asmMethodForOpenSuspendImpl = CoroutineCodegenUtilKt.getImplForOpenMethod(asmMethod, this.v.getThisName());
        JvmMethodGenericSignature jvmSignatureForOpenSuspendImpl = new JvmMethodGenericSignature(asmMethodForOpenSuspendImpl, jvmSignature.getValueParameters(), null);
        mv.visitMethodInsn(184, this.v.getThisName(), asmMethodForOpenSuspendImpl.getName(), asmMethodForOpenSuspendImpl.getDescriptor(), false);
        mv.visitInsn(176);
        mv.visitEnd();
        int flagsForOpenSuspendImpl = flags;
        flagsForOpenSuspendImpl |= 0x1008;
        flagsForOpenSuspendImpl &= ~AsmUtil.getVisibilityAccessFlag(functionDescriptor);
        MethodVisitor mvForOpenSuspendImpl = strategy.wrapMethodVisitor(this.v.newMethod(origin, flagsForOpenSuspendImpl |= 0, asmMethodForOpenSuspendImpl.getName(), asmMethodForOpenSuspendImpl.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper)), flagsForOpenSuspendImpl, asmMethodForOpenSuspendImpl.getName(), asmMethodForOpenSuspendImpl.getDescriptor());
        this.generateMethodBody(origin, functionDescriptor, methodContext, strategy, mvForOpenSuspendImpl, jvmSignatureForOpenSuspendImpl, staticInCompanionObject);
    }

    private void generateMethodBody(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, boolean staticInCompanionObject) {
        OwnerKind contextKind = methodContext.getContextKind();
        if (!this.state.getClassBuilderMode().generateBodies || AsmUtil.isAbstractMethod(functionDescriptor, contextKind)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext, this.typeMapper), new Label(), new Label(), contextKind, this.typeMapper, Collections.emptyList(), 0);
            mv.visitEnd();
            return;
        }
        if (!functionDescriptor.isExternal()) {
            FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy, this.memberCodegen, this.state.getJvmDefaultMode());
        } else if (staticInCompanionObject) {
            mv.visitCode();
            FunctionDescriptor staticFunctionDescriptor = JvmStaticInCompanionObjectGenerator.createStaticFunctionDescriptor(functionDescriptor);
            Method accessorMethod = this.typeMapper.mapAsmMethod(this.memberCodegen.getContext().accessibleDescriptor(staticFunctionDescriptor, null));
            Type owningType = this.typeMapper.mapClass((ClassifierDescriptor)staticFunctionDescriptor.getContainingDeclaration());
            FunctionCodegen.generateDelegateToStaticMethodBody(false, mv, accessorMethod, owningType.getInternalName(), false);
        }
        FunctionCodegen.endVisit(mv, null, origin.getElement());
    }

    private void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor, Method asmMethod, MethodVisitor mv) {
        FunctionCodegen.generateMethodAnnotations(functionDescriptor, asmMethod, mv, this.memberCodegen, this.typeMapper);
    }

    public static void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor, Method asmMethod, MethodVisitor mv, @NotNull InnerClassConsumer consumer, @NotNull KotlinTypeMapper typeMapper) {
        AnnotationCodegen annotationCodegen = AnnotationCodegen.forMethod(mv, consumer, typeMapper);
        if (functionDescriptor instanceof PropertyAccessorDescriptor) {
            AnnotationUseSiteTarget target = functionDescriptor instanceof PropertySetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
            annotationCodegen.genAnnotations(functionDescriptor, asmMethod.getReturnType(), target);
        } else {
            annotationCodegen.genAnnotations(functionDescriptor, asmMethod.getReturnType());
        }
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        FunctionCodegen.generateParameterAnnotations(functionDescriptor, mv, jvmSignature, this.memberCodegen, this.state);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state2) {
        FunctionCodegen.generateParameterAnnotations(functionDescriptor, mv, jvmSignature, functionDescriptor.getValueParameters(), innerClassConsumer, state2);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state2) {
        KotlinTypeMapper typeMapper = state2.getTypeMapper();
        Iterator<ValueParameterDescriptor> iterator2 = valueParameters.iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            ReceiverParameterDescriptor receiver;
            AnnotationCodegen annotationCodegen;
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = parameterSignature.getKind();
            if (kind.isSkippedInGenericSignature()) {
                FunctionCodegen.markEnumOrInnerConstructorParameterAsSynthetic(mv, i, state2.getClassBuilderMode());
                continue;
            }
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = iterator2.next();
                annotationCodegen = AnnotationCodegen.forParameter(i, mv, innerClassConsumer, typeMapper);
                if (functionDescriptor instanceof PropertySetterDescriptor) {
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)functionDescriptor).getCorrespondingProperty();
                    AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(propertyDescriptor);
                    annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.SETTER_PARAMETER);
                }
                if (functionDescriptor instanceof ConstructorDescriptor) {
                    annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType(), AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
                    continue;
                }
                annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType());
                continue;
            }
            if (kind != JvmMethodParameterKind.RECEIVER || (receiver = JvmCodegenUtil.getDirectMember(functionDescriptor).getExtensionReceiverParameter()) == null) continue;
            annotationCodegen = AnnotationCodegen.forParameter(i, mv, innerClassConsumer, typeMapper);
            AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(receiver.getType());
            annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.RECEIVER);
            annotationCodegen.genAnnotations(receiver, parameterSignature.getAsmType());
        }
    }

    private static void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i, ClassBuilderMode mode) {
        if (mode == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull KotlinTypeMapper typeMapper) {
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper.mapTypeAsDeclaration(functionDescriptor);
        }
        if (dispatchReceiver != null) {
            return typeMapper.mapTypeAsDeclaration(dispatchReceiver.getType());
        }
        if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isLocalFunction(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
            return typeMapper.mapClass(context.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen, @NotNull JvmDefaultMode jvmDefaultMode) {
        String name;
        int indexOfLambdaOrdinal;
        Label methodEnd;
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        KotlinTypeMapper typeMapper = parentCodegen.typeMapper;
        if (BuiltinSpecialBridgesUtil.shouldHaveTypeSafeBarrier(functionDescriptor, typeMapper::mapAsmMethod)) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(new InstructionAdapter(mv), functionDescriptor, signature.getReturnType(), null);
        }
        int functionFakeIndex = -1;
        int lambdaFakeIndex = -1;
        if (context.getParentContext() instanceof MultifileClassFacadeContext) {
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, signature.getAsmMethod(), (MultifileClassFacadeContext)context.getParentContext());
            methodEnd = new Label();
        } else if (FunctionCodegen.isCompatibilityStubInDefaultImpls(functionDescriptor, context, jvmDefaultMode)) {
            FunctionDescriptor compatibility = ((DefaultImplsClassContext)context.getParentContext()).getInterfaceContext().getAccessorForJvmDefaultCompatibility(functionDescriptor);
            int flags = AsmUtil.getMethodAsmFlags(functionDescriptor, OwnerKind.DEFAULT_IMPLS, context.getState());
            assert ((flags & 0x400) == 0) : "Interface method with body should be non-abstract" + functionDescriptor;
            CallableMethod method = typeMapper.mapToCallableMethod(compatibility, false);
            FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, method.getAsmMethod(), method.getOwner().getInternalName(), true);
            methodEnd = new Label();
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, signature, functionDescriptor.getExtensionReceiverParameter(), functionDescriptor.getValueParameters(), AsmUtil.isStaticMethod(context.getContextKind(), functionDescriptor));
            if (context.isInlineMethodContext()) {
                functionFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            if (context instanceof InlineLambdaContext) {
                lambdaFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context.setMethodStartLabel(methodEntry);
            if (!strategy.skipNotNullAssertionsForParameters()) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            parentCodegen.beforeMethodBody(mv);
            methodEnd = new Label();
            context.setMethodEndLabel(methodEnd);
            strategy.generateBody(mv, frameMap, signature, context, parentCodegen);
        }
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context, typeMapper);
        if (functionDescriptor instanceof AnonymousFunctionDescriptor && functionDescriptor.isSuspend()) {
            functionDescriptor = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, parentCodegen.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines), typeMapper.getBindingContext());
        }
        ArrayList<ValueParameterDescriptor> destructuredParametersForSuspendLambda = new ArrayList<ValueParameterDescriptor>();
        if (context.getParentContext() instanceof ClosureContext) {
            CallableMemberDescriptor lambdaDescriptor;
            if (context instanceof InlineLambdaContext) {
                lambdaDescriptor = (CallableMemberDescriptor)context.getContextDescriptor();
                if (lambdaDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)lambdaDescriptor).isSuspend()) {
                    destructuredParametersForSuspendLambda.addAll(lambdaDescriptor.getValueParameters());
                }
            } else {
                lambdaDescriptor = ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor();
                if (lambdaDescriptor != null && functionDescriptor.getName().equals(Name.identifier("doResume"))) {
                    destructuredParametersForSuspendLambda.addAll(lambdaDescriptor.getValueParameters());
                }
            }
        }
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, context.getContextKind(), typeMapper, destructuredParametersForSuspendLambda, (functionFakeIndex >= 0 ? 1 : 0) + (lambdaFakeIndex >= 0 ? 1 : 0));
        if (context.isInlineMethodContext() && functionFakeIndex != -1) {
            mv.visitLocalVariable("$i$f$" + typeMapper.mapAsmMethod(functionDescriptor).getName(), Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, functionFakeIndex);
        }
        if (context instanceof InlineLambdaContext && thisType != null && lambdaFakeIndex != -1 && (indexOfLambdaOrdinal = (name = thisType.getClassName()).lastIndexOf("$")) > 0) {
            ValueParameterDescriptor inlineArgumentDescriptor;
            int lambdaOrdinal = Integer.parseInt(name.substring(indexOfLambdaOrdinal + 1));
            Object functionArgument = parentCodegen.element;
            String functionName = "unknown";
            if (functionArgument instanceof KtFunction && (inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)functionArgument, parentCodegen.bindingContext)) != null) {
                functionName = inlineArgumentDescriptor.getContainingDeclaration().getName().asString();
            }
            mv.visitLocalVariable("$i$a$" + lambdaOrdinal + "$" + functionName, Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, lambdaFakeIndex);
        }
    }

    private static boolean isCompatibilityStubInDefaultImpls(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmDefaultMode jvmDefaultMode) {
        return OwnerKind.DEFAULT_IMPLS == context.getContextKind() && AnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor) && jvmDefaultMode.isCompatibility();
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind, @NotNull KotlinTypeMapper typeMapper, @NotNull List<ValueParameterDescriptor> destructuredParametersForSuspendLambda, int shiftForDestructuringVariables) {
        FunctionDescriptor unwrapped;
        if (functionDescriptor.isSuspend() && (unwrapped = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor)) != functionDescriptor) {
            FunctionCodegen.generateLocalVariableTable(mv, new JvmMethodSignature(jvmMethodSignature.getAsmMethod(), jvmMethodSignature.getValueParameters().subList(0, jvmMethodSignature.getValueParameters().size() - 1)), unwrapped, thisType, methodBegin, methodEnd, ownerKind, typeMapper, destructuredParametersForSuspendLambda, shiftForDestructuringVariables);
            return;
        }
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, thisType, methodBegin, methodEnd, functionDescriptor.getValueParameters(), destructuredParametersForSuspendLambda, AsmUtil.isStaticMethod(ownerKind, functionDescriptor), typeMapper, shiftForDestructuringVariables);
    }

    public static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, boolean isStatic, KotlinTypeMapper typeMapper) {
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, thisType, methodBegin, methodEnd, valueParameters, Collections.emptyList(), isStatic, typeMapper, 0);
    }

    private static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, @NotNull List<ValueParameterDescriptor> destructuredParametersForSuspendLambda, boolean isStatic, KotlinTypeMapper typeMapper, int shiftForDestructuringVariables) {
        Iterator<ValueParameterDescriptor> valueParameterIterator = valueParameters.iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameterIterator.next();
                List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
                parameterName = destructuringVariables == null ? FunctionCodegen.computeParameterName(i, parameter) : "$" + FunctionCodegen.joinParameterNames(destructuringVariables);
            } else {
                String lowercaseKind = kind.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type2 = param.getAsmType();
            mv.visitLocalVariable(parameterName, type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
        shift += shiftForDestructuringVariables;
        shift = FunctionCodegen.generateDestructuredParameterEntries(mv, methodBegin, methodEnd, valueParameters, typeMapper, shift);
        shift = FunctionCodegen.generateDestructuredParametersForSuspendLambda(mv, methodBegin, methodEnd, typeMapper, shift, destructuredParametersForSuspendLambda);
        FunctionCodegen.generateDestructuredParameterEntries(mv, methodBegin, methodEnd, destructuredParametersForSuspendLambda, typeMapper, shift);
    }

    private static int generateDestructuredParameterEntries(@NotNull MethodVisitor mv, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, KotlinTypeMapper typeMapper, int shift) {
        for (ValueParameterDescriptor parameter : valueParameters) {
            List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
            if (destructuringVariables == null) continue;
            for (VariableDescriptor entry : CodegenUtilKt.filterOutDescriptorsWithSpecialNames(destructuringVariables)) {
                Type type2 = typeMapper.mapType(entry.getType());
                mv.visitLocalVariable(entry.getName().asString(), type2.getDescriptor(), null, methodBegin, methodEnd, shift);
                shift += type2.getSize();
            }
        }
        return shift;
    }

    private static int generateDestructuredParametersForSuspendLambda(@NotNull MethodVisitor mv, @NotNull Label methodBegin, @NotNull Label methodEnd, KotlinTypeMapper typeMapper, int shift, List<ValueParameterDescriptor> destructuredParametersForSuspendLambda) {
        for (ValueParameterDescriptor parameter : destructuredParametersForSuspendLambda) {
            List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
            if (destructuringVariables == null) continue;
            Type type2 = typeMapper.mapType(parameter.getType());
            mv.visitLocalVariable("$" + FunctionCodegen.joinParameterNames(destructuringVariables), type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
        return shift;
    }

    private static String computeParameterName(int i, ValueParameterDescriptor parameter) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
        if (element instanceof KtParameter && UnderscoreUtilKt.isSingleUnderscore((KtParameter)element)) {
            return "$noName_" + i;
        }
        return parameter.getName().asString();
    }

    private static String joinParameterNames(@NotNull List<VariableDescriptor> variables) {
        return StringsKt.join(CollectionsKt.map(variables, descriptor2 -> descriptor2.getName().isSpecial() ? "$_$" : descriptor2.getName().asString()), "_");
    }

    private static void generateFacadeDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull MultifileClassFacadeContext context) {
        FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, asmMethod, context.getFilePartType().getInternalName(), false);
    }

    private static void generateDelegateToMethodBody(int firstParamIndex, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo, int opcode, boolean isInterface) {
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int paramIndex = firstParamIndex;
        if (paramIndex == -1) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
            paramIndex = 1;
        }
        for (Type argType : argTypes) {
            iv.load(paramIndex, argType);
            paramIndex += argType.getSize();
        }
        iv.visitMethodInsn(opcode, classToDelegateTo, asmMethod.getName(), asmMethod.getDescriptor(), isInterface);
        iv.areturn(asmMethod.getReturnType());
    }

    private static void generateDelegateToStaticErasedVersion(@NotNull MethodVisitor mv, @NotNull Method erasedStaticAsmMethod, @NotNull String classToDelegateTo, @NotNull Type fieldOwnerType, @NotNull String fieldName, @NotNull Type fieldType) {
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = erasedStaticAsmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.visitFieldInsn(180, fieldOwnerType.getInternalName(), fieldName, fieldType.getDescriptor());
        int k = 1;
        for (int i = 1; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(classToDelegateTo, erasedStaticAsmMethod.getName(), erasedStaticAsmMethod.getDescriptor(), false);
        iv.areturn(erasedStaticAsmMethod.getReturnType());
    }

    private static void generateDelegateToStaticMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo, boolean isInterfaceMethodCall) {
        FunctionCodegen.generateDelegateToMethodBody(isStatic ? 0 : 1, mv, asmMethod, classToDelegateTo, 184, isInterfaceMethodCall);
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2) {
        FunctionCodegen.endVisit(mv, description2, (PsiElement)null);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2, @Nullable KtPureElement method) {
        FunctionCodegen.endVisit(mv, description2, (PsiElement)(method == null ? null : method.getPsiOrParent()));
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2, @NotNull KtElement method) {
        FunctionCodegen.endVisit(mv, description2, (PsiElement)method);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode2 = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated\n" + (description2 != null ? " for " + description2 : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode2 != null ? "\nbytecode:\n" + bytecode2 : ""), t, method);
        }
    }

    @Nullable
    public static String renderByteCodeIfAvailable(@NotNull MethodVisitor mv) {
        String bytecode2 = null;
        if (mv instanceof TransformationMethodVisitor) {
            mv = ((TransformationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode2 = sw.toString();
        }
        return bytecode2;
    }

    private boolean hasSpecialBridgeMethod(@NotNull FunctionDescriptor descriptor2) {
        if (SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2) == null) {
            return false;
        }
        return !BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, this.typeMapper::mapAsmMethod, this.DECLARATION_AND_DEFINITION_CHECKER).isEmpty();
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor2) {
        boolean isSpecial;
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.DEFAULT_IMPLS) {
            return;
        }
        if (!this.DECLARATION_AND_DEFINITION_CHECKER.invoke(descriptor2).booleanValue()) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor2)) {
            return;
        }
        boolean bl = isSpecial = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2) != null;
        if (!isSpecial) {
            Set<Bridge<Method>> bridgesToGenerate2 = ImplKt.generateBridgesForFunctionDescriptor(descriptor2, this.typeMapper::mapAsmMethod, this.DECLARATION_AND_DEFINITION_CHECKER);
            if (!bridgesToGenerate2.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                boolean isSpecialBridge = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2) != null;
                for (Bridge<Method> bridge : bridgesToGenerate2) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), isSpecialBridge, false);
                }
            }
        } else {
            Set<BridgeForBuiltinSpecial<Method>> specials = BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, this.typeMapper::mapAsmMethod, this.DECLARATION_AND_DEFINITION_CHECKER);
            if (!specials.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                for (BridgeForBuiltinSpecial<Method> bridge : specials) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), bridge.isSpecial(), bridge.isDelegateToSuper());
                }
            }
            if (!descriptor2.getKind().isReal() && AsmUtil.isAbstractMethod(descriptor2, OwnerKind.IMPLEMENTATION)) {
                FunctionDescriptor overridden = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2);
                assert (overridden != null);
                if (!FunctionCodegen.isThereOverriddenInKotlinClass(descriptor2)) {
                    Method method = this.typeMapper.mapAsmMethod(descriptor2);
                    int flags = 0x400 | AsmUtil.getVisibilityAccessFlag(descriptor2);
                    this.v.newMethod(JvmDeclarationOriginKt.AugmentedBuiltInApi(overridden), flags, method.getName(), method.getDescriptor(), null, null);
                }
            }
        }
    }

    public static boolean isThereOverriddenInKotlinClass(@NotNull CallableMemberDescriptor descriptor2) {
        return CollectionsKt.any(DescriptorUtils.getAllOverriddenDescriptors(descriptor2), overridden -> !(overridden.getContainingDeclaration() instanceof JavaClassDescriptor) && DescriptorUtils.isClass(overridden.getContainingDeclaration()));
    }

    public static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor2) {
        String name = descriptor2.getName().asString();
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        if (parameters2.isEmpty()) {
            return name.equals("hashCode") || name.equals("toString");
        }
        if (parameters2.size() == 1 && name.equals("equals")) {
            return KotlinBuiltIns.isNullableAny(parameters2.get(0).getType());
        }
        return false;
    }

    @NotNull
    public static String[] getThrownExceptions(@NotNull FunctionDescriptor function2, @NotNull KotlinTypeMapper mapper) {
        AnnotationDescriptor annotation2 = function2.getAnnotations().findAnnotation(new FqName("kotlin.throws"));
        if (annotation2 == null) {
            annotation2 = function2.getAnnotations().findAnnotation(new FqName("kotlin.jvm.Throws"));
        }
        if (annotation2 == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<ConstantValue<?>> values = annotation2.getAllValueArguments().values();
        if (values.isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ConstantValue<?> value = values.iterator().next();
        if (!(value instanceof ArrayValue)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value;
        List<String> strings = CollectionsKt.mapNotNull((Iterable)arrayValue.getValue(), constant -> {
            if (constant instanceof KClassValue) {
                KClassValue classValue = (KClassValue)constant;
                ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                return mapper.mapClass(classDescriptor).getInternalName();
            }
            return null;
        });
        return ArrayUtil.toStringArray(strings);
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2) {
        DeclarationDescriptor contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration();
        if (DescriptorUtils.isInterface(contextClass) && !FunctionCodegen.processInterfaceMethod(functionDescriptor, kind, true, false, this.state.getJvmDefaultMode())) {
            return;
        }
        if (!this.isDefaultNeeded(functionDescriptor, function2)) {
            return;
        }
        int visibilityFlag = Visibilities.isPrivate(functionDescriptor.getVisibility()) || org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt.isEffectivelyInlineOnly(functionDescriptor) ? 0 : 1;
        int flags = visibilityFlag | AsmUtil.getDeprecatedAccessFlag(functionDescriptor) | 0x1000;
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            flags |= 0x48;
        }
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, kind);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Synthetic(function2, functionDescriptor), flags, defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        AnnotationCodegen.forMethod(mv, this.memberCodegen, this.typeMapper).genAnnotations(functionDescriptor, defaultMethod.getReturnType());
        if (!this.state.getClassBuilderMode().generateBodies) {
            if (this.owner instanceof MultifileClassFacadeContext) {
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            } else {
                FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            }
            return;
        }
        if (this.owner instanceof MultifileClassFacadeContext) {
            mv.visitCode();
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, defaultMethod, (MultifileClassFacadeContext)this.owner);
            FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        } else if (FunctionCodegen.isCompatibilityStubInDefaultImpls(functionDescriptor, owner, this.state.getJvmDefaultMode())) {
            mv.visitCode();
            Method interfaceDefaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, OwnerKind.IMPLEMENTATION);
            FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, interfaceDefaultMethod, this.typeMapper.mapOwner(functionDescriptor).getInternalName(), true);
            FunctionCodegen.endVisit(mv, "default method delegation to interface one", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        } else {
            mv.visitCode();
            FunctionCodegen.generateDefaultImplBody(owner, functionDescriptor, mv, loadStrategy, function2, this.memberCodegen, defaultMethod);
            FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        }
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2, @NotNull MemberCodegen<?> parentCodegen, @NotNull Method defaultMethod) {
        int index2;
        int capturedArgumentsCount;
        GenerationState state2 = parentCodegen.state;
        JvmMethodGenericSignature signature = state2.getTypeMapper().mapSignatureWithGeneric(functionDescriptor, methodContext.getContextKind());
        List<ValueParameterDescriptor> valueParameters = CodegenUtil.getFunctionParametersForDefaultValueGeneration(functionDescriptor, null);
        boolean isStatic = AsmUtil.isStaticMethod(methodContext.getContextKind(), functionDescriptor);
        FrameMap frameMap = FunctionCodegen.createFrameMap(state2, signature, functionDescriptor.getExtensionReceiverParameter(), valueParameters, isStatic);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, state2, parentCodegen);
        CallGenerator generator = codegen.getOrCreateCallGeneratorForDefaultImplBody(functionDescriptor, function2);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.genDefaultSuperCallCheckIfNeeded(iv, functionDescriptor, defaultMethod);
        List<JvmMethodParameterSignature> mappedParameters = signature.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        assert (valueParameters.size() > 0) : "Expecting value parameters to generate default function " + functionDescriptor;
        int firstMaskIndex = frameMap.enterTemp(Type.INT_TYPE);
        for (index2 = 1; index2 < valueParameters.size(); ++index2) {
            if (index2 % 32 != 0) continue;
            frameMap.enterTemp(Type.INT_TYPE);
        }
        frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        for (index2 = 0; index2 < valueParameters.size(); ++index2) {
            int maskIndex = firstMaskIndex + index2 / 32;
            ValueParameterDescriptor parameterDescriptor = valueParameters.get(index2);
            Type type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            if (!parameterDescriptor.declaresDefaultValue()) continue;
            iv.load(maskIndex, Type.INT_TYPE);
            iv.iconst(1 << index2 % 32);
            iv.and(Type.INT_TYPE);
            Label loadArg = new Label();
            iv.ifeq(loadArg);
            StackValue.local(parameterIndex, type2).store(loadStrategy.genValue(parameterDescriptor, codegen), iv);
            iv.mark(loadArg);
        }
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypes.OBJECT_TYPE, isStatic, signature, generator);
        for (index2 = 0; index2 < valueParameters.size(); ++index2) {
            ValueParameterDescriptor parameterDescriptor = valueParameters.get(index2);
            Type type3 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            generator.putValueIfNeeded(new JvmKotlinType(type3, null), StackValue.local(parameterIndex, type3));
        }
        CallableMethod method = state2.getTypeMapper().mapToCallableMethod(functionDescriptor, false);
        generator.genCall(method, null, false, codegen);
        iv.areturn(signature.getReturnType());
    }

    private static void genDefaultSuperCallCheckIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Method defaultMethod) {
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (!(container2 instanceof ClassDescriptor)) {
            return;
        }
        if (((ClassDescriptor)container2).getModality() == Modality.FINAL) {
            return;
        }
        Label end = new Label();
        int handleIndex = (Type.getArgumentsAndReturnSizes(defaultMethod.getDescriptor()) >> 2) - 2;
        iv.load(handleIndex, AsmTypes.OBJECT_TYPE);
        iv.ifnull(end);
        AsmUtil.genThrow(iv, "java/lang/UnsupportedOperationException", "Super calls with default arguments not supported in this target, function: " + descriptor2.getName().asString());
        iv.visitLabel(end);
    }

    @NotNull
    private static FrameMap createFrameMap(@NotNull GenerationState state2, @NotNull JvmMethodSignature signature, @Nullable ReceiverParameterDescriptor extensionReceiverParameter, @NotNull List<ValueParameterDescriptor> valueParameters, boolean isStatic) {
        FrameMap frameMap = new FrameMap();
        if (!isStatic) {
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.RECEIVER) {
                if (extensionReceiverParameter != null) {
                    frameMap.enter(extensionReceiverParameter, state2.getTypeMapper().mapType(extensionReceiverParameter));
                    continue;
                }
                frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
                continue;
            }
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameters) {
            frameMap.enter(valueParameterDescriptor, state2.getTypeMapper().mapType(valueParameterDescriptor));
        }
        return frameMap;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature, @NotNull CallGenerator callGenerator) {
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(new JvmKotlinType(ownerType, null), StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type2 = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(new JvmKotlinType(type2, null), StackValue.local(var, type2));
            var += type2.getSize();
        }
    }

    private boolean isDefaultNeeded(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        List<ValueParameterDescriptor> parameters2 = CodegenUtil.getFunctionParametersForDefaultValueGeneration(descriptor2, this.state.getDiagnostics());
        return CollectionsKt.any(parameters2, ValueParameterDescriptor::declaresDefaultValue);
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor2, @NotNull Method bridge, @NotNull Method delegateTo, boolean isSpecialBridge, boolean isStubDeclarationWithDelegationToSuper) {
        boolean isSpecialOrDelegationToSuper = isSpecialBridge || isStubDeclarationWithDelegationToSuper;
        int flags = 0x41 | (!isSpecialOrDelegationToSuper ? 4096 : 0) | (isSpecialBridge ? 16 : 0);
        String bridgeSignature = isSpecialBridge ? this.typeMapper.mapSignatureWithGeneric(descriptor2, OwnerKind.IMPLEMENTATION).getGenericsSignature() : null;
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Bridge(descriptor2, origin), flags, bridge.getName(), bridge.getDescriptor(), bridgeSignature, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(this.owner.getThisDescriptor(), iv);
        if (delegateTo.getArgumentTypes().length > 0 && isSpecialBridge) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(iv, descriptor2, bridge.getReturnType(), delegateTo.getArgumentTypes());
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        if (isStubDeclarationWithDelegationToSuper) {
            ClassDescriptor parentClass = DescriptorUtils.getSuperClassDescriptor((ClassDescriptor)descriptor2.getContainingDeclaration());
            assert (parentClass != null);
            String parentInternalName = this.typeMapper.mapClass(parentClass).getInternalName();
            iv.invokespecial(parentInternalName, delegateTo.getName(), delegateTo.getDescriptor(), false);
        } else if (AnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2)) {
            iv.invokeinterface(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        } else {
            iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor(), false);
        }
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    private static void generateTypeCheckBarrierIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Type returnType, @Nullable Type[] delegateParameterTypes) {
        BuiltinMethodsWithSpecialGenericSignature.TypeSafeBarrierDescription typeSafeBarrierDescription = BuiltinMethodsWithSpecialGenericSignature.getDefaultValueForOverriddenBuiltinFunction(descriptor2);
        if (typeSafeBarrierDescription == null) {
            return;
        }
        FunctionDescriptor overriddenBuiltin = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2);
        assert (overriddenBuiltin != null) : "Overridden built-in method should not be null for " + descriptor2;
        Label defaultBranch = new Label();
        for (int i = 0; i < descriptor2.getValueParameters().size(); ++i) {
            if (!typeSafeBarrierDescription.checkParameter(i)) continue;
            boolean isCheckForAny = delegateParameterTypes == null || AsmTypes.OBJECT_TYPE.equals(delegateParameterTypes[i]);
            KotlinType kotlinType = descriptor2.getValueParameters().get(i).getType();
            if (isCheckForAny && TypeUtils.isNullableType(kotlinType)) continue;
            iv.load(1 + i, AsmTypes.OBJECT_TYPE);
            if (isCheckForAny) {
                assert (!TypeUtils.isNullableType(kotlinType)) : "Only bridges for not-nullable types are necessary";
                iv.ifnull(defaultBranch);
                continue;
            }
            CodegenUtilKt.generateIsCheck(iv, kotlinType, AsmUtil.boxType(delegateParameterTypes[i]));
            iv.ifeq(defaultBranch);
        }
        Label afterDefaultBranch = new Label();
        iv.goTo(afterDefaultBranch);
        iv.visitLabel(defaultBranch);
        if (typeSafeBarrierDescription.equals((Object)BuiltinMethodsWithSpecialGenericSignature.TypeSafeBarrierDescription.MAP_GET_OR_DEFAULT)) {
            iv.load(2, returnType);
        } else {
            StackValue.constant(typeSafeBarrierDescription.getDefaultValue(), returnType).put(returnType, iv);
        }
        iv.areturn(returnType);
        iv.visitLabel(afterDefaultBranch);
    }

    public void genSamDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor2, StackValue field) {
        FunctionDescriptor delegatedTo = overriddenDescriptor2.getOriginal();
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.SamDelegation(functionDescriptor);
        this.genDelegate(functionDescriptor, delegatedTo, declarationOrigin, (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field);
    }

    public void genDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor2, StackValue field) {
        this.genDelegate(functionDescriptor, overriddenDescriptor2.getOriginal(), (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field);
    }

    public void genDelegate(@NotNull FunctionDescriptor delegateFunction, FunctionDescriptor delegatedTo, ClassDescriptor toClass, StackValue field) {
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.Delegation(DescriptorToSourceUtils.descriptorToDeclaration(delegatedTo), delegateFunction);
        this.genDelegate(delegateFunction, delegatedTo, declarationOrigin, toClass, field);
    }

    private void genDelegate(final @NotNull FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, @NotNull JvmDeclarationOrigin declarationOrigin, final ClassDescriptor toClass, final StackValue field) {
        this.generateMethod(declarationOrigin, delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                Method delegateToMethod = FunctionCodegen.this.typeMapper.mapToCallableMethod(delegatedTo, false).getAsmMethod();
                Method delegateMethod = FunctionCodegen.this.typeMapper.mapAsmMethod(delegateFunction);
                Type[] argTypes = delegateMethod.getArgumentTypes();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypes.OBJECT_TYPE);
                field.put(field.type, iv);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                    reg += argTypes[i].getSize();
                }
                String internalName = FunctionCodegen.this.typeMapper.mapType(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.INTERFACE) {
                    iv.invokeinterface(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else {
                    iv.invokevirtual(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor(), false);
                }
                StackValue stackValue = AsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType()), RuntimeAssertionInfo.create(delegateFunction.getReturnType(), delegatedTo.getReturnType(), new RuntimeAssertionInfo.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }

            @Override
            public boolean skipNotNullAssertionsForParameters() {
                return false;
            }
        });
    }

    public static boolean processInterfaceMethod(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull OwnerKind kind, boolean isDefault, boolean isSynthetic, JvmDefaultMode mode) {
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        assert (DescriptorUtils.isInterface(containingDeclaration)) : "'processInterfaceMethod' method should be called only for interfaces, but: " + containingDeclaration;
        if (AnnotationUtilKt.hasJvmDefaultAnnotation(memberDescriptor)) {
            return kind != OwnerKind.DEFAULT_IMPLS && !isSynthetic || kind == OwnerKind.DEFAULT_IMPLS && (isSynthetic || mode.isCompatibility());
        }
        switch (kind) {
            case DEFAULT_IMPLS: {
                return true;
            }
            case IMPLEMENTATION: {
                return !Visibilities.isPrivate(memberDescriptor.getVisibility()) && !isDefault && !isSynthetic;
            }
        }
        return false;
    }
}

