/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrEnumValueOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrNoWhenBranchMatchedException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowNPE;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "intrinsics", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethods;", "getIntrinsics", "()Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethods;", "irMapping", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "Lkotlin/collections/HashMap;", "createPrimitiveComparisonIntrinsics", "", "typeToIrFun", "", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "operator", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "getIntrinsic", "descriptor", "backend"})
public final class IrIntrinsicMethods {
    @NotNull
    private final IntrinsicMethods intrinsics;
    private final HashMap<CallableMemberDescriptor, IntrinsicMethod> irMapping;

    @NotNull
    public final IntrinsicMethods getIntrinsics() {
        return this.intrinsics;
    }

    private final void createPrimitiveComparisonIntrinsics(Map<SimpleType, ? extends IrSimpleFunction> typeToIrFun, KtSingleValueToken operator) {
        Map<SimpleType, ? extends IrSimpleFunction> map2 = typeToIrFun;
        for (Map.Entry<SimpleType, ? extends IrSimpleFunction> entry : map2.entrySet()) {
            Object object = entry;
            SimpleType type2 = object.getKey();
            object = entry;
            IrSimpleFunction irFun = object.getValue();
            object = this.irMapping;
            FunctionDescriptor functionDescriptor = irFun.getDescriptor();
            PrimitiveComparison primitiveComparison = new PrimitiveComparison(type2, operator);
            object.put(functionDescriptor, primitiveComparison);
        }
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        IntrinsicMethod intrinsicMethod = this.intrinsics.getIntrinsic(descriptor2);
        if (intrinsicMethod != null) {
            IntrinsicMethod intrinsicMethod2;
            IntrinsicMethod it = intrinsicMethod2 = intrinsicMethod;
            return it;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return this.intrinsics.getIntrinsic(DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty()));
        }
        return this.irMapping.get(descriptor2.getOriginal());
    }

    public IrIntrinsicMethods(@NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkParameterIsNotNull(irBuiltIns, "irBuiltIns");
        this.intrinsics = new IntrinsicMethods();
        IrIntrinsicMethods irIntrinsicMethods = this;
        HashMap hashMap = new HashMap();
        irIntrinsicMethods.irMapping = hashMap;
        Map map2 = this.irMapping;
        FunctionDescriptor functionDescriptor = irBuiltIns.getEqeq();
        KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
        Intrinsics.checkExpressionValueIsNotNull(ktSingleValueToken, "KtTokens.EQEQ");
        IntrinsicMethod intrinsicMethod = new Equals(ktSingleValueToken);
        map2.put(functionDescriptor, intrinsicMethod);
        map2 = this.irMapping;
        functionDescriptor = irBuiltIns.getEqeqeq();
        KtSingleValueToken ktSingleValueToken2 = KtTokens.EQEQEQ;
        Intrinsics.checkExpressionValueIsNotNull(ktSingleValueToken2, "KtTokens.EQEQEQ");
        intrinsicMethod = new Equals(ktSingleValueToken2);
        map2.put(functionDescriptor, intrinsicMethod);
        map2 = this.irMapping;
        IrSimpleFunction irSimpleFunction = irBuiltIns.getIeee754equalsFunByOperandType().get(irBuiltIns.getFloat());
        if (irSimpleFunction == null) {
            Intrinsics.throwNpe();
        }
        functionDescriptor = irSimpleFunction.getDescriptor();
        Type type2 = Type.FLOAT_TYPE;
        Intrinsics.checkExpressionValueIsNotNull(type2, "Type.FLOAT_TYPE");
        intrinsicMethod = new Ieee754Equals(type2);
        map2.put(functionDescriptor, intrinsicMethod);
        map2 = this.irMapping;
        IrSimpleFunction irSimpleFunction2 = irBuiltIns.getIeee754equalsFunByOperandType().get(irBuiltIns.getDouble());
        if (irSimpleFunction2 == null) {
            Intrinsics.throwNpe();
        }
        functionDescriptor = irSimpleFunction2.getDescriptor();
        Type type3 = Type.DOUBLE_TYPE;
        Intrinsics.checkExpressionValueIsNotNull(type3, "Type.DOUBLE_TYPE");
        intrinsicMethod = new Ieee754Equals(type3);
        map2.put(functionDescriptor, intrinsicMethod);
        map2 = this.irMapping;
        functionDescriptor = irBuiltIns.getBooleanNot();
        intrinsicMethod = new Not();
        map2.put(functionDescriptor, intrinsicMethod);
        Map<SimpleType, IrSimpleFunction> map3 = irBuiltIns.getLessFunByOperandType();
        KtSingleValueToken ktSingleValueToken3 = KtTokens.LT;
        Intrinsics.checkExpressionValueIsNotNull(ktSingleValueToken3, "KtTokens.LT");
        this.createPrimitiveComparisonIntrinsics(map3, ktSingleValueToken3);
        Map<SimpleType, IrSimpleFunction> map4 = irBuiltIns.getLessOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LTEQ;
        Intrinsics.checkExpressionValueIsNotNull(ktSingleValueToken4, "KtTokens.LTEQ");
        this.createPrimitiveComparisonIntrinsics(map4, ktSingleValueToken4);
        Map<SimpleType, IrSimpleFunction> map5 = irBuiltIns.getGreaterFunByOperandType();
        KtSingleValueToken ktSingleValueToken5 = KtTokens.GT;
        Intrinsics.checkExpressionValueIsNotNull(ktSingleValueToken5, "KtTokens.GT");
        this.createPrimitiveComparisonIntrinsics(map5, ktSingleValueToken5);
        Map<SimpleType, IrSimpleFunction> map6 = irBuiltIns.getGreaterOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken6 = KtTokens.GTEQ;
        Intrinsics.checkExpressionValueIsNotNull(ktSingleValueToken6, "KtTokens.GTEQ");
        this.createPrimitiveComparisonIntrinsics(map6, ktSingleValueToken6);
        map2 = this.irMapping;
        functionDescriptor = irBuiltIns.getEnumValueOf();
        intrinsicMethod = new IrEnumValueOf();
        map2.put(functionDescriptor, intrinsicMethod);
        map2 = this.irMapping;
        functionDescriptor = irBuiltIns.getNoWhenBranchMatchedException();
        intrinsicMethod = new IrNoWhenBranchMatchedException();
        map2.put(functionDescriptor, intrinsicMethod);
        map2 = this.irMapping;
        functionDescriptor = irBuiltIns.getThrowNpe();
        intrinsicMethod = new ThrowNPE();
        map2.put(functionDescriptor, intrinsicMethod);
    }
}

