/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.CustomTypeVariable;
import org.jetbrains.kotlin.types.DelegatingSimpleType;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.checker.NullabilityChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0006\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "Lorg/jetbrains/kotlin/types/DelegatingSimpleType;", "Lorg/jetbrains/kotlin/types/CustomTypeVariable;", "original", "Lorg/jetbrains/kotlin/types/SimpleType;", "(Lorg/jetbrains/kotlin/types/SimpleType;)V", "delegate", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "isMarkedNullable", "", "()Z", "isTypeVariable", "getOriginal", "makeNullableAsSpecified", "newNullability", "replaceAnnotations", "newAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "substitutionResult", "Lorg/jetbrains/kotlin/types/KotlinType;", "replacement", "toString", "", "Companion", "descriptors"})
public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeVariable {
    @NotNull
    private final SimpleType original;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isTypeVariable() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(replacement.unwrap());
    }

    @Override
    @NotNull
    public DefinitelyNotNullType replaceAnnotations(@NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull(newAnnotations, "newAnnotations");
        return new DefinitelyNotNullType(this.getDelegate().replaceAnnotations(newAnnotations));
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        return newNullability ? this.getDelegate().makeNullableAsSpecified(newNullability) : (SimpleType)this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDelegate() + "!!";
    }

    @NotNull
    public final SimpleType getOriginal() {
        return this.original;
    }

    private DefinitelyNotNullType(SimpleType original) {
        this.original = original;
    }

    public /* synthetic */ DefinitelyNotNullType(@NotNull SimpleType original, DefaultConstructorMarker $constructor_marker) {
        this(original);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/types/DefinitelyNotNullType$Companion;", "", "()V", "makeDefinitelyNotNull", "Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "makeDefinitelyNotNull$descriptors", "makesSenseToBeDefinitelyNotNull", "", "descriptors"})
    public static final class Companion {
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull$descriptors(@NotNull UnwrappedType type2) {
            DefinitelyNotNullType definitelyNotNullType;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            if (type2 instanceof DefinitelyNotNullType) {
                definitelyNotNullType = (DefinitelyNotNullType)type2;
            } else if (this.makesSenseToBeDefinitelyNotNull(type2)) {
                if (type2 instanceof FlexibleType) {
                    boolean bl = Intrinsics.areEqual(((FlexibleType)type2).getLowerBound().getConstructor(), ((FlexibleType)type2).getUpperBound().getConstructor());
                    if (_Assertions.ENABLED && !bl) {
                        String string = "DefinitelyNotNullType for flexible type (" + type2 + ") can be created only from type variable with the same constructor for bounds";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                }
                definitelyNotNullType = new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible(type2), null);
            } else {
                definitelyNotNullType = null;
            }
            return definitelyNotNullType;
        }

        public final boolean makesSenseToBeDefinitelyNotNull(@NotNull UnwrappedType type2) {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            return TypeUtilsKt.canHaveUndefinedNullability(type2) && !NullabilityChecker.INSTANCE.isSubtypeOfAny(type2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

