/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processors;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        PsiAnnotation annotation2 = AnnotationUtil.findOwnAnnotation(listOwner, annotationNames);
        if (annotation2 != null) {
            return annotation2;
        }
        return skipExternal ? null : AnnotationUtil.findNonCodeAnnotation(listOwner, annotationNames);
    }

    private static PsiAnnotation findOwnAnnotation(PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        PsiModifierList list2 = listOwner.getModifierList();
        if (list2 == null) {
            return null;
        }
        for (PsiAnnotation annotation2 : list2.getAnnotations()) {
            if (!annotationNames.contains(annotation2.getQualifiedName())) continue;
            return annotation2;
        }
        return null;
    }

    private static PsiAnnotation findNonCodeAnnotation(PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        if (listOwner instanceof PsiLocalVariable) {
            return null;
        }
        Map map2 = (Map)CachedValuesManager.getCachedValue(listOwner, () -> {
            ConcurrentMap<Collection, PsiAnnotation> value = ConcurrentFactoryMap.createMap(annotationNames1 -> {
                PsiUtilCore.ensureValid(listOwner);
                Project project = listOwner.getProject();
                ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation2 = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                    if (annotation2 == null) continue;
                    return annotation2;
                }
                InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation3 = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                    if (annotation3 == null) continue;
                    return annotation3;
                }
                return null;
            });
            return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        return (List)CachedValuesManager.getCachedValue(element, () -> {
            List<Object> list2;
            if (element == null) {
                AnnotationUtil.$$$reportNull$$$0(58);
            }
            LinkedHashSet<PsiModifierListOwner> result2 = ContainerUtil.newLinkedHashSet();
            if (element instanceof PsiMethod) {
                AnnotationUtil.collectSuperMethods(result2, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, Processors.cancelableCollectProcessor(result2));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result2, (PsiParameter)element);
            }
            if (result2.isEmpty()) {
                list2 = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result2.toArray(new PsiModifierListOwner[0]);
                list2 = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list2, PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(10);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(11);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames)) != null) {
            return directAnnotation;
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(superOwner, annotationNames);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<PsiModifierListOwner> result2, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                PsiElement parent2;
                if (result2 == null) {
                    AnnotationUtil.$$$reportNull$$$0(12);
                }
                if (parameter == null) {
                    AnnotationUtil.$$$reportNull$$$0(13);
                }
                if (!((parent2 = parameter.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index2 = ((PsiParameterList)parent2).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters;
                    if (result2 == null) {
                        AnnotationUtil.$$$reportNull$$$0(57);
                    }
                    if (index2 < (superParameters = method.getParameterList().getParameters()).length) {
                        result2.add(superParameters[index2]);
                    }
                };
                scope = parent2.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<PsiModifierListOwner> result2, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result2 == null) {
            AnnotationUtil.$$$reportNull$$$0(14);
        }
        if (signature == null) {
            AnnotationUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(17);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result2.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result2, superSignature, place, resolveHelper);
        }
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(18);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(19);
        }
        return annotations2.stream().anyMatch(annotation2 -> {
            if (listOwner == null) {
                AnnotationUtil.$$$reportNull$$$0(56);
            }
            return AnnotationUtil.isAnnotated(listOwner, annotation2, flags, null);
        });
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFqn, int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (annotationFqn == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFqn, flags, null);
    }

    private static boolean isAnnotated(PsiModifierListOwner listOwner, String annotationFQN, int flags, @Nullable Set<PsiMember> processed) {
        block16: {
            block17: {
                Project project;
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation2 = modifierList.findAnnotation(annotationFQN);
                if (annotation2 != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 8)) {
                    PsiType type2 = null;
                    if (listOwner instanceof PsiMethod) {
                        type2 = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiVariable) {
                        type2 = ((PsiVariable)listOwner).getType();
                    }
                    if (type2 != null && type2.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet(flags, 2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet(flags, 1)) break block16;
                if (!(listOwner instanceof PsiMethod)) break block17;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, flags, processed)) continue;
                    return true;
                }
                break block16;
            }
            if (!(listOwner instanceof PsiClass)) break block16;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, flags, processed)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation2, @Nullable(value="null means 'value'") String attributeName) {
        if (annotation2 == null) {
            AnnotationUtil.$$$reportNull$$$0(40);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation2.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    public static List<PsiAnnotationMemberValue> arrayAttributeValues(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            List<PsiAnnotationMemberValue> list2 = Arrays.asList(((PsiArrayInitializerMemberValue)attributeValue).getInitializers());
            if (list2 == null) {
                AnnotationUtil.$$$reportNull$$$0(54);
            }
            return list2;
        }
        List<PsiAnnotationMemberValue> list3 = ContainerUtil.createMaybeSingletonList(attributeValue);
        if (list3 == null) {
            AnnotationUtil.$$$reportNull$$$0(55);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: 
            case 30: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: 
            case 30: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: 
            case 30: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 9: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 18: 
            case 20: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 12: 
            case 14: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 19: 
            case 25: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 24: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 31: 
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: 
            case 30: 
            case 54: 
            case 55: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 10: 
            case 11: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 33: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAnnotated$4";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSuperParameters$3";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuperAnnotationOwners$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: 
            case 30: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

