/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorRequiredForDataClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkers"})
public final class FirPrimaryConstructorRequiredForDataClassChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirPrimaryConstructorRequiredForDataClassChecker INSTANCE;

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean hasPrimaryConstructor;
        block8: {
            boolean bl;
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    if (!(declaration2 instanceof FirRegularClass) || ((FirRegularClass)declaration2).getClassKind() != ClassKind.CLASS) break block9;
                    FirRegularClass $this$isData$iv = (FirRegularClass)declaration2;
                    boolean $i$f$isData = false;
                    if ($this$isData$iv.getStatus().isData()) break block10;
                }
                return;
            }
            Iterable $this$any$iv = ((FirRegularClass)declaration2).getDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirConstructor && ((FirConstructor)it).isPrimary())) continue;
                    bl = true;
                    break block8;
                }
                bl = hasPrimaryConstructor = false;
            }
        }
        if (!hasPrimaryConstructor) {
            this.report(reporter, declaration2.getSource());
        }
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS().on(it));
        }
    }

    private FirPrimaryConstructorRequiredForDataClassChecker() {
    }

    static {
        FirPrimaryConstructorRequiredForDataClassChecker firPrimaryConstructorRequiredForDataClassChecker;
        INSTANCE = firPrimaryConstructorRequiredForDataClassChecker = new FirPrimaryConstructorRequiredForDataClassChecker();
    }
}

