/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;

public class ExpressionUtil {
    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier = PsiUtil.deparenthesizeExpression(refExpression.getQualifierExpression());
        if (qualifier == null) {
            return true;
        }
        if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            return innerMostClass == thisQualifier.resolve();
        }
        return false;
    }
}

