/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;

public final class ElementPatternCondition<T> {
    private final InitialPatternCondition<T> myInitialCondition;
    private final List<PatternCondition<? super T>> myConditions;

    public ElementPatternCondition(InitialPatternCondition<T> startCondition) {
        this.myInitialCondition = startCondition;
        this.myConditions = Collections.emptyList();
    }

    ElementPatternCondition(InitialPatternCondition<T> initialCondition, List<PatternCondition<? super T>> conditions2) {
        this.myInitialCondition = initialCondition;
        this.myConditions = conditions2;
    }

    private ElementPatternCondition(ElementPatternCondition<T> original, PatternCondition<? super T> condition) {
        this.myInitialCondition = original.getInitialCondition();
        this.myConditions = new SmartList<PatternCondition<T>>(original.getConditions());
        this.myConditions.add(condition);
    }

    public final String toString() {
        StringBuilder builder2 = new StringBuilder();
        this.append(builder2, "");
        return builder2.toString();
    }

    public void append(StringBuilder builder2, String indent) {
        this.myInitialCondition.append(builder2, indent);
        int conditionSize = this.myConditions.size();
        for (int i = 0; i < conditionSize; ++i) {
            PatternCondition<T> condition = this.myConditions.get(i);
            condition.append(builder2.append(".\n").append(indent), indent);
        }
    }

    public List<PatternCondition<? super T>> getConditions() {
        return this.myConditions;
    }

    public InitialPatternCondition<T> getInitialCondition() {
        return this.myInitialCondition;
    }

    public ElementPatternCondition<T> append(PatternCondition<? super T> condition) {
        return new ElementPatternCondition<T>(this, condition);
    }
}

