/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.connector.basic;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.connector.basic.ArtifactTransportListener;
import org.jetbrains.kotlin.org.eclipse.aether.connector.basic.ChecksumValidator;
import org.jetbrains.kotlin.org.eclipse.aether.connector.basic.MetadataTransportListener;
import org.jetbrains.kotlin.org.eclipse.aether.connector.basic.PartialFile;
import org.jetbrains.kotlin.org.eclipse.aether.connector.basic.TransferTransportListener;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.ArtifactDownload;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.MetadataDownload;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnector;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ProvidedChecksumsSource;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.GetTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.PeekTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.Transporter;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.io.FileProcessor;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ChecksumFailureException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoTransporterException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferEvent;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferResource;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import org.jetbrains.kotlin.org.eclipse.aether.util.concurrency.WorkerThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BasicRepositoryConnector
implements RepositoryConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRepositoryConnector.class);
    private final Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final Transporter transporter;
    private final RepositoryLayout layout;
    private final ChecksumPolicyProvider checksumPolicyProvider;
    private final PartialFile.Factory partialFileFactory;
    private final int maxThreads;
    private final boolean smartChecksums;
    private final boolean persistedChecksums;
    private Executor executor;
    private boolean closed;

    BasicRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) throws NoRepositoryConnectorException {
        try {
            this.layout = layoutProvider.newRepositoryLayout(session, repository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), e);
        }
        try {
            this.transporter = transporterProvider.newTransporter(session, repository);
        }
        catch (NoTransporterException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), e);
        }
        this.checksumPolicyProvider = checksumPolicyProvider;
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.providedChecksumsSources = providedChecksumsSources;
        this.maxThreads = ConfigUtils.getInteger(session, 5, "aether.connector.basic.threads", "maven.artifact.threads");
        this.smartChecksums = ConfigUtils.getBoolean(session, true, "aether.connector.smartChecksums");
        this.persistedChecksums = ConfigUtils.getBoolean(session, true, "aether.connector.persistedChecksums");
        boolean resumeDownloads = ConfigUtils.getBoolean(session, true, "aether.connector.resumeDownloads." + repository.getId(), "aether.connector.resumeDownloads");
        long resumeThreshold = ConfigUtils.getLong(session, 65536L, "aether.connector.resumeThreshold." + repository.getId(), "aether.connector.resumeThreshold");
        int requestTimeout = ConfigUtils.getInteger(session, 1800000, "aether.connector.requestTimeout." + repository.getId(), "aether.connector.requestTimeout");
        this.partialFileFactory = new PartialFile.Factory(resumeDownloads, resumeThreshold, requestTimeout);
    }

    private Executor getExecutor(Collection<?> artifacts, Collection<?> metadatas) {
        if (this.maxThreads <= 1) {
            return DirectExecutor.INSTANCE;
        }
        int tasks = BasicRepositoryConnector.safe(artifacts).size() + BasicRepositoryConnector.safe(metadatas).size();
        if (tasks <= 1) {
            return DirectExecutor.INSTANCE;
        }
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(this.getClass().getSimpleName() + '-' + this.repository.getHost() + '-'));
        }
        return this.executor;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.transporter.close();
        }
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        Executor executor = this.getExecutor(artifactDownloads, metadataDownloads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        List<ChecksumAlgorithmFactory> checksumAlgorithmFactories = this.layout.getChecksumAlgorithmFactories();
        for (MetadataDownload metadataDownload : BasicRepositoryConnector.safe(metadataDownloads)) {
            URI location = this.layout.getLocation(metadataDownload.getMetadata(), false);
            TransferResource resource = this.newTransferResource(location, metadataDownload.getFile(), metadataDownload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, false, false);
            MetadataTransportListener listener = new MetadataTransportListener(metadataDownload, this.repository, builder);
            ChecksumPolicy checksumPolicy = this.newChecksumPolicy(metadataDownload.getChecksumPolicy(), resource);
            List<RepositoryLayout.ChecksumLocation> checksumLocations = null;
            if (checksumPolicy != null) {
                checksumLocations = this.layout.getChecksumLocations(metadataDownload.getMetadata(), false, location);
            }
            GetTaskRunner task = new GetTaskRunner(location, metadataDownload.getFile(), checksumPolicy, checksumAlgorithmFactories, checksumLocations, null, listener);
            executor.execute(errorForwarder.wrap(task));
        }
        for (ArtifactDownload artifactDownload : BasicRepositoryConnector.safe(artifactDownloads)) {
            TaskRunner task;
            Map<String, String> providedChecksums = Collections.emptyMap();
            for (ProvidedChecksumsSource providedChecksumsSource : this.providedChecksumsSources.values()) {
                Map<String, String> provided = providedChecksumsSource.getProvidedArtifactChecksums(this.session, artifactDownload, checksumAlgorithmFactories);
                if (provided == null) continue;
                providedChecksums = provided;
                break;
            }
            URI location = this.layout.getLocation(artifactDownload.getArtifact(), false);
            TransferResource resource = this.newTransferResource(location, artifactDownload.getFile(), artifactDownload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, false, artifactDownload.isExistenceCheck());
            ArtifactTransportListener listener = new ArtifactTransportListener(artifactDownload, this.repository, builder);
            if (artifactDownload.isExistenceCheck()) {
                task = new PeekTaskRunner(location, listener);
            } else {
                ChecksumPolicy checksumPolicy = this.newChecksumPolicy(artifactDownload.getChecksumPolicy(), resource);
                List<RepositoryLayout.ChecksumLocation> checksumLocations = null;
                if (checksumPolicy != null) {
                    checksumLocations = this.layout.getChecksumLocations(artifactDownload.getArtifact(), false, location);
                }
                task = new GetTaskRunner(location, artifactDownload.getFile(), checksumPolicy, checksumAlgorithmFactories, checksumLocations, providedChecksums, listener);
            }
            executor.execute(errorForwarder.wrap(task));
        }
        errorForwarder.await();
    }

    private static <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private TransferResource newTransferResource(URI path, File file, RequestTrace trace) {
        return new TransferResource(this.repository.getId(), this.repository.getUrl(), path.toString(), file, trace);
    }

    private TransferEvent.Builder newEventBuilder(TransferResource resource, boolean upload, boolean peek) {
        TransferEvent.Builder builder = new TransferEvent.Builder(this.session, resource);
        if (upload) {
            builder.setRequestType(TransferEvent.RequestType.PUT);
        } else if (!peek) {
            builder.setRequestType(TransferEvent.RequestType.GET);
        } else {
            builder.setRequestType(TransferEvent.RequestType.GET_EXISTENCE);
        }
        return builder;
    }

    private ChecksumPolicy newChecksumPolicy(String policy, TransferResource resource) {
        return this.checksumPolicyProvider.newChecksumPolicy(this.session, this.repository, resource, policy);
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    private static class DirectExecutor
    implements Executor {
        static final Executor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    class GetTaskRunner
    extends TaskRunner
    implements ChecksumValidator.ChecksumFetcher,
    PartialFile.RemoteAccessChecker {
        private final File file;
        private final ChecksumValidator checksumValidator;

        GetTaskRunner(URI path, File file, ChecksumPolicy checksumPolicy, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, List<RepositoryLayout.ChecksumLocation> checksumLocations, Map<String, String> providedChecksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "destination file cannot be null");
            this.checksumValidator = new ChecksumValidator(file, checksumAlgorithmFactories, BasicRepositoryConnector.this.fileProcessor, this, checksumPolicy, providedChecksums, BasicRepositoryConnector.safe(checksumLocations));
        }

        @Override
        public void checkRemoteAccess() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }

        @Override
        public boolean fetchChecksum(URI remote, File local) throws Exception {
            try {
                BasicRepositoryConnector.this.transporter.get(new GetTask(remote).setDataFile(local));
            }
            catch (Exception e) {
                if (BasicRepositoryConnector.this.transporter.classify(e) == 1) {
                    return false;
                }
                throw e;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.fileProcessor.mkdirs(this.file.getParentFile());
            PartialFile partFile = BasicRepositoryConnector.this.partialFileFactory.newInstance(this.file, this);
            if (partFile == null) {
                LOGGER.debug("Concurrent download of {} just finished, skipping download", (Object)this.file);
                return;
            }
            try {
                File tmp = partFile.getFile();
                this.listener.setChecksumCalculator(this.checksumValidator.newChecksumCalculator(tmp));
                int firstTrial = 0;
                int lastTrial = 1;
                int trial = firstTrial;
                while (true) {
                    boolean resume = partFile.isResume() && trial <= firstTrial;
                    GetTask task = new GetTask(this.path).setDataFile(tmp, resume).setListener(this.listener);
                    BasicRepositoryConnector.this.transporter.get(task);
                    try {
                        this.checksumValidator.validate(this.listener.getChecksums(), BasicRepositoryConnector.this.smartChecksums ? task.getChecksums() : null);
                    }
                    catch (ChecksumFailureException e) {
                        boolean retry;
                        boolean bl = retry = trial < lastTrial && e.isRetryWorthy();
                        if (!retry && !this.checksumValidator.handle(e)) {
                            throw e;
                        }
                        this.listener.transferCorrupted(e);
                        if (!retry) break;
                        this.checksumValidator.retry();
                        ++trial;
                        continue;
                    }
                    break;
                }
                BasicRepositoryConnector.this.fileProcessor.move(tmp, this.file);
                if (BasicRepositoryConnector.this.persistedChecksums) {
                    this.checksumValidator.commit();
                }
            }
            finally {
                partFile.close();
                this.checksumValidator.close();
            }
        }
    }

    class PeekTaskRunner
    extends TaskRunner {
        PeekTaskRunner(URI path, TransferTransportListener<?> listener) {
            super(path, listener);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }
    }

    abstract class TaskRunner
    implements Runnable {
        protected final URI path;
        protected final TransferTransportListener<?> listener;

        TaskRunner(URI path, TransferTransportListener<?> listener) {
            this.path = path;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.listener.transferInitiated();
                this.runTask();
                this.listener.transferSucceeded();
            }
            catch (Exception e) {
                this.listener.transferFailed(e, BasicRepositoryConnector.this.transporter.classify(e));
            }
        }

        protected abstract void runTask() throws Exception;
    }
}

