/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.List;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsComment;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.util.TextOutputImpl;

abstract class AbstractNode
extends HasMetadata
implements JsNode {
    private List<JsComment> commentsBefore = null;
    private List<JsComment> commentsAfter = null;

    AbstractNode() {
    }

    public String toString() {
        TextOutputImpl out = new TextOutputImpl();
        new JsToStringGenerationVisitor(out).accept(this);
        return out.toString();
    }

    public <T extends HasMetadata> T withMetadataFrom(T other) {
        this.copyMetadataFrom(other);
        Object otherSource = ((JsNode)((Object)other)).getSource();
        if (otherSource != null) {
            this.source(otherSource);
        }
        this.setCommentsBeforeNode(((JsNode)((Object)other)).getCommentsBeforeNode());
        this.setCommentsAfterNode(((JsNode)((Object)other)).getCommentsAfterNode());
        return (T)this;
    }

    @Override
    public List<JsComment> getCommentsBeforeNode() {
        return this.commentsBefore;
    }

    @Override
    public List<JsComment> getCommentsAfterNode() {
        return this.commentsAfter;
    }

    @Override
    public void setCommentsBeforeNode(List<JsComment> comments) {
        this.commentsBefore = comments;
    }

    @Override
    public void setCommentsAfterNode(List<JsComment> comments) {
        this.commentsAfter = comments;
    }
}

