/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDeprecatedAnnotations", "annotationCall", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isForbidden", "", "checkTypeParcelerUsage", "checkWriteWithUsage", "parcelize.k2"})
public final class FirParcelizeAnnotationChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirParcelizeAnnotationChecker INSTANCE = new FirParcelizeAnnotationChecker();

    private FirParcelizeAnnotationChecker() {
    }

    public void check(@NotNull FirAnnotationCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeKotlinType coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)expression.getAnnotationTypeRef()), (FirSession)context.getSession());
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType annotationType = coneClassLikeType;
        FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)annotationType.getLookupTag(), (FirSession)context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol resolvedAnnotationSymbol = firRegularClassSymbol;
        ClassId annotationClassId = resolvedAnnotationSymbol.getClassId();
        if (ParcelizeNames.INSTANCE.getTYPE_PARCELER_CLASS_IDS().contains(annotationClassId)) {
            this.checkTypeParcelerUsage(expression, context, reporter);
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, true);
        } else if (ParcelizeNames.INSTANCE.getWRITE_WITH_CLASS_IDS().contains(annotationClassId)) {
            this.checkWriteWithUsage(expression, context, reporter);
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, true);
        } else if (ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS().contains(annotationClassId)) {
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, false);
        } else if (ParcelizeNames.INSTANCE.getPARCELIZE_CLASS_CLASS_IDS().contains(annotationClassId) ? true : ParcelizeNames.INSTANCE.getRAW_VALUE_ANNOTATION_CLASS_IDS().contains(annotationClassId)) {
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, false);
        }
    }

    private final void checkDeprecatedAnnotations(FirAnnotationCall annotationCall, ClassId annotationClassId, CheckerContext context, DiagnosticReporter reporter, boolean isForbidden) {
        if (Intrinsics.areEqual((Object)annotationClassId.getPackageFqName(), (Object)ParcelizeNames.INSTANCE.getDEPRECATED_RUNTIME_PACKAGE())) {
            KtDiagnosticFactory0 factory = isForbidden ? KtErrorsParcelize.INSTANCE.getFORBIDDEN_DEPRECATED_ANNOTATION() : KtErrorsParcelize.INSTANCE.getDEPRECATED_ANNOTATION();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotationCall.getSource()), (KtDiagnosticFactory0)factory, (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    private final void checkTypeParcelerUsage(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
    }

    private final void checkWriteWithUsage(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
    }
}

