/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0002H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizePropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkParcelableClassProperty", "property", "containingClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "hasCustomParceler", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasIgnoredOnParcel", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "parcelize.k2"})
public final class FirParcelizePropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirParcelizePropertyChecker INSTANCE = new FirParcelizePropertyChecker();

    private FirParcelizePropertyChecker() {
    }

    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeSimpleKotlinType coneSimpleKotlinType = declaration.getDispatchReceiverType();
        if (coneSimpleKotlinType == null || (coneSimpleKotlinType = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)((ConeKotlinType)coneSimpleKotlinType), (FirSession)context.getSession())) == null) {
            return;
        }
        ConeSimpleKotlinType containingClassSymbol = coneSimpleKotlinType;
        if (FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)containingClassSymbol, context.getSession())) {
            boolean fromPrimaryConstructor;
            Boolean bl = DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)declaration);
            boolean bl2 = fromPrimaryConstructor = bl != null ? bl : false;
            if (!(fromPrimaryConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)declaration) && declaration.getDelegate() == null || this.hasIgnoredOnParcel(declaration) || this.hasCustomParceler((FirRegularClassSymbol)containingClassSymbol, context.getSession()))) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPROPERTY_WONT_BE_SERIALIZED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
            if (fromPrimaryConstructor) {
                this.checkParcelableClassProperty(declaration, (FirRegularClassSymbol)containingClassSymbol, context, reporter);
            }
        }
        if (Intrinsics.areEqual((Object)declaration.getName(), (Object)ParcelizeNames.INSTANCE.getCREATOR_NAME())) {
            FirClassSymbol $this$isCompanion$iv = (FirClassSymbol)containingClassSymbol;
            boolean $i$f$isCompanion = false;
            if ($this$isCompanion$iv.getRawStatus().isCompanion()) {
                boolean bl;
                block11: {
                    FirProperty $this$hasJvmFieldAnnotation$iv = declaration;
                    boolean $i$f$getHasJvmFieldAnnotation = false;
                    Iterable $this$any$iv$iv = $this$hasJvmFieldAnnotation$iv.getAnnotations();
                    boolean $i$f$any = false;
                    if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv$iv : $this$any$iv$iv) {
                            FirAnnotation it$iv = (FirAnnotation)element$iv$iv;
                            boolean bl3 = false;
                            if (!FirAnnotationUtilsKt.isJvmFieldAnnotation((FirAnnotation)it$iv)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    FirRegularClass outerClass;
                    Object object = CollectionsKt.getOrNull((List)CollectionsKt.asReversed((List)context.getContainingDeclarations()), (int)1);
                    FirRegularClass firRegularClass = outerClass = object instanceof FirRegularClass ? (FirRegularClass)object : null;
                    if (outerClass != null && FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)outerClass.getSymbol(), context.getSession())) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getCREATOR_DEFINITION_IS_NOT_ALLOWED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                    }
                }
            }
        }
    }

    private final void checkParcelableClassProperty(FirProperty property, FirRegularClassSymbol containingClassSymbol, CheckerContext context, DiagnosticReporter reporter) {
        ConeKotlinType type = FirTypeUtilsKt.getConeType((FirTypeRef)property.getReturnTypeRef());
        if (type instanceof ConeErrorType || this.hasCustomParceler(containingClassSymbol, context.getSession())) {
            return;
        }
    }

    private final boolean hasIgnoredOnParcel(FirProperty $this$hasIgnoredOnParcel) {
        Object object;
        return this.hasIgnoredOnParcel($this$hasIgnoredOnParcel.getAnnotations()) || ((object = $this$hasIgnoredOnParcel.getGetter()) != null && (object = object.getAnnotations()) != null ? this.hasIgnoredOnParcel((List<? extends FirAnnotation>)object) : false);
    }

    private final boolean hasIgnoredOnParcel(List<? extends FirAnnotation> $this$hasIgnoredOnParcel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasIgnoredOnParcel;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnnotationUseSiteTarget target;
                    FirAnnotation it = (FirAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!(!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS(), (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)it.getAnnotationTypeRef()))) ? false : (target = it.getUseSiteTarget()) == null || target == AnnotationUseSiteTarget.PROPERTY || target == AnnotationUseSiteTarget.PROPERTY_GETTER)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasCustomParceler(FirRegularClassSymbol $this$hasCustomParceler, FirSession session) {
        boolean bl;
        block4: {
            FirRegularClassSymbol firRegularClassSymbol = $this$hasCustomParceler.getCompanionObjectSymbol();
            if (firRegularClassSymbol == null) {
                return false;
            }
            FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol;
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default((FirClassifierSymbol)((FirClassifierSymbol)companionObjectSymbol), (boolean)true, (boolean)true, (FirSession)session, null, (int)16, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it)), (Object)ParcelizeNames.INSTANCE.getPARCELER_ID())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

