/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

public class JsPropertyInitializer
extends SourceInfoAwareJsNode {
    @NotNull
    private JsExpression labelExpr;
    @NotNull
    private JsExpression valueExpr;

    public JsPropertyInitializer(@NotNull JsExpression labelExpr, @NotNull JsExpression valueExpr) {
        if (labelExpr == null) {
            JsPropertyInitializer.$$$reportNull$$$0(0);
        }
        if (valueExpr == null) {
            JsPropertyInitializer.$$$reportNull$$$0(1);
        }
        this.labelExpr = labelExpr;
        this.valueExpr = valueExpr;
    }

    @NotNull
    public JsExpression getLabelExpr() {
        JsExpression jsExpression = this.labelExpr;
        if (jsExpression == null) {
            JsPropertyInitializer.$$$reportNull$$$0(2);
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getValueExpr() {
        JsExpression jsExpression = this.valueExpr;
        if (jsExpression == null) {
            JsPropertyInitializer.$$$reportNull$$$0(3);
        }
        return jsExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitPropertyInitializer(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.labelExpr);
        visitor2.accept(this.valueExpr);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            JsExpression newLabel = v.accept(this.labelExpr);
            JsExpression newValue2 = v.accept(this.valueExpr);
            assert (newLabel != null) : "Label cannot be replaced with null";
            assert (newValue2 != null) : "Value cannot be replaced with null";
            this.labelExpr = newLabel;
            this.valueExpr = newValue2;
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsPropertyInitializer deepCopy() {
        JsPropertyInitializer jsPropertyInitializer = (JsPropertyInitializer)new JsPropertyInitializer(this.labelExpr.deepCopy(), this.valueExpr.deepCopy()).withMetadataFrom(this);
        if (jsPropertyInitializer == null) {
            JsPropertyInitializer.$$$reportNull$$$0(4);
        }
        return jsPropertyInitializer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExpr";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelExpr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExpr";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

