/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.metadata;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentTypeTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SupposititiousSimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/metadata/NativeTypeTransformer;", "Lorg/jetbrains/kotlin/descriptors/deserialization/PlatformDependentTypeTransformer;", "()V", "transformPlatformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "computedType", "Companion", "kotlin-util-klib-metadata"})
public final class NativeTypeTransformer
implements PlatformDependentTypeTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName cNames = new FqName("cnames");
    @NotNull
    private static final FqName cNamesStructs;
    @NotNull
    private static final FqName objCNames;
    @NotNull
    private static final FqName objCNamesClasses;
    @NotNull
    private static final FqName objCNamesProtocols;
    @NotNull
    private static final Set<FqName> forwardPackagesSet;

    @Override
    @NotNull
    public SimpleType transformPlatformType(@NotNull ClassId classId, @NotNull SimpleType computedType) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(computedType, "computedType");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        FqName originalPackageFqn = fqName2;
        if (forwardPackagesSet.contains(originalPackageFqn)) {
            TypeConstructor constructor2 = computedType.getConstructor();
            ClassifierDescriptor classifierDescriptor = constructor2.getDeclarationDescriptor();
            Intrinsics.checkNotNull(classifierDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
            DeclarationDescriptor declarationDescriptor = classDescriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor");
            FqName realPackageFqn = ((PackageFragmentDescriptor)declarationDescriptor).getFqName();
            if (!Intrinsics.areEqual(originalPackageFqn, realPackageFqn)) {
                return new SupposititiousSimpleType(computedType, classId);
            }
        }
        return computedType;
    }

    static {
        FqName fqName2 = cNames.child(Name.identifier("structs"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "cNames.child(Name.identifier(\"structs\"))");
        cNamesStructs = fqName2;
        objCNames = new FqName("objcnames");
        FqName fqName3 = objCNames.child(Name.identifier("classes"));
        Intrinsics.checkNotNullExpressionValue(fqName3, "objCNames.child(Name.identifier(\"classes\"))");
        objCNamesClasses = fqName3;
        FqName fqName4 = objCNames.child(Name.identifier("protocols"));
        Intrinsics.checkNotNullExpressionValue(fqName4, "objCNames.child(Name.identifier(\"protocols\"))");
        objCNamesProtocols = fqName4;
        FqName[] fqNameArray = new FqName[]{cNamesStructs, objCNamesClasses, objCNamesProtocols};
        forwardPackagesSet = SetsKt.setOf(fqNameArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/metadata/NativeTypeTransformer$Companion;", "", "()V", "cNames", "Lorg/jetbrains/kotlin/name/FqName;", "cNamesStructs", "forwardPackagesSet", "", "objCNames", "objCNamesClasses", "objCNamesProtocols", "kotlin-util-klib-metadata"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

