/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi.kotlinx.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.InconsistentKotlinMetadataException;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClassifier;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmExtensionType;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmExtensionVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmFlexibleTypeUpperBound;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmTypeExtensionVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmTypeProjection;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmTypeVisitor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmVariance;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.impl.extensions.ExtensionUtilsKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.impl.extensions.KmTypeExtension;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.impl.extensions.MetadataExtensions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0001J\u0014\u0010(\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u001c\u0010)\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010*\u001a\u00020+H\u0016J\u0014\u0010,\u001a\u00020&2\n\u0010-\u001a\u00060.j\u0002`/H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\u00104\u001a\u0004\u0018\u00010.H\u0016J\u0014\u00105\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\b\u00106\u001a\u00020&H\u0016J\u0014\u00107\u001a\u00020&2\n\u0010-\u001a\u00060.j\u0002`/H\u0016J\u0010\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020\u0003H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0005R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\n\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmType;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmTypeVisitor;", "flags", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/Flags;", "(I)V", "abbreviatedType", "getAbbreviatedType", "()Lkotlinx/metadata/KmType;", "setAbbreviatedType", "(Lkotlinx/metadata/KmType;)V", "arguments", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmTypeProjection;", "getArguments", "()Ljava/util/List;", "classifier", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmClassifier;", "getClassifier", "()Lkotlinx/metadata/KmClassifier;", "setClassifier", "(Lkotlinx/metadata/KmClassifier;)V", "extensions", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/impl/extensions/KmTypeExtension;", "getFlags", "()I", "setFlags", "flexibleTypeUpperBound", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmFlexibleTypeUpperBound;", "getFlexibleTypeUpperBound", "()Lkotlinx/metadata/KmFlexibleTypeUpperBound;", "setFlexibleTypeUpperBound", "(Lkotlinx/metadata/KmFlexibleTypeUpperBound;)V", "outerType", "getOuterType", "setOuterType", "accept", "", "visitor", "visitAbbreviatedType", "visitArgument", "variance", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmVariance;", "visitClass", "name", "", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/ClassName;", "visitExtensions", "type", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmExtensionType;", "visitFlexibleTypeUpperBound", "typeFlexibilityId", "visitOuterType", "visitStarProjection", "visitTypeAlias", "visitTypeParameter", "id", "kotlinx-metadata"})
public final class KmType
extends KmTypeVisitor {
    private int flags;
    public KmClassifier classifier;
    @NotNull
    private final List<KmTypeProjection> arguments;
    @Nullable
    private KmType abbreviatedType;
    @Nullable
    private KmType outerType;
    @Nullable
    private KmFlexibleTypeUpperBound flexibleTypeUpperBound;
    @NotNull
    private final List<KmTypeExtension> extensions;

    /*
     * WARNING - void declaration
     */
    public KmType(int flags) {
        super(null, 1, null);
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.flags = flags;
        this.arguments = new ArrayList(0);
        Iterable iterable = MetadataExtensions.Companion.getINSTANCES();
        KmType kmType = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MetadataExtensions metadataExtensions = (MetadataExtensions)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.createTypeExtension());
        }
        kmType.extensions = (List)destination$iv$iv;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int n) {
        this.flags = n;
    }

    @NotNull
    public final KmClassifier getClassifier() {
        KmClassifier kmClassifier = this.classifier;
        if (kmClassifier != null) {
            return kmClassifier;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"classifier");
        return null;
    }

    public final void setClassifier(@NotNull KmClassifier kmClassifier) {
        Intrinsics.checkNotNullParameter((Object)kmClassifier, (String)"<set-?>");
        this.classifier = kmClassifier;
    }

    @NotNull
    public final List<KmTypeProjection> getArguments() {
        return this.arguments;
    }

    @Nullable
    public final KmType getAbbreviatedType() {
        return this.abbreviatedType;
    }

    public final void setAbbreviatedType(@Nullable KmType kmType) {
        this.abbreviatedType = kmType;
    }

    @Nullable
    public final KmType getOuterType() {
        return this.outerType;
    }

    public final void setOuterType(@Nullable KmType kmType) {
        this.outerType = kmType;
    }

    @Nullable
    public final KmFlexibleTypeUpperBound getFlexibleTypeUpperBound() {
        return this.flexibleTypeUpperBound;
    }

    public final void setFlexibleTypeUpperBound(@Nullable KmFlexibleTypeUpperBound kmFlexibleTypeUpperBound) {
        this.flexibleTypeUpperBound = kmFlexibleTypeUpperBound;
    }

    @Override
    public void visitClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setClassifier(new KmClassifier.Class(name));
    }

    @Override
    public void visitTypeAlias(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setClassifier(new KmClassifier.TypeAlias(name));
    }

    @Override
    public void visitTypeParameter(int id) {
        this.setClassifier(new KmClassifier.TypeParameter(id));
    }

    @Override
    @NotNull
    public KmTypeVisitor visitArgument(int flags, @NotNull KmVariance variance) {
        KmType kmType;
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
        KmType it = kmType = new KmType(flags);
        boolean bl = false;
        this.arguments.add(new KmTypeProjection(variance, it));
        return kmType;
    }

    @Override
    public void visitStarProjection() {
        this.arguments.add(KmTypeProjection.STAR);
    }

    @Override
    @NotNull
    public KmTypeVisitor visitAbbreviatedType(int flags) {
        KmType kmType;
        KmType it = kmType = new KmType(flags);
        boolean bl = false;
        this.abbreviatedType = it;
        return kmType;
    }

    @Override
    @NotNull
    public KmTypeVisitor visitOuterType(int flags) {
        KmType kmType;
        KmType it = kmType = new KmType(flags);
        boolean bl = false;
        this.outerType = it;
        return kmType;
    }

    @Override
    @NotNull
    public KmTypeVisitor visitFlexibleTypeUpperBound(int flags, @Nullable String typeFlexibilityId) {
        KmType kmType;
        KmType it = kmType = new KmType(flags);
        boolean bl = false;
        this.flexibleTypeUpperBound = new KmFlexibleTypeUpperBound(it, typeFlexibilityId);
        return kmType;
    }

    @Override
    @NotNull
    public KmTypeExtension visitExtensions(@NotNull KmExtensionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return (KmTypeExtension)ExtensionUtilsKt.singleOfType((Collection)this.extensions, type);
    }

    public final void accept(@NotNull KmTypeVisitor visitor) {
        KmTypeVisitor p0;
        Object it;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        KmClassifier classifier = this.getClassifier();
        if (classifier instanceof KmClassifier.Class) {
            visitor.visitClass(((KmClassifier.Class)classifier).getName());
        } else if (classifier instanceof KmClassifier.TypeParameter) {
            visitor.visitTypeParameter(((KmClassifier.TypeParameter)classifier).getId());
        } else if (classifier instanceof KmClassifier.TypeAlias) {
            visitor.visitTypeAlias(((KmClassifier.TypeAlias)classifier).getName());
        }
        Iterable $this$forEach$iv = this.arguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmTypeVisitor p02;
            KmTypeProjection argument = (KmTypeProjection)element$iv;
            boolean bl5 = false;
            if (Intrinsics.areEqual((Object)argument, (Object)KmTypeProjection.STAR)) {
                visitor.visitStarProjection();
                continue;
            }
            KmVariance variance = argument.component1();
            KmType type = argument.component2();
            if (variance == null || type == null) {
                throw new InconsistentKotlinMetadataException("Variance and type must be set for non-star type projection", null, 2, null);
            }
            if (visitor.visitArgument(type.flags, variance) == null) continue;
            boolean bl2 = false;
            type.accept(p02);
        }
        KmType kmType = this.abbreviatedType;
        if (kmType != null) {
            it = kmType;
            boolean bl = false;
            KmTypeVisitor kmTypeVisitor = visitor.visitAbbreviatedType(((KmType)it).flags);
            if (kmTypeVisitor != null) {
                p0 = kmTypeVisitor;
                boolean bl3 = false;
                ((KmType)it).accept(p0);
            }
        }
        KmType kmType2 = this.outerType;
        if (kmType2 != null) {
            it = kmType2;
            boolean bl = false;
            KmTypeVisitor kmTypeVisitor = visitor.visitOuterType(((KmType)it).flags);
            if (kmTypeVisitor != null) {
                p0 = kmTypeVisitor;
                boolean bl4 = false;
                ((KmType)it).accept(p0);
            }
        }
        KmFlexibleTypeUpperBound kmFlexibleTypeUpperBound = this.flexibleTypeUpperBound;
        if (kmFlexibleTypeUpperBound != null) {
            it = kmFlexibleTypeUpperBound;
            boolean bl = false;
            KmTypeVisitor kmTypeVisitor = visitor.visitFlexibleTypeUpperBound(((KmFlexibleTypeUpperBound)it).getType().flags, ((KmFlexibleTypeUpperBound)it).getTypeFlexibilityId());
            if (kmTypeVisitor != null) {
                KmTypeVisitor bl5 = kmTypeVisitor;
                KmType kmType3 = ((KmFlexibleTypeUpperBound)it).getType();
                KmTypeVisitor p03 = bl5;
                boolean bl6 = false;
                kmType3.accept(p03);
            }
        }
        $this$forEach$iv = this.extensions;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmTypeExtensionVisitor p04;
            KmTypeExtension it2 = (KmTypeExtension)element$iv;
            boolean bl = false;
            if (visitor.visitExtensions(it2.getType()) == null) continue;
            boolean bl7 = false;
            it2.accept((KmExtensionVisitor)p04);
        }
        visitor.visitEnd();
    }
}

