/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\fJ\u0014\u0010&\u001a\u00020'*\u00020\u001b2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0014\u0010(\u001a\u00020\u001e*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/DeclarationExporter;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "(Lorg/jetbrains/kotlin/js/translate/context/StaticContext;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "localPackageNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "objectLikeKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getStatements", "()Ljava/util/List;", "assign", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "export", "force", "", "exportObject", "declaration", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "exportProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getLocalPackageName", "packageName", "exportStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "shouldBeExported", "js.translator"})
public final class DeclarationExporter {
    @NotNull
    private final StaticContext context;
    @NotNull
    private final Set<ClassKind> objectLikeKinds;
    @NotNull
    private final Set<MemberDescriptor> exportedDeclarations;
    @NotNull
    private final Map<FqName, JsName> localPackageNames;

    public DeclarationExporter(@NotNull StaticContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.OBJECT, ClassKind.ENUM_ENTRY};
        this.objectLikeKinds = SetsKt.setOf(classKindArray);
        this.exportedDeclarations = new LinkedHashSet();
        this.localPackageNames = new LinkedHashMap();
    }

    @NotNull
    public final StaticContext getContext() {
        return this.context;
    }

    private final List<JsStatement> getStatements() {
        List<JsStatement> list2 = this.context.getFragment().getExportBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
        return list2;
    }

    public final void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.exportedDeclarations.contains(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
            return;
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            return;
        }
        if (InlineOnlyKt.isEffectivelyInlineOnly(descriptor2)) {
            return;
        }
        NameSuggestion nameSuggestion = this.context.getNameSuggestion();
        DeclarationDescriptor declarationDescriptor = descriptor2;
        BindingContext bindingContext = this.context.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        SuggestedName suggestedName = nameSuggestion.suggest(declarationDescriptor, bindingContext);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        DeclarationDescriptor container = suggestedName2.getScope();
        if (!this.shouldBeExported(descriptor2, force)) {
            return;
        }
        this.exportedDeclarations.add(descriptor2);
        JsExpression jsExpression = container instanceof PackageFragmentDescriptor ? (JsExpression)this.getLocalPackageName(((PackageFragmentDescriptor)container).getFqName()).makeRef() : (DescriptorUtils.isObject(container) ? JsAstUtils.prototypeOf(this.context.getInnerNameForDescriptor(container).makeRef()) : (JsExpression)this.context.getInnerNameForDescriptor(container).makeRef());
        Intrinsics.checkNotNull(jsExpression);
        JsExpression qualifier2 = jsExpression;
        if (descriptor2 instanceof ClassDescriptor && this.objectLikeKinds.contains((Object)((ClassDescriptor)descriptor2).getKind())) {
            this.exportObject((ClassDescriptor)descriptor2, qualifier2);
        } else if (descriptor2 instanceof PropertyDescriptor && container instanceof PackageFragmentDescriptor) {
            this.exportProperty((PropertyDescriptor)descriptor2, qualifier2);
        } else {
            this.assign(descriptor2, qualifier2);
        }
    }

    private final void assign(DeclarationDescriptor descriptor2, JsExpression qualifier2) {
        JsName jsName = this.context.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(...)");
        JsName exportedName = jsName;
        JsNameRef jsNameRef = exportedName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
        JsNameRef expression2 = jsNameRef;
        JsName jsName2 = this.context.getNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsName2, "getNameForDescriptor(...)");
        JsName propertyName = jsName2;
        if (MetadataProperties.getStaticRef(propertyName) == null && !Intrinsics.areEqual(exportedName, propertyName)) {
            MetadataProperties.setStaticRef(propertyName, expression2);
        }
        Collection collection = this.getStatements();
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(new JsNameRef(propertyName, qualifier2), expression2);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "assignment(...)");
        collection.add(this.exportStatement(jsBinaryOperation, descriptor2));
    }

    private final void exportObject(ClassDescriptor declaration, JsExpression qualifier2) {
        JsName jsName = this.context.getNameForDescriptor(declaration);
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(...)");
        JsName name2 = jsName;
        JsExpression jsExpression = JsAstUtils.defineGetter(qualifier2, name2.getIdent(), this.context.getNameForObjectInstance(declaration).makeRef());
        Intrinsics.checkNotNullExpressionValue(jsExpression, "defineGetter(...)");
        JsExpression expression2 = jsExpression;
        ((Collection)this.getStatements()).add(this.exportStatement(expression2, declaration));
    }

    private final void exportProperty(PropertyDescriptor declaration, JsExpression qualifier2) {
        JsExpression jsExpression;
        Object accessToField;
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        String string2 = this.context.getNameForDescriptor(declaration).getIdent();
        Intrinsics.checkNotNullExpressionValue(string2, "getIdent(...)");
        String name2 = string2;
        boolean simpleProperty = JsDescriptorUtils.isSimpleFinalProperty(declaration) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)declaration);
        JsName exportedName = null;
        if (simpleProperty) {
            JsName jsName = this.context.getInnerNameForDescriptor(declaration);
            Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(...)");
            exportedName = jsName;
            accessToField = new JsReturn(exportedName.makeRef());
            jsExpression = new JsFunction(this.context.getFragment().getScope(), new JsBlock((JsStatement)accessToField), declaration + " getter");
        } else {
            PropertyGetterDescriptor propertyGetterDescriptor = declaration.getGetter();
            Intrinsics.checkNotNull(propertyGetterDescriptor);
            JsName jsName = this.context.getInnerNameForDescriptor(propertyGetterDescriptor);
            Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(...)");
            exportedName = jsName;
            accessToField = exportedName.makeRef();
            Intrinsics.checkNotNull(accessToField);
            jsExpression = (JsExpression)accessToField;
        }
        JsExpression getterBody = jsExpression;
        List<JsPropertyInitializer> list2 = propertyLiteral.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list2, "getPropertyInitializers(...)");
        accessToField = list2;
        accessToField.add(new JsPropertyInitializer(new JsNameRef("get"), getterBody));
        if (declaration.isVar()) {
            Object object;
            JsExpression jsExpression2;
            if (simpleProperty) {
                List statements2 = new ArrayList();
                JsFunction function2 = new JsFunction(this.context.getFragment().getScope(), new JsBlock(statements2), declaration + " setter");
                SourceElement sourceElement = declaration.getSource();
                Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
                function2.setSource(PsiSourceElementKt.getPsi(sourceElement));
                JsName jsName = JsScope.declareTemporaryName("value");
                Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
                JsName valueName = jsName;
                List<JsParameter> list3 = function2.getParameters();
                Intrinsics.checkNotNullExpressionValue(list3, "getParameters(...)");
                Collection collection = list3;
                collection.add(new JsParameter(valueName));
                ((Collection)statements2).add(JsAstUtils.assignment(this.context.getInnerNameForDescriptor(declaration).makeRef(), valueName.makeRef()).makeStmt());
                jsExpression2 = function2;
            } else {
                PropertySetterDescriptor propertySetterDescriptor = declaration.getSetter();
                Intrinsics.checkNotNull(propertySetterDescriptor);
                object = this.context.getInnerNameForDescriptor(propertySetterDescriptor).makeRef();
                Intrinsics.checkNotNull(object);
                jsExpression2 = (JsExpression)object;
            }
            JsExpression setterBody = jsExpression2;
            List<JsPropertyInitializer> list4 = propertyLiteral.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list4, "getPropertyInitializers(...)");
            object = list4;
            object.add(new JsPropertyInitializer(new JsNameRef("set"), setterBody));
        }
        Collection collection = this.getStatements();
        JsInvocation jsInvocation = JsAstUtils.defineProperty(qualifier2, name2, propertyLiteral);
        Intrinsics.checkNotNullExpressionValue(jsInvocation, "defineProperty(...)");
        collection.add(this.exportStatement(jsInvocation, declaration));
    }

    @NotNull
    public final JsName getLocalPackageName(@NotNull FqName packageName2) {
        Intrinsics.checkNotNullParameter(packageName2, "packageName");
        if (packageName2.isRoot()) {
            JsName jsName = this.context.getFragment().getScope().declareName(Namer.getRootPackageName());
            Intrinsics.checkNotNullExpressionValue(jsName, "declareName(...)");
            return jsName;
        }
        JsName name2 = this.localPackageNames.get(packageName2);
        if (name2 == null) {
            name2 = JsScope.declareTemporaryName("package$" + packageName2.shortName().asString());
            this.localPackageNames.put(packageName2, name2);
            Collection collection = this.getStatements();
            String string2 = packageName2.shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String string3 = packageName2.asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            FqName fqName2 = packageName2.parent();
            Intrinsics.checkNotNullExpressionValue(fqName2, "parent(...)");
            JsNameRef jsNameRef = this.getLocalPackageName(fqName2).makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            collection.add(UtilsKt.definePackageAlias(string2, name2, string3, jsNameRef));
        }
        return name2;
    }

    private final JsExpressionStatement exportStatement(JsExpression $this$exportStatement, DeclarationDescriptor declaration) {
        JsExpressionStatement jsExpressionStatement;
        JsExpressionStatement it = jsExpressionStatement = new JsExpressionStatement($this$exportStatement);
        boolean bl = false;
        MetadataProperties.setExportedTag(it, this.context.getTag(declaration));
        return jsExpressionStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeExported(MemberDescriptor $this$shouldBeExported, boolean force) {
        if (force) return true;
        DeclarationDescriptor declarationDescriptor = $this$shouldBeExported;
        JsConfig jsConfig = this.context.getConfig();
        Intrinsics.checkNotNullExpressionValue(jsConfig, "getConfig(...)");
        if (!DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) return false;
        return true;
    }
}

