/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.TypesKt;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/EqualsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "isNegated", "", "<init>", "(Z)V", "()Z", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "invokeWithArguments", "left", "right", "equateCallAndConstant", "call", "constant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "isSafeToProduceFalse", "leftCall", "leftConstant", "rightConstant", "equateValues", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "resolution"})
@SourceDebugExtension(value={"SMAP\nEqualsFunctor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EqualsFunctor.kt\norg/jetbrains/kotlin/contracts/model/functors/EqualsFunctor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class EqualsFunctor
extends AbstractFunctor {
    private final boolean isNegated;

    public EqualsFunctor(boolean isNegated) {
        this.isNegated = isNegated;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        boolean bl2 = bl = arguments.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Equals functor expected 2 arguments, got " + arguments.size();
            throw new AssertionError((Object)string2);
        }
        if (arguments.size() != 2) {
            return CollectionsKt.emptyList();
        }
        return this.invokeWithArguments(arguments.get(0), arguments.get(1));
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation left, @NotNull Computation right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        if (left instanceof ESValue && right instanceof ESValue) {
            return this.equateValues((ESValue)left, (ESValue)right);
        }
        if (left instanceof ESConstant) {
            return this.equateCallAndConstant(right, (ESConstant)left);
        }
        if (right instanceof ESConstant) {
            return this.equateCallAndConstant(left, (ESConstant)right);
        }
        return CollectionsKt.emptyList();
    }

    private final List<ESEffect> equateCallAndConstant(Computation call2, ESConstant constant) {
        List resultingClauses = new ArrayList();
        for (ESEffect effect : call2.getEffects()) {
            if (!(effect instanceof ConditionalEffect) || !(((ConditionalEffect)effect).getSimpleEffect() instanceof ESReturns) || ValuesKt.isWildcard(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue())) {
                ((Collection)resultingClauses).add(effect);
                continue;
            }
            if (Intrinsics.areEqual(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) {
                ConditionalEffect trueClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(ESConstants.INSTANCE.booleanValue(!this.isNegated)));
                resultingClauses.add(trueClause);
            }
            if (Intrinsics.areEqual(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant) || !(((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue() instanceof ESConstant) || !this.isSafeToProduceFalse(call2, (ESConstant)((ESReturns)((ConditionalEffect)effect).getSimpleEffect()).getValue(), constant)) continue;
            ConditionalEffect falseClause = new ConditionalEffect(((ConditionalEffect)effect).getCondition(), new ESReturns(ESConstants.INSTANCE.booleanValue(this.isNegated)));
            resultingClauses.add(falseClause);
        }
        return resultingClauses;
    }

    private final boolean isSafeToProduceFalse(Computation leftCall, ESConstant leftConstant, ESConstant rightConstant) {
        return TypesKt.isBoolean(rightConstant.getType()) && TypesKt.isBoolean(leftCall.getType()) ? true : leftConstant.isNullConstant() && rightConstant.isNullConstant();
    }

    private final List<ESEffect> equateValues(ESValue left, ESValue right) {
        ConditionalEffect[] conditionalEffectArray = new ConditionalEffect[]{new ConditionalEffect(new ESEqual(left, right, this.isNegated), new ESReturns(ESConstants.INSTANCE.getTrueValue())), new ConditionalEffect(new ESEqual(left, right, !this.isNegated), new ESReturns(ESConstants.INSTANCE.getFalseValue()))};
        return CollectionsKt.listOf(conditionalEffectArray);
    }
}

