/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryBytesSource;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrExpression;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrStatement;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.library.encodings.WobblyTF8;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "bytesSource", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryBytesSource;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryBytesSource;)V", "declaration", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "index", "", "type", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrType;", "signature", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "string", "", "expressionBody", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrExpression;", "statementBody", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrStatement;", "debugInfo", "Companion", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrFileDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class IrLibraryFileFromBytes
extends IrLibraryFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrLibraryBytesSource bytesSource;
    @NotNull
    private static final ExtensionRegistryLite extensionRegistryLite;

    public IrLibraryFileFromBytes(@NotNull IrLibraryBytesSource bytesSource) {
        Intrinsics.checkNotNullParameter(bytesSource, "bytesSource");
        this.bytesSource = bytesSource;
    }

    @Override
    @NotNull
    public IrDeclaration declaration(int index) {
        IrDeclaration irDeclaration2 = IrDeclaration.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.irDeclaration(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue(irDeclaration2, "parseFrom(...)");
        return irDeclaration2;
    }

    @Override
    @NotNull
    public IrType type(int index) {
        IrType irType = IrType.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.type(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue(irType, "parseFrom(...)");
        return irType;
    }

    @Override
    @NotNull
    public IdSignature signature(int index) {
        IdSignature idSignature = IdSignature.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.signature(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue(idSignature, "parseFrom(...)");
        return idSignature;
    }

    @Override
    @NotNull
    public String string(int index) {
        return WobblyTF8.INSTANCE.decode(this.bytesSource.string(index));
    }

    @Override
    @NotNull
    public IrExpression expressionBody(int index) {
        IrExpression irExpression = IrExpression.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.body(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue(irExpression, "parseFrom(...)");
        return irExpression;
    }

    @Override
    @NotNull
    public IrStatement statementBody(int index) {
        IrStatement irStatement = IrStatement.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.body(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue(irStatement, "parseFrom(...)");
        return irStatement;
    }

    @Override
    @Nullable
    public String debugInfo(int index) {
        String string2;
        byte[] byArray = this.bytesSource.debugInfo(index);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            string2 = WobblyTF8.INSTANCE.decode(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkNotNullExpressionValue(extensionRegistryLite, "newInstance(...)");
        IrLibraryFileFromBytes.extensionRegistryLite = extensionRegistryLite;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes$Companion;", "", "<init>", "()V", "extensionRegistryLite", "Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "getExtensionRegistryLite", "()Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionRegistryLite getExtensionRegistryLite() {
            return extensionRegistryLite;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

