/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.FunctionalInterfacesUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\tH\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020;03H\u0016J\b\u0010<\u001a\u00020\u0016H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020*0)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "delegate", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)V", "irBuiltInsMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "contains", "", "idSig", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "idSignature", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "deserializeReachableDeclarations", "", "computeFunctionClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "className", "", "resolveFunctionalInterface", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "tryDeserializeIrSymbol", "deserializedSymbolNotFound", "", "declareIrSymbol", "symbol", "init", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "strategyResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategyResolver", "()Lkotlin/jvm/functions/Function1;", "addModuleReachableTopLevel", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "fileDeserializers", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "postProcess", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,262:1\n1187#2,2:263\n1261#2,4:265\n626#2,12:276\n808#2,11:288\n626#2,12:299\n1#3:269\n158#4,6:270\n*S KotlinDebug\n*F\n+ 1 IrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerWithBuiltIns\n*L\n121#1:263,2\n121#1:265,4\n178#1:276,12\n187#1:288,11\n187#1:299,12\n146#1:270,6\n*E\n"})
public final class IrModuleDeserializerWithBuiltIns
extends IrModuleDeserializer {
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final IrModuleDeserializer delegate;
    @NotNull
    private final Map<IdSignature, IrSymbol> irBuiltInsMap;

    /*
     * WARNING - void declaration
     */
    public IrModuleDeserializerWithBuiltIns(@NotNull IrBuiltIns builtIns, @NotNull IrModuleDeserializer delegate) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        super(delegate.getModuleDescriptor(), delegate.getLibraryAbiVersion());
        this.builtIns = builtIns;
        this.delegate = delegate;
        Iterable iterable = DeclarationTableKt.getKnownBuiltins(this.builtIns);
        IrModuleDeserializerWithBuiltIns irModuleDeserializerWithBuiltIns = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            IrSymbol symbol = ((IrSymbolOwner)it).getSymbol();
            Pair<IdSignature, IrSymbol> pair = TuplesKt.to(symbol.getSignature(), symbol);
            map.put(pair.getFirst(), pair.getSecond());
        }
        irModuleDeserializerWithBuiltIns.irBuiltInsMap = destination$iv$iv;
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        IdSignature topLevel = idSig.topLevelSignature();
        if (this.irBuiltInsMap.containsKey(topLevel)) {
            return true;
        }
        return FunctionalInterfacesUtilsKt.checkIsFunctionInterface(topLevel) || this.delegate.contains(idSig);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        return this.delegate.referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        return this.delegate.referencePropertyByLocalSignature(file2, idSignature);
    }

    @Override
    public void deserializeReachableDeclarations() {
        this.delegate.deserializeReachableDeclarations();
    }

    private final IrClass computeFunctionClass(String className) {
        int n;
        String string2;
        boolean isSuspend;
        boolean isK;
        block1: {
            isK = className.charAt(0) == 'K';
            isSuspend = (isK ? className.charAt(1) : className.charAt(0)) == 'S';
            String $this$computeFunctionClass_u24lambda_u242 = className;
            boolean bl = false;
            string2 = $this$computeFunctionClass_u24lambda_u242;
            CharSequence $this$indexOfFirst$iv = $this$computeFunctionClass_u24lambda_u242;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl2 = false;
                if (!Character.isDigit(it)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int n3 = n;
        String string3 = string2.substring(n3);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        string2 = string3;
        n3 = 10;
        int arity = Integer.parseInt(string2, CharsKt.checkRadix(n3));
        IrBuiltIns $this$computeFunctionClass_u24lambda_u243 = this.builtIns;
        boolean bl = false;
        return isK && isSuspend ? $this$computeFunctionClass_u24lambda_u243.kSuspendFunctionN(arity) : (isK ? $this$computeFunctionClass_u24lambda_u243.kFunctionN(arity) : (isSuspend ? $this$computeFunctionClass_u24lambda_u243.suspendFunctionN(arity) : $this$computeFunctionClass_u24lambda_u243.functionN(arity)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrSymbol resolveFunctionalInterface(IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
        IrSymbol irSymbol2;
        if (symbolKind == BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL) {
            Intrinsics.checkNotNull(idSig, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.CompositeSignature");
            IdSignature.CompositeSignature composite = (IdSignature.CompositeSignature)idSig;
            IdSignature classSignature = ((IdSignature.CompositeSignature)idSig).getContainer();
            IrSymbol irSymbol3 = this.resolveFunctionalInterface(classSignature, BinarySymbolData.SymbolKind.CLASS_SYMBOL);
            Intrinsics.checkNotNull(irSymbol3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol classSymbol = (IrClassSymbol)irSymbol3;
            IdSignature idSignature = composite.getInner();
            Intrinsics.checkNotNull(idSignature, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.LocalSignature");
            IdSignature.LocalSignature typeParameterSig = (IdSignature.LocalSignature)idSignature;
            int typeParameterIndex = typeParameterSig.index();
            IrTypeParameter typeParameter = ((IrClass)classSymbol.getOwner()).getTypeParameters().get(typeParameterIndex);
            return typeParameter.getSymbol();
        }
        IdSignature.CommonSignature commonSignature = idSig.asPublic();
        if (commonSignature == null) {
            throw new IllegalStateException((idSig + " has to be public").toString());
        }
        IdSignature.CommonSignature publicSig = commonSignature;
        List<String> fqnParts = publicSig.getNameSegments();
        String string2 = CollectionsKt.firstOrNull(fqnParts);
        if (string2 == null) {
            throw new IllegalStateException(("Expected class name for " + idSig).toString());
        }
        String className = string2;
        IrClass functionClass = this.computeFunctionClass(className);
        switch (fqnParts.size()) {
            case 1: {
                boolean bl;
                IrClassSymbol typeParameter;
                IrClassSymbol it = typeParameter = functionClass.getSymbol();
                boolean bl2 = false;
                boolean bl3 = bl = symbolKind == BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                irSymbol2 = typeParameter;
                break;
            }
            case 2: {
                String memberName = fqnParts.get(1);
                Iterable $this$single$iv2 = functionClass.getDeclarations();
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv2) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrDeclarationWithName && Intrinsics.areEqual(((IrDeclarationWithName)it).getName().asString(), memberName))) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IrDeclaration it = single$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                irSymbol2 = ((IrSymbolOwner)it).getSymbol();
                break;
            }
            case 3: {
                void $this$single$iv;
                void $this$filterIsInstanceTo$iv$iv;
                boolean memberName = idSig instanceof IdSignature.AccessorSignature;
                if (_Assertions.ENABLED && !memberName) {
                    String $this$single$iv2 = "Assertion failed";
                    throw new AssertionError((Object)$this$single$iv2);
                }
                boolean bl = memberName = symbolKind == BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                if (_Assertions.ENABLED && !memberName) {
                    String $this$single$iv2 = "Assertion failed";
                    throw new AssertionError((Object)$this$single$iv2);
                }
                String propertyName = fqnParts.get(1);
                String accessorName = fqnParts.get(2);
                Iterable $this$filterIsInstance$iv = functionClass.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable found$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv2 = false;
                for (Object element$iv : $this$single$iv) {
                    IrProperty it = (IrProperty)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), propertyName)) continue;
                    if (found$iv2) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv2 = true;
                }
                if (!found$iv2) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IrProperty p = single$iv;
                boolean bl5 = false;
                IrSimpleFunction irSimpleFunction = p.getGetter();
                if (irSimpleFunction != null) {
                    IrSimpleFunction g = irSimpleFunction;
                    boolean bl6 = false;
                    if (Intrinsics.areEqual(g.getName().asString(), accessorName)) {
                        return g.getSymbol();
                    }
                }
                IrSimpleFunction irSimpleFunction2 = p.getSetter();
                if (irSimpleFunction2 != null) {
                    IrSimpleFunction s = irSimpleFunction2;
                    boolean bl7 = false;
                    if (Intrinsics.areEqual(s.getName().asString(), accessorName)) {
                        return s.getSymbol();
                    }
                }
                throw new IllegalStateException(("No accessor found for signature " + idSig).toString());
            }
            default: {
                throw new IllegalStateException(("No member found for signature " + idSig).toString());
            }
        }
        return irSymbol2;
    }

    @Override
    @Nullable
    public IrSymbol tryDeserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        IrSymbol irSymbol2 = this.irBuiltInsMap.get(idSig);
        if (irSymbol2 != null) {
            IrSymbol it = irSymbol2;
            boolean bl = false;
            return it;
        }
        IdSignature topLevel = idSig.topLevelSignature();
        if (FunctionalInterfacesUtilsKt.checkIsFunctionInterface(topLevel)) {
            return this.resolveFunctionalInterface(idSig, symbolKind);
        }
        return this.delegate.tryDeserializeIrSymbol(idSig, symbolKind);
    }

    @Override
    @NotNull
    public Void deserializedSymbolNotFound(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        this.delegate.deserializedSymbolNotFound(idSig);
        throw null;
    }

    @Override
    public void declareIrSymbol(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        IdSignature signature = symbol.getSignature();
        if (signature != null && FunctionalInterfacesUtilsKt.checkIsFunctionInterface(signature)) {
            this.resolveFunctionalInterface(signature, IrModuleDeserializerKt.kind(symbol));
        } else {
            this.delegate.declareIrSymbol(symbol);
        }
    }

    @Override
    public void init() {
        this.delegate.init(this);
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.delegate.getKlib();
    }

    @Override
    @NotNull
    public Function1<String, DeserializationStrategy> getStrategyResolver() {
        return this.delegate.getStrategyResolver();
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        this.delegate.addModuleReachableTopLevel(idSig);
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.delegate.getModuleFragment();
    }

    @Override
    @NotNull
    public Collection<IrModuleDeserializer> getModuleDependencies() {
        return this.delegate.getModuleDependencies();
    }

    @Override
    @NotNull
    public IrModuleDeserializerKind getKind() {
        return this.delegate.getKind();
    }

    @Override
    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        return this.delegate.fileDeserializers();
    }

    @Override
    public void postProcess() {
        this.delegate.postProcess();
    }

    @Override
    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return this.delegate.signatureDeserializerForFile(fileName);
    }
}

