/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileContentImpl
extends IndexedFileImpl
implements PsiDependentFileContent {
    @NotNull
    private final NotNullComputable<byte[]> myContentComputable;
    private Charset myCharset;
    private byte[] myCachedContentBytes;
    private CharSequence myContentAsText;
    private byte[] myIndexedFileHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private final boolean myTransientContent;
    private static final Key<PsiFile> CACHED_PSI = Key.create("cached psi from content");
    private static final Key<LighterAST> LIGHTER_AST_NODE_KEY = Key.create("lighter.ast.node");

    private FileContentImpl(@NotNull VirtualFile file2, @NotNull FileType fileType, @Nullable CharSequence contentAsText, @NotNull NotNullComputable<byte[]> contentComputable, boolean transientContent) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(1);
        }
        if (contentComputable == null) {
            FileContentImpl.$$$reportNull$$$0(2);
        }
        super(file2, fileType, null);
        this.myContentAsText = contentAsText;
        this.myContentComputable = contentComputable;
        this.myTransientContent = transientContent;
    }

    @Override
    @NotNull
    public LighterAST getLighterAST() {
        LighterAST lighterAST = this.getUserData(LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFile().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(LIGHTER_AST_NODE_KEY, lighterAST);
        }
        LighterAST lighterAST2 = lighterAST;
        if (lighterAST2 == null) {
            FileContentImpl.$$$reportNull$$$0(3);
        }
        return lighterAST2;
    }

    private PsiFile createFileFromText(@NotNull CharSequence text) {
        if (text == null) {
            FileContentImpl.$$$reportNull$$$0(4);
        }
        Project project = this.getProject();
        FileType fileType = FileContentImpl.getFileTypeWithoutSubstitution(this);
        if (!(fileType instanceof LanguageFileType)) {
            throw new AssertionError((Object)("PSI can be created only for a file with LanguageFileType but actual is " + fileType.getClass() + ".\nPlease use a proper FileBasedIndexExtension#getInputFilter() implementation for the caller index"));
        }
        return FileContentImpl.createFileFromText(project, text, (LanguageFileType)fileType, this.myFile, this.getFileName());
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text, @NotNull LanguageFileType fileType, @NotNull VirtualFile file2, @NotNull String fileName) {
        if (project == null) {
            FileContentImpl.$$$reportNull$$$0(5);
        }
        if (text == null) {
            FileContentImpl.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            FileContentImpl.$$$reportNull$$$0(9);
        }
        Language language2 = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.getInstance().substituteLanguage(language2, file2, project);
        PsiFile psiFile = PsiFileFactory.getInstance(project).createFileFromText(fileName, substitutedLanguage, text, false, false, false, file2);
        if (psiFile == null) {
            throw new IllegalStateException("psiFile is null. language = " + language2.getID() + ", substitutedLanguage = " + substitutedLanguage.getID());
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            FileContentImpl.$$$reportNull$$$0(10);
        }
        return psiFile2;
    }

    @NotNull
    public static FileContent createByContent(@NotNull VirtualFile file2, byte @NotNull [] content) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(11);
        }
        if (content == null) {
            FileContentImpl.$$$reportNull$$$0(12);
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(file2, content);
        return new FileContentImpl(file2, fileType, null, () -> content, false);
    }

    @NotNull
    public static FileContent createByFile(@NotNull VirtualFile file2, @Nullable Project project) throws IOException {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(19);
        }
        FileContentImpl content = (FileContentImpl)FileContentImpl.createByContent(file2, file2.contentsToByteArray(false));
        if (project != null) {
            content.setProject(project);
        }
        FileContentImpl fileContentImpl = content;
        if (fileContentImpl == null) {
            FileContentImpl.$$$reportNull$$$0(20);
        }
        return fileContentImpl;
    }

    @NotNull
    public static FileContent createByText(@NotNull VirtualFile file2, @NotNull CharSequence contentAsText, @Nullable Project project) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(21);
        }
        if (contentAsText == null) {
            FileContentImpl.$$$reportNull$$$0(22);
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(file2);
        FileContentImpl content = new FileContentImpl(file2, fileType, contentAsText, () -> {
            throw new IllegalStateException("Content must be converted from 'contentAsText'");
        }, true);
        if (project != null) {
            content.setProject(project);
        }
        FileContentImpl fileContentImpl = content;
        if (fileContentImpl == null) {
            FileContentImpl.$$$reportNull$$$0(23);
        }
        return fileContentImpl;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            this.myCharset = charset = this.myFile.getCharset();
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            FileContentImpl.$$$reportNull$$$0(24);
        }
        return charset2;
    }

    @Override
    public byte @NotNull [] getContent() {
        if (this.myCachedContentBytes == null) {
            FileType unsubstitutedFileType = FileContentImpl.getFileTypeWithoutSubstitution(this);
            this.myCachedContentBytes = unsubstitutedFileType.isBinary() ? this.computeOriginalContent() : this.getContentAsText().toString().getBytes(this.getCharset());
        }
        if (this.myCachedContentBytes == null) {
            FileContentImpl.$$$reportNull$$$0(25);
        }
        return this.myCachedContentBytes;
    }

    @Override
    @NotNull
    public CharSequence getContentAsText() {
        FileType unsubstitutedFileType = FileContentImpl.getFileTypeWithoutSubstitution(this);
        if (unsubstitutedFileType.isBinary()) {
            throw new UnsupportedOperationException("Cannot obtain text for binary file type : " + unsubstitutedFileType.getDescription());
        }
        CharSequence content = this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            CharSequence charSequence = content;
            if (charSequence == null) {
                FileContentImpl.$$$reportNull$$$0(26);
            }
            return charSequence;
        }
        if (this.myContentAsText == null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.computeOriginalContent(), this.myFile, false, false);
        }
        CharSequence charSequence = this.myContentAsText;
        if (charSequence == null) {
            FileContentImpl.$$$reportNull$$$0(27);
        }
        return charSequence;
    }

    private byte @NotNull [] computeOriginalContent() {
        byte[] byArray = this.myContentComputable.compute();
        if (byArray == null) {
            FileContentImpl.$$$reportNull$$$0(28);
        }
        return byArray;
    }

    @Override
    public String toString() {
        return "FileContentImpl(" + this.getFileName() + ")";
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (this.myTransientContent && (document = FileDocumentManager.getInstance().getCachedDocument(this.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance(this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            return this.checkPsiProjectConsistency(existingPsi);
        }
        PsiFile explicitPsi = this.getUserData(IndexingDataKeys.PSI_FILE);
        if (explicitPsi != null) {
            return this.checkPsiProjectConsistency(explicitPsi);
        }
        PsiFile cachedPsi = this.getUserData(CACHED_PSI);
        if (cachedPsi != null) {
            return this.checkPsiProjectConsistency(cachedPsi);
        }
        PsiFile createdPsi = this.createFileFromText(this.getContentAsText());
        createdPsi.putUserData(IndexingDataKeys.VIRTUAL_FILE, this.getFile());
        this.putUserData(CACHED_PSI, createdPsi);
        return this.checkPsiProjectConsistency(createdPsi);
    }

    @NotNull
    private PsiFile checkPsiProjectConsistency(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(30);
        }
        if (!file2.getProject().equals(this.getProject())) {
            Logger.getInstance(FileContentImpl.class).error("psi file's project is not equal to file content's project");
        }
        PsiFile psiFile = file2;
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(31);
        }
        return psiFile;
    }

    @ApiStatus.Internal
    @NotNull
    public static FileType getFileTypeWithoutSubstitution(@NotNull IndexedFile indexedFile) {
        FileType fileType;
        if (indexedFile == null) {
            FileContentImpl.$$$reportNull$$$0(32);
        }
        FileType fileType2 = (fileType = indexedFile.getFileType()) instanceof SubstitutedFileType ? ((SubstitutedFileType)fileType).getOriginalFileType() : fileType;
        if (fileType2 == null) {
            FileContentImpl.$$$reportNull$$$0(33);
        }
        return fileType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComputable";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAsText";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentHash";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLighterAST";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createByContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createByFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createByText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentAsText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOriginalContent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPsiProjectConsistency";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeWithoutSubstitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createByContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createByFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createByText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedFileHash";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiProjectConsistency";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeWithoutSubstitution";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

