/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "containingClassOrFile", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirLateinitIntrinsicApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,81:1\n33#2:82\n2632#3,3:83\n43#4:86\n*S KotlinDebug\n*F\n+ 1 FirLateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker\n*L\n48#1:82\n55#1:83,3\n66#1:86\n*E\n"})
public final class FirLateinitIntrinsicApplicabilityChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirLateinitIntrinsicApplicabilityChecker INSTANCE = new FirLateinitIntrinsicApplicabilityChecker();

    private FirLateinitIntrinsicApplicabilityChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        FirPropertySymbol calleePropertySymbol;
        KtSourceElement source;
        block13: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol resolvedSymbol = firPropertySymbol;
            if (!Intrinsics.areEqual(resolvedSymbol.getName().getIdentifierOrNullIfSpecial(), "isInitialized")) {
                return;
            }
            FirReceiverParameter firReceiverParameter = resolvedSymbol.getReceiverParameter();
            if (firReceiverParameter == null) {
                return;
            }
            FirReceiverParameter receiverParameter = firReceiverParameter;
            if (!FirAnnotationUtilsKt.hasAnnotation(receiverParameter, StandardClassIds.Annotations.INSTANCE.getAccessibleLateinitPropertyLiteral(), context.getSession())) {
                return;
            }
            source = expression2.getCalleeReference().getSource();
            FirExpression extensionReceiver = expression2.getExtensionReceiver();
            if (!(extensionReceiver instanceof FirCallableReferenceAccess)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LITERAL(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            FirPropertySymbol firPropertySymbol2 = FirReferenceUtilsKt.toResolvedPropertySymbol$default(((FirCallableReferenceAccess)extensionReceiver).getCalleeReference(), false, 1, null);
            if (firPropertySymbol2 == null) {
                return;
            }
            calleePropertySymbol = firPropertySymbol2;
            FirCallableSymbol $this$isLateInit$iv = calleePropertySymbol;
            boolean $i$f$isLateInit = false;
            if (!$this$isLateInit$iv.getRawStatus().isLateInit()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT(), (DiagnosticContext)context, null, 8, null);
                return;
            }
            FirBasedSymbol<?> containingSymbol = this.containingClassOrFile(calleePropertySymbol, context);
            Iterable $this$none$iv = context.getContainingDeclarations();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getSymbol(), containingSymbol)) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY(), (Object)calleePropertySymbol, (DiagnosticContext)context, null, 16, null);
            return;
        }
        FirDeclaration closestOwnFunction = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        if (closestOwnFunction instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)closestOwnFunction;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final FirBasedSymbol<?> containingClassOrFile(FirPropertySymbol $this$containingClassOrFile, CheckerContext context) {
        FirBasedSymbol firBasedSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$containingClassOrFile, context.getSession());
        if (firClassLikeSymbol != null) {
            firBasedSymbol = firClassLikeSymbol;
        } else {
            FirFile firFile = FirProviderKt.getFirProvider(context.getSession()).getFirCallableContainerFile($this$containingClassOrFile);
            firBasedSymbol = firFile != null ? firFile.getSymbol() : null;
        }
        return firBasedSymbol;
    }
}

