/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.serialization;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.AssociatedObject;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BuiltinIdSignatures;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassAssociatedObjects;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataCharArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataCharField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntegerArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataStruct;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FieldInitializer;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmElement;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExnRefType;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmFuncRef;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI31Ref;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithLocation;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithoutLocation;
import org.jetbrains.kotlin.wasm.ir.WasmLimits;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmMemory;
import org.jetbrains.kotlin.wasm.ir.WasmNamedModuleField;
import org.jetbrains.kotlin.wasm.ir.WasmNullExnRefType;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullExternrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructRef;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmTag;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;
import org.jetbrains.kotlin.wasm.ir.WasmV128;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteWriter;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0002\u00ea\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00152\u0006\u00104\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\u00152\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u00152\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020\u00152\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u00152\u0006\u0010N\u001a\u00020OH\u0002J\u0014\u0010P\u001a\u00020\u00152\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030RH\u0002J\u0010\u0010S\u001a\u00020\u00152\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020\u00152\u0006\u0010W\u001a\u00020XH\u0002JP\u0010Y\u001a\u00020\u0015\"\u0004\b\u0000\u0010Z\"\u0004\b\u0001\u0010[2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u0002HZ\u0012\u0004\u0012\u0002H[0]2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u0002HZ\u0012\u0004\u0012\u00020\u00150_2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u0002H[\u0012\u0004\u0012\u00020\u00150_H\u0002J0\u0010a\u001a\u00020\u0015\"\u0004\b\u0000\u0010b2\f\u0010c\u001a\b\u0012\u0004\u0012\u0002Hb0d2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u0002Hb\u0012\u0004\u0012\u00020\u00150_H\u0002J0\u0010f\u001a\u00020\u0015\"\u0004\b\u0000\u0010b2\f\u0010g\u001a\b\u0012\u0004\u0012\u0002Hb0h2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u0002Hb\u0012\u0004\u0012\u00020\u00150_H\u0002JP\u0010i\u001a\u00020\u0015\"\u0004\b\u0000\u0010j\"\u0004\b\u0001\u0010k2\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u0002Hj\u0012\u0004\u0012\u0002Hk0m2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u0002Hj\u0012\u0004\u0012\u00020\u00150_2\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u0002Hk\u0012\u0004\u0012\u00020\u00150_H\u0002J\u0010\u0010p\u001a\u00020\u00152\u0006\u0010q\u001a\u00020rH\u0002J1\u0010s\u001a\u00020\u0015\"\u0004\b\u0000\u0010b2\b\u0010H\u001a\u0004\u0018\u0001Hb2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u0002Hb\u0012\u0004\u0012\u00020\u00150_H\u0002\u00a2\u0006\u0002\u0010tJ\u0010\u0010u\u001a\u00020\u00152\u0006\u0010v\u001a\u00020wH\u0002J\u0010\u0010x\u001a\u00020\u00152\u0006\u0010y\u001a\u00020zH\u0002J\u0010\u0010{\u001a\u00020\u00152\u0006\u0010|\u001a\u00020}H\u0002J\u0011\u0010~\u001a\u00020\u00152\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\u0013\u0010\u0081\u0001\u001a\u00020\u00152\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u0012\u0010\u0084\u0001\u001a\u00020\u00152\u0007\u00109\u001a\u00030\u0085\u0001H\u0002J\u0013\u0010\u0086\u0001\u001a\u00020\u00152\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0013\u0010\u0089\u0001\u001a\u00020\u00152\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0002J\u0013\u0010\u008c\u0001\u001a\u00020\u00152\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0002J\u0013\u0010\u008f\u0001\u001a\u00020\u00152\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0002J\u0013\u0010\u0092\u0001\u001a\u00020\u00152\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0002J\u0013\u0010\u0095\u0001\u001a\u00020\u00152\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0002J\u0013\u0010\u0098\u0001\u001a\u00020\u00152\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0002J\u0013\u0010\u009b\u0001\u001a\u00020\u00152\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0002J\u0013\u0010\u009e\u0001\u001a\u00020\u00152\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0002J\u0013\u0010\u00a1\u0001\u001a\u00020\u00152\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001H\u0002J\u0013\u0010\u00a4\u0001\u001a\u00020\u00152\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u0013\u0010\u00a7\u0001\u001a\u00020\u00152\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u0001H\u0002J\u0013\u0010\u00aa\u0001\u001a\u00020\u00152\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001H\u0002J\u0013\u0010\u00ad\u0001\u001a\u00020\u00152\b\u0010\u00ae\u0001\u001a\u00030\u00af\u0001H\u0002J\u0013\u0010\u00b0\u0001\u001a\u00020\u00152\b\u0010\u00b1\u0001\u001a\u00030\u00b2\u0001H\u0002J_\u0010\u00b3\u0001\u001a\u00020\u0015\"\u0005\b\u0000\u0010\u00b4\u0001\"\t\b\u0001\u0010\u00b5\u0001*\u00020\u00012\u0016\u0010\u00b6\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u00b4\u0001\u0012\u0005\u0012\u0003H\u00b5\u00010\u00b7\u00012\u0014\u0010\u00b8\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u00b4\u0001\u0012\u0004\u0012\u00020\u00150_2\u0014\u0010\u00b9\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u00b5\u0001\u0012\u0004\u0012\u00020\u00150_H\u0002J_\u0010\u00ba\u0001\u001a\u00020\u0015\"\u0005\b\u0000\u0010\u00b4\u0001\"\t\b\u0001\u0010\u00b5\u0001*\u00020\u00012\u0016\u0010\u00bb\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u00b4\u0001\u0012\u0005\u0012\u0003H\u00b5\u00010\u00bc\u00012\u0014\u0010\u00b8\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u00b4\u0001\u0012\u0004\u0012\u00020\u00150_2\u0014\u0010\u00b9\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u00b5\u0001\u0012\u0004\u0012\u00020\u00150_H\u0002J7\u0010\u00bd\u0001\u001a\u00020\u0015\"\b\b\u0000\u0010b*\u00020\u00012\u000e\u0010\u00be\u0001\u001a\t\u0012\u0004\u0012\u0002Hb0\u00bf\u00012\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u0002Hb\u0012\u0004\u0012\u00020\u00150_H\u0002J\u0011\u0010\u00c0\u0001\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0013\u0010\u00c1\u0001\u001a\u00020\u00152\b\u0010\u00c2\u0001\u001a\u00030\u00c3\u0001H\u0002J\u0013\u0010\u00c4\u0001\u001a\u00020\u00152\b\u0010\u00c5\u0001\u001a\u00030\u00c6\u0001H\u0002J\u0013\u0010\u00c7\u0001\u001a\u00020\u00152\b\u0010\u00c8\u0001\u001a\u00030\u00c9\u0001H\u0002J\u0013\u0010\u00ca\u0001\u001a\u00020\u00152\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0002J\u0013\u0010\u00cd\u0001\u001a\u00020\u00152\b\u0010\u00ce\u0001\u001a\u00030\u00cf\u0001H\u0002J4\u0010\u00d0\u0001\u001a\u00020\u00152\b\u0010\u00ce\u0001\u001a\u00030\u00d1\u00012\u0010\b\u0002\u0010\u00d2\u0001\u001a\t\u0012\u0005\u0012\u00030\u00d3\u00010d2\r\u0010e\u001a\t\u0012\u0004\u0012\u00020\u00150\u00d4\u0001H\u0002J5\u0010\u00d5\u0001\u001a\u00020\u00152\u0007\u0010.\u001a\u00030\u00d6\u00012\t\u0010\u00ce\u0001\u001a\u0004\u0018\u00010\u00012\r\u0010e\u001a\t\u0012\u0004\u0012\u00020\u00150\u00d4\u0001H\u0002\u00a2\u0006\u0006\b\u00d7\u0001\u0010\u00d8\u0001J\u001b\u0010\u00d9\u0001\u001a\u00020\u00152\u0007\u0010.\u001a\u00030\u00d6\u0001H\u0002\u00a2\u0006\u0006\b\u00da\u0001\u0010\u00db\u0001J*\u0010\u00dc\u0001\u001a\u00020\u00152\u0007\u0010.\u001a\u00030\u00d6\u00012\r\u0010e\u001a\t\u0012\u0004\u0012\u00020\u00150\u00d4\u0001H\u0002\u00a2\u0006\u0006\b\u00dd\u0001\u0010\u00de\u0001J'\u0010\u00df\u0001\u001a\u00020\u00152\r\u0010\u00d2\u0001\u001a\u00030\u00e0\u0001\"\u00030\u00d3\u00012\r\u0010e\u001a\t\u0012\u0004\u0012\u00020\u00150\u00d4\u0001H\u0002J!\u0010\u00e1\u0001\u001a\u00020\u00152\u0007\u0010\u00ce\u0001\u001a\u00020\u00012\r\u0010e\u001a\t\u0012\u0004\u0012\u00020\u00150\u00d4\u0001H\u0002J&\u0010\u00e2\u0001\u001a\u0004\u0018\u0001Hb\"\b\b\u0000\u0010b*\u00020\u0001*\t\u0012\u0004\u0012\u0002Hb0\u00bf\u0001H\u0002\u00a2\u0006\u0003\u0010\u00e3\u0001J\u001d\u0010\u00e4\u0001\u001a\u00030\u00e5\u00012\b\u0010\u00d2\u0001\u001a\u00030\u00e0\u0001H\u0002\u00a2\u0006\u0006\b\u00e6\u0001\u0010\u00e7\u0001J\u000f\u0010\u00e8\u0001\u001a\u00030\u00e9\u0001*\u00030\u00d3\u0001H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00eb\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/serialization/WasmSerializer;", "", "outputStream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "referenceTable", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/backend/wasm/serialization/WasmSerializer$DeferredSerialization;", "newReferences", "", "bodyBuffer", "Ljava/io/ByteArrayOutputStream;", "body", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter$OutputStream;", "tempBuffer", "temp", "b", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteWriter;", "out", "serialize", "", "compiledFileFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;", "serializeWasmFunction", "func", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "serializeWasmGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "serializeWasmFunctionType", "funcType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "serializeWasmTypeDeclaration", "typeDecl", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "serializeWasmStructDeclaration", "structDecl", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "serializeWasmArrayDeclaration", "arrDecl", "Lorg/jetbrains/kotlin/wasm/ir/WasmArrayDeclaration;", "serializeWasmMemory", "memory", "Lorg/jetbrains/kotlin/wasm/ir/WasmMemory;", "serializeWasmTag", "tag", "Lorg/jetbrains/kotlin/wasm/ir/WasmTag;", "serializeWasmStructFieldDeclaration", "structFieldDecl", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructFieldDeclaration;", "serializeWasmType", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "serializeWasmHeapType", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "serializeWasmLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "serializeWasmInstr", "instr", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "serializeWasmImmediate", "i", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "serializeCatchImmediate", "catch", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch;", "serializeWasmTable", "table", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable;", "serializeWasmTableValue", "value", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable$Value;", "serializeWasmElement", "element", "Lorg/jetbrains/kotlin/wasm/ir/WasmElement;", "serializeWasmElementMode", "mode", "Lorg/jetbrains/kotlin/wasm/ir/WasmElement$Mode;", "serializeWasmExport", "export", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "serializeWasmLimits", "limit", "Lorg/jetbrains/kotlin/wasm/ir/WasmLimits;", "serializeWasmImportDescriptor", "descriptor", "Lorg/jetbrains/kotlin/wasm/ir/WasmImportDescriptor;", "serializePair", "A", "B", "pair", "Lkotlin/Pair;", "serializeAFunc", "Lkotlin/Function1;", "serializeBFunc", "serializeList", "T", "list", "", "serializeFunc", "serializeSet", "set", "", "serializeMap", "K", "V", "map", "", "serializeKeyFunc", "serializeValueFunc", "serializeSourceLocation", "sl", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "serializeNullable", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "serializeIdSignature", "idSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "serializeAccessorSignature", "accessor", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "serializeCommonSignature", "common", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "serializeCompositeSignature", "composite", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "serializeFileLocalSignature", "fileLocal", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileLocalSignature;", "serializeLocalSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$LocalSignature;", "serializeLoweredDeclarationSignature", "loweredDeclaration", "Lorg/jetbrains/kotlin/ir/util/IdSignature$LoweredDeclarationSignature;", "serializeScopeLocalDeclaration", "scopeLocal", "Lorg/jetbrains/kotlin/ir/util/IdSignature$ScopeLocalDeclaration;", "serializeSpecialFakeOverrideSignature", "specialFakeOverride", "Lorg/jetbrains/kotlin/ir/util/IdSignature$SpecialFakeOverrideSignature;", "serializeConstantDataElement", "constantDataElement", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "serializeConstantDataCharArray", "constantDataCharArray", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataCharArray;", "serializeConstantDataCharField", "constantDataCharField", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataCharField;", "serializeConstantDataIntArray", "constantDataIntArray", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntArray;", "serializeConstantDataIntField", "constantDataIntField", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntField;", "serializeConstantDataIntegerArray", "constantDataIntegerArray", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntegerArray;", "serializeConstantDataStruct", "constantDataStruct", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataStruct;", "serializeJsCodeSnippet", "jsCodeSnippet", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment$JsCodeSnippet;", "serializeByteArray", "bytes", "", "serializeString", "str", "", "serializeInt", "int", "", "serializeLong", "long", "", "serializeReferencableElements", "Ir", "Wasm", "referencableElements", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment$ReferencableElements;", "irSerializeFunc", "wasmSerializeFunc", "serializeReferencableAndDefinable", "referencableAndDefinable", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment$ReferencableAndDefinable;", "serializeWasmSymbolReadOnly", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "serializeCompiledFileFragment", "serializeBuiltinIdSignatures", "builtinIdSignatures", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BuiltinIdSignatures;", "serializeFieldInitializer", "fieldInitializer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/FieldInitializer;", "serializeClassAssociatedObjects", "classAssociatedObjects", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassAssociatedObjects;", "serializeAssociatedObject", "associatedObject", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/AssociatedObject;", "serializeJsModuleAndQualifierReference", "obj", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/JsModuleAndQualifierReference;", "serializeNamedModuleField", "Lorg/jetbrains/kotlin/wasm/ir/WasmNamedModuleField;", "flags", "", "Lkotlin/Function0;", "withTagNullable", "Lkotlin/UInt;", "withTagNullable-OzbTU-A", "(ILjava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "setTag", "setTag-WZ4Q5Ns", "(I)V", "withTag", "withTag-qim9Vi0", "(ILkotlin/jvm/functions/Function0;)V", "withFlags", "", "serializeAsReference", "getOwner", "(Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;)Ljava/lang/Object;", "flagsToUByte", "Lkotlin/UByte;", "flagsToUByte-Wa3L5BU", "([Z)B", "toByte", "", "DeferredSerialization", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmSerializer.kt\norg/jetbrains/kotlin/backend/wasm/serialization/WasmSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,746:1\n1056#2:747\n1869#2,2:748\n1869#2,2:750\n1869#2,2:752\n1869#2,2:754\n216#3,2:756\n384#4,7:758\n13607#5,3:765\n19732#5,2:769\n1#6:768\n*S KotlinDebug\n*F\n+ 1 WasmSerializer.kt\norg/jetbrains/kotlin/backend/wasm/serialization/WasmSerializer\n*L\n134#1:747\n136#1:748,2\n148#1:750,2\n397#1:752,2\n402#1:754,2\n407#1:756,2\n723#1:758,7\n739#1:765,3\n568#1:769,2\n*E\n"})
public final class WasmSerializer {
    @NotNull
    private final IdentityHashMap<Object, DeferredSerialization> referenceTable;
    @NotNull
    private final List<DeferredSerialization> newReferences;
    @NotNull
    private final ByteArrayOutputStream bodyBuffer;
    @NotNull
    private final ByteWriter.OutputStream body;
    @NotNull
    private final ByteArrayOutputStream tempBuffer;
    @NotNull
    private final ByteWriter.OutputStream temp;
    @NotNull
    private ByteWriter b;
    @NotNull
    private final ByteWriter.OutputStream out;

    public WasmSerializer(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        this.referenceTable = new IdentityHashMap();
        this.newReferences = new ArrayList();
        this.bodyBuffer = new ByteArrayOutputStream();
        this.body = new ByteWriter.OutputStream(this.bodyBuffer);
        this.tempBuffer = new ByteArrayOutputStream();
        this.temp = new ByteWriter.OutputStream(this.tempBuffer);
        this.b = this.body;
        this.out = new ByteWriter.OutputStream(outputStream);
    }

    public final void serialize(@NotNull WasmCompiledFileFragment compiledFileFragment) {
        Object it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(compiledFileFragment, "compiledFileFragment");
        this.serializeCompiledFileFragment(compiledFileFragment);
        this.b = this.temp;
        List tableElementsInBytes = new ArrayList();
        while (!((Collection)this.newReferences).isEmpty()) {
            Iterable $this$sortedBy$iv = this.newReferences;
            boolean $i$f$sortedBy = false;
            List sorted2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    DeferredSerialization it = (DeferredSerialization)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getId());
                    it = (DeferredSerialization)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getId());
                }
            });
            this.newReferences.clear();
            $this$forEach$iv = sorted2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (DeferredSerialization)element$iv;
                boolean bl = false;
                this.tempBuffer.reset();
                ((DeferredSerialization)it).getSerializeFunc().invoke();
                byte[] byArray = this.tempBuffer.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
                tableElementsInBytes.add(byArray);
            }
        }
        int size = tableElementsInBytes.size();
        this.out.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(size));
        $this$forEach$iv = tableElementsInBytes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (byte[])element$iv;
            boolean bl = false;
            int bytesCount = ((byte[])it).length;
            this.out.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(bytesCount));
            this.out.writeBytes((byte[])it);
        }
        byte[] byArray = this.bodyBuffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        this.out.writeBytes(byArray);
    }

    private final void serializeWasmFunction(WasmFunction func) {
        WasmSerializer.serializeNamedModuleField$default(this, func, null, () -> WasmSerializer.serializeWasmFunction$lambda$5(this, func), 2, null);
    }

    private final void serializeWasmGlobal(WasmGlobal global) {
        Boolean[] booleanArray = new Boolean[]{global.isMutable(), global.getImportPair() == null};
        this.serializeNamedModuleField(global, CollectionsKt.listOf(booleanArray), () -> WasmSerializer.serializeWasmGlobal$lambda$7(this, global));
    }

    private final void serializeWasmFunctionType(WasmFunctionType funcType) {
        WasmSerializer.serializeNamedModuleField$default(this, funcType, null, () -> WasmSerializer.serializeWasmFunctionType$lambda$8(this, funcType), 2, null);
    }

    private final void serializeWasmTypeDeclaration(WasmTypeDeclaration typeDecl) {
        WasmTypeDeclaration wasmTypeDeclaration = typeDecl;
        if (wasmTypeDeclaration instanceof WasmFunctionType) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmTypeDeclaration$lambda$9(this, typeDecl));
        } else if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeWasmTypeDeclaration$lambda$10(this, typeDecl));
        } else if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
            this.withTag-qim9Vi0(2, () -> WasmSerializer.serializeWasmTypeDeclaration$lambda$11(this, typeDecl));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmStructDeclaration(WasmStructDeclaration structDecl) {
        Boolean[] booleanArray = new Boolean[]{structDecl.getSuperType() == null, structDecl.isFinal()};
        this.serializeNamedModuleField(structDecl, CollectionsKt.listOf(booleanArray), () -> WasmSerializer.serializeWasmStructDeclaration$lambda$13(this, structDecl));
    }

    private final void serializeWasmArrayDeclaration(WasmArrayDeclaration arrDecl) {
        this.serializeNamedModuleField(arrDecl, CollectionsKt.listOf(arrDecl.getField().isMutable()), () -> WasmSerializer.serializeWasmArrayDeclaration$lambda$14(this, arrDecl));
    }

    private final void serializeWasmMemory(WasmMemory memory) {
        this.serializeNamedModuleField(memory, CollectionsKt.listOf(memory.getImportPair() == null), () -> WasmSerializer.serializeWasmMemory$lambda$16(this, memory));
    }

    private final void serializeWasmTag(WasmTag tag) {
        this.serializeNamedModuleField(tag, CollectionsKt.listOf(tag.getImportPair() == null), () -> WasmSerializer.serializeWasmTag$lambda$18(this, tag));
    }

    private final void serializeWasmStructFieldDeclaration(WasmStructFieldDeclaration structFieldDecl) {
        this.serializeString(structFieldDecl.getName());
        this.serializeWasmType(structFieldDecl.getType());
        this.b.writeByte(this.toByte(structFieldDecl.isMutable()));
    }

    private final void serializeWasmType(WasmType type2) {
        WasmType wasmType = type2;
        if (wasmType instanceof WasmRefType) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmType$lambda$19(this, type2));
        } else if (wasmType instanceof WasmRefNullType) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeWasmType$lambda$20(this, type2));
        } else if (Intrinsics.areEqual(wasmType, WasmAnyRef.INSTANCE)) {
            this.setTag-WZ4Q5Ns(2);
        } else if (Intrinsics.areEqual(wasmType, WasmEqRef.INSTANCE)) {
            this.setTag-WZ4Q5Ns(3);
        } else if (Intrinsics.areEqual(wasmType, WasmExnRefType.INSTANCE)) {
            this.setTag-WZ4Q5Ns(4);
        } else if (Intrinsics.areEqual(wasmType, WasmExternRef.INSTANCE)) {
            this.setTag-WZ4Q5Ns(5);
        } else if (Intrinsics.areEqual(wasmType, WasmF32.INSTANCE)) {
            this.setTag-WZ4Q5Ns(6);
        } else if (Intrinsics.areEqual(wasmType, WasmF64.INSTANCE)) {
            this.setTag-WZ4Q5Ns(7);
        } else if (Intrinsics.areEqual(wasmType, WasmFuncRef.INSTANCE)) {
            this.setTag-WZ4Q5Ns(8);
        } else if (Intrinsics.areEqual(wasmType, WasmI16.INSTANCE)) {
            this.setTag-WZ4Q5Ns(9);
        } else if (Intrinsics.areEqual(wasmType, WasmI31Ref.INSTANCE)) {
            this.setTag-WZ4Q5Ns(10);
        } else if (Intrinsics.areEqual(wasmType, WasmI32.INSTANCE)) {
            this.setTag-WZ4Q5Ns(11);
        } else if (Intrinsics.areEqual(wasmType, WasmI64.INSTANCE)) {
            this.setTag-WZ4Q5Ns(12);
        } else if (Intrinsics.areEqual(wasmType, WasmI8.INSTANCE)) {
            this.setTag-WZ4Q5Ns(13);
        } else if (Intrinsics.areEqual(wasmType, WasmNullExnRefType.INSTANCE)) {
            this.setTag-WZ4Q5Ns(14);
        } else if (Intrinsics.areEqual(wasmType, WasmRefNullExternrefType.INSTANCE)) {
            this.setTag-WZ4Q5Ns(15);
        } else if (Intrinsics.areEqual(wasmType, WasmRefNullrefType.INSTANCE)) {
            this.setTag-WZ4Q5Ns(16);
        } else if (Intrinsics.areEqual(wasmType, WasmStructRef.INSTANCE)) {
            this.setTag-WZ4Q5Ns(17);
        } else if (Intrinsics.areEqual(wasmType, WasmUnreachableType.INSTANCE)) {
            this.setTag-WZ4Q5Ns(18);
        } else if (Intrinsics.areEqual(wasmType, WasmV128.INSTANCE)) {
            this.setTag-WZ4Q5Ns(19);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmHeapType(WasmHeapType type2) {
        WasmHeapType wasmHeapType = type2;
        if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.Any.INSTANCE)) {
            this.setTag-WZ4Q5Ns(0);
        } else if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.Eq.INSTANCE)) {
            this.setTag-WZ4Q5Ns(1);
        } else if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.Extern.INSTANCE)) {
            this.setTag-WZ4Q5Ns(2);
        } else if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.Func.INSTANCE)) {
            this.setTag-WZ4Q5Ns(3);
        } else if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.NoExtern.INSTANCE)) {
            this.setTag-WZ4Q5Ns(4);
        } else if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.None.INSTANCE)) {
            this.setTag-WZ4Q5Ns(5);
        } else if (Intrinsics.areEqual(wasmHeapType, WasmHeapType.Simple.Struct.INSTANCE)) {
            this.setTag-WZ4Q5Ns(6);
        } else if (wasmHeapType instanceof WasmHeapType.Type) {
            this.withTag-qim9Vi0(7, () -> WasmSerializer.serializeWasmHeapType$lambda$22(this, type2));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmLocal(WasmLocal local) {
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(local.getId()));
        this.serializeString(local.getName());
        this.serializeWasmType(local.getType());
        this.b.writeByte(this.toByte(local.isParameter()));
    }

    private final void serializeWasmInstr(WasmInstr instr) {
        int opcode = instr.getOperator().getOpcode();
        if (opcode == 65535) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[instr.getOperator().ordinal()]) {
                case 1: {
                    n = 65535;
                    break;
                }
                case 2: {
                    n = 65534;
                    break;
                }
                case 3: {
                    n = 65533;
                    break;
                }
                case 4: {
                    n = 65532;
                    break;
                }
                case 5: {
                    n = 65531;
                    break;
                }
                case 6: {
                    n = 65530;
                    break;
                }
                case 7: {
                    n = 65529;
                    break;
                }
                case 8: {
                    n = 65528;
                    break;
                }
                case 9: {
                    n = 65527;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unknown pseudo-opcode: " + instr).toString());
                }
            }
            opcode = n;
        }
        this.b.writeUInt16-xj2QHRw(UShort.constructor-impl((short)opcode));
        WasmInstr wasmInstr = instr;
        if (wasmInstr instanceof WasmInstrWithLocation) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmInstr$lambda$23(this, instr));
        } else if (wasmInstr instanceof WasmInstrWithoutLocation) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeWasmInstr$lambda$24(this, instr));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmImmediate(WasmImmediate i) {
        WasmImmediate wasmImmediate = i;
        if (wasmImmediate instanceof WasmImmediate.BlockType.Function) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmImmediate$lambda$25(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.BlockType.Value) {
            this.withTagNullable-OzbTU-A(1, ((WasmImmediate.BlockType.Value)i).getType(), () -> WasmSerializer.serializeWasmImmediate$lambda$26(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.Catch) {
            this.withTag-qim9Vi0(2, () -> WasmSerializer.serializeWasmImmediate$lambda$27(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ConstF32) {
            this.withTag-qim9Vi0(3, () -> WasmSerializer.serializeWasmImmediate$lambda$28(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ConstF64) {
            this.withTag-qim9Vi0(4, () -> WasmSerializer.serializeWasmImmediate$lambda$29(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ConstI32) {
            this.withTag-qim9Vi0(5, () -> WasmSerializer.serializeWasmImmediate$lambda$30(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ConstI64) {
            this.withTag-qim9Vi0(6, () -> WasmSerializer.serializeWasmImmediate$lambda$31(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ConstString) {
            this.withTag-qim9Vi0(7, () -> WasmSerializer.serializeWasmImmediate$lambda$32(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ConstU8) {
            this.withTag-qim9Vi0(8, () -> WasmSerializer.serializeWasmImmediate$lambda$33(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.DataIdx) {
            this.withTag-qim9Vi0(9, () -> WasmSerializer.serializeWasmImmediate$lambda$35(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ElemIdx) {
            this.withTag-qim9Vi0(10, () -> WasmSerializer.serializeWasmImmediate$lambda$36(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.FuncIdx) {
            this.withTag-qim9Vi0(11, () -> WasmSerializer.serializeWasmImmediate$lambda$38(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.GcType) {
            this.withTag-qim9Vi0(12, () -> WasmSerializer.serializeWasmImmediate$lambda$40(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.GlobalIdx) {
            this.withTag-qim9Vi0(13, () -> WasmSerializer.serializeWasmImmediate$lambda$42(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.HeapType) {
            this.withTag-qim9Vi0(14, () -> WasmSerializer.serializeWasmImmediate$lambda$43(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdx) {
            this.withTag-qim9Vi0(15, () -> WasmSerializer.serializeWasmImmediate$lambda$44(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.LabelIdxVector) {
            this.withTag-qim9Vi0(16, () -> WasmSerializer.serializeWasmImmediate$lambda$46(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.LocalIdx) {
            this.withTag-qim9Vi0(17, () -> WasmSerializer.serializeWasmImmediate$lambda$48(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.MemArg) {
            this.withTag-qim9Vi0(18, () -> WasmSerializer.serializeWasmImmediate$lambda$49(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.MemoryIdx) {
            this.withTag-qim9Vi0(19, () -> WasmSerializer.serializeWasmImmediate$lambda$50(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.StructFieldIdx) {
            this.withTag-qim9Vi0(20, () -> WasmSerializer.serializeWasmImmediate$lambda$52(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.SymbolI32) {
            this.withTag-qim9Vi0(21, () -> WasmSerializer.serializeWasmImmediate$lambda$54(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.TableIdx) {
            this.withTag-qim9Vi0(22, () -> WasmSerializer.serializeWasmImmediate$lambda$56(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.TagIdx) {
            this.withTag-qim9Vi0(23, () -> WasmSerializer.serializeWasmImmediate$lambda$58(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.TypeIdx) {
            this.withTag-qim9Vi0(24, () -> WasmSerializer.serializeWasmImmediate$lambda$60(this, i));
        } else if (wasmImmediate instanceof WasmImmediate.ValTypeVector) {
            this.withTag-qim9Vi0(25, () -> WasmSerializer.serializeWasmImmediate$lambda$61(this, i));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeCatchImmediate(WasmImmediate.Catch catch_) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[catch_.getType().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int type2 = n;
        this.withTag-qim9Vi0(type2, () -> WasmSerializer.serializeCatchImmediate$lambda$62(this, catch_));
    }

    private final void serializeWasmTable(WasmTable table) {
        UInt max = table.getLimits().getMaxSize-0hXNFcg();
        WasmImportDescriptor ip = table.getImportPair();
        Boolean[] booleanArray = new Boolean[]{max == null, ip == null};
        this.serializeNamedModuleField(table, CollectionsKt.listOf(booleanArray), () -> WasmSerializer.serializeWasmTable$lambda$65(this, table, max, ip));
    }

    private final void serializeWasmTableValue(WasmTable.Value value2) {
        WasmTable.Value value3 = value2;
        if (value3 instanceof WasmTable.Value.Expression) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmTableValue$lambda$66(this, value2));
        } else if (value3 instanceof WasmTable.Value.Function) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeWasmTableValue$lambda$68(this, value2));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmElement(WasmElement element) {
        WasmSerializer.serializeNamedModuleField$default(this, element, null, () -> WasmSerializer.serializeWasmElement$lambda$69(this, element), 2, null);
    }

    private final void serializeWasmElementMode(WasmElement.Mode mode) {
        WasmElement.Mode mode2 = mode;
        if (mode2 instanceof WasmElement.Mode.Active) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmElementMode$lambda$70(this, mode));
        } else if (Intrinsics.areEqual(mode2, WasmElement.Mode.Declarative.INSTANCE)) {
            this.setTag-WZ4Q5Ns(1);
        } else if (Intrinsics.areEqual(mode2, WasmElement.Mode.Passive.INSTANCE)) {
            this.setTag-WZ4Q5Ns(2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmExport(WasmExport<?> export) {
        this.serializeString(export.getName());
        WasmExport<?> wasmExport = export;
        if (wasmExport instanceof WasmExport.Function) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmExport$lambda$71(this, export));
        } else if (wasmExport instanceof WasmExport.Table) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeWasmExport$lambda$72(this, export));
        } else if (wasmExport instanceof WasmExport.Memory) {
            this.withTag-qim9Vi0(2, () -> WasmSerializer.serializeWasmExport$lambda$73(this, export));
        } else if (wasmExport instanceof WasmExport.Global) {
            this.withTag-qim9Vi0(3, () -> WasmSerializer.serializeWasmExport$lambda$74(this, export));
        } else if (wasmExport instanceof WasmExport.Tag) {
            this.withTag-qim9Vi0(4, () -> WasmSerializer.serializeWasmExport$lambda$75(this, export));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeWasmLimits(WasmLimits limit) {
        boolean[] blArray = new boolean[]{limit.getMaxSize-0hXNFcg() == null};
        this.withFlags(blArray, () -> WasmSerializer.serializeWasmLimits$lambda$77(this, limit));
    }

    private final void serializeWasmImportDescriptor(WasmImportDescriptor descriptor) {
        this.serializeString(descriptor.getModuleName());
        this.serializeWasmSymbolReadOnly(descriptor.getDeclarationName(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final <A, B> void serializePair(Pair<? extends A, ? extends B> pair, Function1<? super A, Unit> serializeAFunc, Function1<? super B, Unit> serializeBFunc) {
        serializeAFunc.invoke(pair.getFirst());
        serializeBFunc.invoke(pair.getSecond());
    }

    private final <T> void serializeList(List<? extends T> list, Function1<? super T, Unit> serializeFunc) {
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(list.size()));
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            serializeFunc.invoke(it);
        }
    }

    private final <T> void serializeSet(Set<? extends T> set, Function1<? super T, Unit> serializeFunc) {
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(set.size()));
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            serializeFunc.invoke(it);
        }
    }

    private final <K, V> void serializeMap(Map<K, ? extends V> map, Function1<? super K, Unit> serializeKeyFunc, Function1<? super V, Unit> serializeValueFunc) {
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(map.size()));
        Map<K, V> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<K, V> element$iv;
            Map.Entry<K, V> entry = element$iv = iterator2.next();
            boolean bl = false;
            K key = entry.getKey();
            V value2 = entry.getValue();
            serializeKeyFunc.invoke(key);
            serializeValueFunc.invoke(value2);
        }
    }

    private final void serializeSourceLocation(SourceLocation sl) {
        SourceLocation sourceLocation = sl;
        if (Intrinsics.areEqual(sourceLocation, SourceLocation.NoLocation.INSTANCE)) {
            this.setTag-WZ4Q5Ns(0);
        } else if (Intrinsics.areEqual(sourceLocation, SourceLocation.IgnoredLocation.INSTANCE)) {
            this.setTag-WZ4Q5Ns(2);
        } else if (Intrinsics.areEqual(sourceLocation, SourceLocation.NextLocation.INSTANCE)) {
            this.setTag-WZ4Q5Ns(3);
        } else if (sourceLocation instanceof SourceLocation.DefinedLocation) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeSourceLocation$lambda$81(this, sl));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final <T> void serializeNullable(T value2, Function1<? super T, Unit> serializeFunc) {
        if (value2 != null) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeNullable$lambda$82(serializeFunc, value2));
        } else {
            this.setTag-WZ4Q5Ns(0);
        }
    }

    private final void serializeIdSignature(IdSignature idSignature) {
        IdSignature idSignature2 = idSignature;
        if (idSignature2 instanceof IdSignature.AccessorSignature) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeIdSignature$lambda$83(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.CommonSignature) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeIdSignature$lambda$84(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.CompositeSignature) {
            this.withTag-qim9Vi0(2, () -> WasmSerializer.serializeIdSignature$lambda$85(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.FileLocalSignature) {
            this.withTag-qim9Vi0(3, () -> WasmSerializer.serializeIdSignature$lambda$86(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.LocalSignature) {
            this.withTag-qim9Vi0(4, () -> WasmSerializer.serializeIdSignature$lambda$87(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.LoweredDeclarationSignature) {
            this.withTag-qim9Vi0(5, () -> WasmSerializer.serializeIdSignature$lambda$88(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.ScopeLocalDeclaration) {
            this.withTag-qim9Vi0(6, () -> WasmSerializer.serializeIdSignature$lambda$89(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.SpecialFakeOverrideSignature) {
            this.withTag-qim9Vi0(7, () -> WasmSerializer.serializeIdSignature$lambda$90(this, idSignature));
        } else if (idSignature2 instanceof IdSignature.FileSignature) {
            this.withTag-qim9Vi0(8, () -> WasmSerializer.serializeIdSignature$lambda$91(this, idSignature));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeAccessorSignature(IdSignature.AccessorSignature accessor) {
        IdSignature.AccessorSignature $this$serializeAccessorSignature_u24lambda_u2492 = accessor;
        boolean bl = false;
        this.serializeIdSignature($this$serializeAccessorSignature_u24lambda_u2492.getPropertySignature());
        this.serializeCommonSignature($this$serializeAccessorSignature_u24lambda_u2492.getAccessorSignature());
    }

    private final void serializeCommonSignature(IdSignature.CommonSignature common) {
        IdSignature.CommonSignature $this$serializeCommonSignature_u24lambda_u2496 = common;
        boolean bl = false;
        boolean[] blArray = new boolean[]{$this$serializeCommonSignature_u24lambda_u2496.getId() == null, $this$serializeCommonSignature_u24lambda_u2496.getDescription() == null};
        this.withFlags(blArray, () -> WasmSerializer.serializeCommonSignature$lambda$96$lambda$95(this, $this$serializeCommonSignature_u24lambda_u2496));
    }

    private final void serializeCompositeSignature(IdSignature.CompositeSignature composite) {
        IdSignature.CompositeSignature $this$serializeCompositeSignature_u24lambda_u2497 = composite;
        boolean bl = false;
        this.serializeIdSignature($this$serializeCompositeSignature_u24lambda_u2497.getContainer());
        this.serializeIdSignature($this$serializeCompositeSignature_u24lambda_u2497.getInner());
    }

    private final void serializeFileLocalSignature(IdSignature.FileLocalSignature fileLocal) {
        IdSignature.FileLocalSignature $this$serializeFileLocalSignature_u24lambda_u24100 = fileLocal;
        boolean bl = false;
        boolean[] blArray = new boolean[]{$this$serializeFileLocalSignature_u24lambda_u24100.getDescription() == null};
        this.withFlags(blArray, () -> WasmSerializer.serializeFileLocalSignature$lambda$100$lambda$99(this, $this$serializeFileLocalSignature_u24lambda_u24100));
    }

    private final void serializeLocalSignature(IdSignature.LocalSignature local) {
        IdSignature.LocalSignature $this$serializeLocalSignature_u24lambda_u24104 = local;
        boolean bl = false;
        boolean[] blArray = new boolean[]{$this$serializeLocalSignature_u24lambda_u24104.getHashSig() == null, $this$serializeLocalSignature_u24lambda_u24104.getDescription() == null};
        this.withFlags(blArray, () -> WasmSerializer.serializeLocalSignature$lambda$104$lambda$103(this, $this$serializeLocalSignature_u24lambda_u24104));
    }

    private final void serializeLoweredDeclarationSignature(IdSignature.LoweredDeclarationSignature loweredDeclaration) {
        IdSignature.LoweredDeclarationSignature $this$serializeLoweredDeclarationSignature_u24lambda_u24105 = loweredDeclaration;
        boolean bl = false;
        this.serializeIdSignature($this$serializeLoweredDeclarationSignature_u24lambda_u24105.getOriginal());
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl($this$serializeLoweredDeclarationSignature_u24lambda_u24105.getStage()));
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl($this$serializeLoweredDeclarationSignature_u24lambda_u24105.getIndex()));
    }

    private final void serializeScopeLocalDeclaration(IdSignature.ScopeLocalDeclaration scopeLocal) {
        IdSignature.ScopeLocalDeclaration $this$serializeScopeLocalDeclaration_u24lambda_u24108 = scopeLocal;
        boolean bl = false;
        boolean[] blArray = new boolean[]{$this$serializeScopeLocalDeclaration_u24lambda_u24108.getDescription() == null};
        this.withFlags(blArray, () -> WasmSerializer.serializeScopeLocalDeclaration$lambda$108$lambda$107(this, $this$serializeScopeLocalDeclaration_u24lambda_u24108));
    }

    private final void serializeSpecialFakeOverrideSignature(IdSignature.SpecialFakeOverrideSignature specialFakeOverride) {
        IdSignature.SpecialFakeOverrideSignature $this$serializeSpecialFakeOverrideSignature_u24lambda_u24109 = specialFakeOverride;
        boolean bl = false;
        this.serializeIdSignature($this$serializeSpecialFakeOverrideSignature_u24lambda_u24109.getMemberSignature());
        this.serializeList($this$serializeSpecialFakeOverrideSignature_u24lambda_u24109.getOverriddenSignatures(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final void serializeConstantDataElement(ConstantDataElement constantDataElement) {
        ConstantDataElement constantDataElement2 = constantDataElement;
        if (constantDataElement2 instanceof ConstantDataCharArray) {
            this.withTag-qim9Vi0(0, () -> WasmSerializer.serializeConstantDataElement$lambda$110(this, constantDataElement));
        } else if (constantDataElement2 instanceof ConstantDataCharField) {
            this.withTag-qim9Vi0(1, () -> WasmSerializer.serializeConstantDataElement$lambda$111(this, constantDataElement));
        } else if (constantDataElement2 instanceof ConstantDataIntArray) {
            this.withTag-qim9Vi0(2, () -> WasmSerializer.serializeConstantDataElement$lambda$112(this, constantDataElement));
        } else if (constantDataElement2 instanceof ConstantDataIntField) {
            this.withTag-qim9Vi0(3, () -> WasmSerializer.serializeConstantDataElement$lambda$113(this, constantDataElement));
        } else if (constantDataElement2 instanceof ConstantDataIntegerArray) {
            this.withTag-qim9Vi0(4, () -> WasmSerializer.serializeConstantDataElement$lambda$114(this, constantDataElement));
        } else if (constantDataElement2 instanceof ConstantDataStruct) {
            this.withTag-qim9Vi0(5, () -> WasmSerializer.serializeConstantDataElement$lambda$115(this, constantDataElement));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void serializeConstantDataCharArray(ConstantDataCharArray constantDataCharArray) {
        this.serializeList(constantDataCharArray.getValue(), arg_0 -> WasmSerializer.serializeConstantDataCharArray$lambda$117(this, arg_0));
    }

    private final void serializeConstantDataCharField(ConstantDataCharField constantDataCharField) {
        this.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)constantDataCharField.getValue(), arg_0 -> WasmSerializer.serializeConstantDataCharField$lambda$118(this, arg_0));
    }

    private final void serializeConstantDataIntArray(ConstantDataIntArray constantDataIntArray) {
        this.serializeList(constantDataIntArray.getValue(), arg_0 -> WasmSerializer.serializeConstantDataIntArray$lambda$120(this, arg_0));
    }

    private final void serializeConstantDataIntField(ConstantDataIntField constantDataIntField) {
        this.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)constantDataIntField.getValue(), arg_0 -> WasmSerializer.serializeConstantDataIntField$lambda$121(this, arg_0));
    }

    private final void serializeConstantDataIntegerArray(ConstantDataIntegerArray constantDataIntegerArray) {
        this.serializeList(constantDataIntegerArray.getValue(), arg_0 -> WasmSerializer.serializeConstantDataIntegerArray$lambda$122(this, arg_0));
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(constantDataIntegerArray.getIntegerSize()));
    }

    private final void serializeConstantDataStruct(ConstantDataStruct constantDataStruct) {
        this.serializeList(constantDataStruct.getElements(), (Function1)new Function1<ConstantDataElement, Unit>((Object)this){

            public final void invoke(ConstantDataElement p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeConstantDataElement((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final void serializeJsCodeSnippet(WasmCompiledModuleFragment.JsCodeSnippet jsCodeSnippet) {
        this.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)jsCodeSnippet.getImportName(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeString(jsCodeSnippet.getJsCode());
    }

    private final void serializeByteArray(byte[] bytes) {
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(bytes.length));
        this.b.writeBytes(bytes);
    }

    private final void serializeString(String str) {
        this.serializeAsReference(str, () -> WasmSerializer.serializeString$lambda$126(str, this));
    }

    private final void serializeInt(int n) {
        this.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(n));
    }

    private final void serializeLong(long l) {
        this.b.writeUInt64-VKZWuLQ(ULong.constructor-impl(l));
    }

    private final <Ir, Wasm> void serializeReferencableElements(WasmCompiledModuleFragment.ReferencableElements<Ir, Wasm> referencableElements, Function1<? super Ir, Unit> irSerializeFunc, Function1<? super Wasm, Unit> wasmSerializeFunc) {
        this.serializeMap(referencableElements.getUnbound(), irSerializeFunc, arg_0 -> WasmSerializer.serializeReferencableElements$lambda$127(this, wasmSerializeFunc, arg_0));
    }

    private final <Ir, Wasm> void serializeReferencableAndDefinable(WasmCompiledModuleFragment.ReferencableAndDefinable<Ir, Wasm> referencableAndDefinable, Function1<? super Ir, Unit> irSerializeFunc, Function1<? super Wasm, Unit> wasmSerializeFunc) {
        WasmCompiledModuleFragment.ReferencableAndDefinable<Ir, Wasm> $this$serializeReferencableAndDefinable_u24lambda_u24129 = referencableAndDefinable;
        boolean bl = false;
        this.serializeMap($this$serializeReferencableAndDefinable_u24lambda_u24129.getUnbound(), irSerializeFunc, arg_0 -> WasmSerializer.serializeReferencableAndDefinable$lambda$129$lambda$128(this, wasmSerializeFunc, arg_0));
        this.serializeMap((Map)$this$serializeReferencableAndDefinable_u24lambda_u24129.getDefined(), irSerializeFunc, wasmSerializeFunc);
        this.serializeList($this$serializeReferencableAndDefinable_u24lambda_u24129.getElements(), wasmSerializeFunc);
        this.serializeMap($this$serializeReferencableAndDefinable_u24lambda_u24129.getWasmToIr(), wasmSerializeFunc, irSerializeFunc);
    }

    private final <T> void serializeWasmSymbolReadOnly(WasmSymbolReadOnly<? extends T> symbol, Function1<? super T, Unit> serializeFunc) {
        this.serializeAsReference(symbol, () -> WasmSerializer.serializeWasmSymbolReadOnly$lambda$132(this, symbol, serializeFunc));
    }

    private final void serializeCompiledFileFragment(WasmCompiledFileFragment compiledFileFragment) {
        WasmCompiledFileFragment $this$serializeCompiledFileFragment_u24lambda_u24141 = compiledFileFragment;
        boolean bl = false;
        this.serializeNullable($this$serializeCompiledFileFragment_u24lambda_u24141.getFragmentTag(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getFunctions(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmFunction, Unit>((Object)this){

            public final void invoke(WasmFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmFunction((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getGlobalFields(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmGlobal, Unit>((Object)this){

            public final void invoke(WasmGlobal p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmGlobal((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getGlobalVTables(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmGlobal, Unit>((Object)this){

            public final void invoke(WasmGlobal p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmGlobal((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getGlobalClassITables(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmGlobal, Unit>((Object)this){

            public final void invoke(WasmGlobal p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmGlobal((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getFunctionTypes(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmFunctionType, Unit>((Object)this){

            public final void invoke(WasmFunctionType p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmFunctionType((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getGcTypes(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmTypeDeclaration, Unit>((Object)this){

            public final void invoke(WasmTypeDeclaration p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmTypeDeclaration((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableAndDefinable($this$serializeCompiledFileFragment_u24lambda_u24141.getVTableGcTypes(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmTypeDeclaration, Unit>((Object)this){

            public final void invoke(WasmTypeDeclaration p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmTypeDeclaration((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getClassITableGcType(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmTypeDeclaration, Unit>((Object)this){

            public final void invoke(WasmTypeDeclaration p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmTypeDeclaration((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getClassITableInterfaceSlot(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getClassITableInterfaceTableSize(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getClassITableInterfaceHasImplementors(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeMap($this$serializeCompiledFileFragment_u24lambda_u24141.getTypeInfo(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<ConstantDataElement, Unit>((Object)this){

            public final void invoke(ConstantDataElement p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeConstantDataElement((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getClassIds(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getInterfaceIds(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getStringLiteralAddress(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getStringLiteralPoolId(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeReferencableElements($this$serializeCompiledFileFragment_u24lambda_u24141.getConstantArrayDataSegmentId(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$134(this, arg_0), (Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getInterfaceUnions(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$135(this, arg_0));
        this.serializeMap($this$serializeCompiledFileFragment_u24lambda_u24141.getJsFuns(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<WasmCompiledModuleFragment.JsCodeSnippet, Unit>((Object)this){

            public final void invoke(WasmCompiledModuleFragment.JsCodeSnippet p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeJsCodeSnippet((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeMap($this$serializeCompiledFileFragment_u24lambda_u24141.getJsModuleImports(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getExports(), new Function1<WasmExport<?>, Unit>(this){

            public final void invoke(WasmExport<?> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmExport((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable($this$serializeCompiledFileFragment_u24lambda_u24141.getScratchMemAddr(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$136(this, arg_0));
        this.serializeNullable($this$serializeCompiledFileFragment_u24lambda_u24141.getStringPoolSize(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$137(this, arg_0));
        this.serializeNullable($this$serializeCompiledFileFragment_u24lambda_u24141.getThrowableTagIndex(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$138(this, arg_0));
        this.serializeNullable($this$serializeCompiledFileFragment_u24lambda_u24141.getJsExceptionTagIndex(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$139(this, arg_0));
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getFieldInitializers(), (Function1)new Function1<FieldInitializer, Unit>((Object)this){

            public final void invoke(FieldInitializer p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeFieldInitializer((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getMainFunctionWrappers(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getTestFunctionDeclarators(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getEquivalentFunctions(), arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$140(this, arg_0));
        this.serializeSet($this$serializeCompiledFileFragment_u24lambda_u24141.getJsModuleAndQualifierReferences(), (Function1)new Function1<JsModuleAndQualifierReference, Unit>((Object)this){

            public final void invoke(JsModuleAndQualifierReference p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeJsModuleAndQualifierReference((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeList($this$serializeCompiledFileFragment_u24lambda_u24141.getClassAssociatedObjectsInstanceGetters(), (Function1)new Function1<ClassAssociatedObjects, Unit>((Object)this){

            public final void invoke(ClassAssociatedObjects p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeClassAssociatedObjects((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable($this$serializeCompiledFileFragment_u24lambda_u24141.getBuiltinIdSignatures(), (Function1)new Function1<BuiltinIdSignatures, Unit>((Object)this){

            public final void invoke(BuiltinIdSignatures p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeBuiltinIdSignatures((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final void serializeBuiltinIdSignatures(BuiltinIdSignatures builtinIdSignatures) {
        this.serializeNullable(builtinIdSignatures.getThrowable(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable(builtinIdSignatures.getTryGetAssociatedObject(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable(builtinIdSignatures.getJsToKotlinAnyAdapter(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable(builtinIdSignatures.getUnitGetInstance(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable(builtinIdSignatures.getRunRootSuites(), (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final void serializeFieldInitializer(FieldInitializer fieldInitializer) {
        boolean[] blArray = new boolean[]{fieldInitializer.isObjectInstanceField()};
        this.withFlags(blArray, () -> WasmSerializer.serializeFieldInitializer$lambda$142(this, fieldInitializer));
    }

    private final void serializeClassAssociatedObjects(ClassAssociatedObjects classAssociatedObjects) {
        this.serializeIdSignature(classAssociatedObjects.getKlass());
        this.serializeList(classAssociatedObjects.getObjects(), (Function1)new Function1<AssociatedObject, Unit>((Object)this){

            public final void invoke(AssociatedObject p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeAssociatedObject((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final void serializeAssociatedObject(AssociatedObject associatedObject) {
        boolean[] blArray = new boolean[]{associatedObject.isExternal()};
        this.withFlags(blArray, () -> WasmSerializer.serializeAssociatedObject$lambda$143(this, associatedObject));
    }

    private final void serializeJsModuleAndQualifierReference(JsModuleAndQualifierReference obj) {
        this.serializeNullable(obj.getModule(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        });
        this.serializeNullable(obj.getQualifier(), (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        });
    }

    private final void serializeNamedModuleField(WasmNamedModuleField obj, List<Boolean> flags, Function0<Unit> serializeFunc) {
        this.serializeAsReference(obj, () -> WasmSerializer.serializeNamedModuleField$lambda$146(this, obj, flags, serializeFunc));
    }

    static /* synthetic */ void serializeNamedModuleField$default(WasmSerializer wasmSerializer, WasmNamedModuleField wasmNamedModuleField, List list, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        wasmSerializer.serializeNamedModuleField(wasmNamedModuleField, list, function0);
    }

    private final void withTagNullable-OzbTU-A(int tag, Object obj, Function0<Unit> serializeFunc) {
        int isNull = obj == null ? 1 : 0;
        byte newId = UByte.constructor-impl((byte)UInt.constructor-impl(tag | UInt.constructor-impl(isNull << 7)));
        this.b.writeUByte-7apg3OU(newId);
        if (isNull != 1) {
            serializeFunc.invoke();
        }
    }

    private final void setTag-WZ4Q5Ns(int tag) {
        this.b.writeUByte-7apg3OU(UByte.constructor-impl((byte)tag));
    }

    private final void withTag-qim9Vi0(int tag, Function0<Unit> serializeFunc) {
        this.b.writeUByte-7apg3OU(UByte.constructor-impl((byte)tag));
        serializeFunc.invoke();
    }

    private final void withFlags(boolean[] flags, Function0<Unit> serializeFunc) {
        if (flags.length > 8) {
            throw new IllegalStateException("Can't pack more than 8 flags in a single byte".toString());
        }
        this.b.writeUByte-7apg3OU(this.flagsToUByte-Wa3L5BU(flags));
        serializeFunc.invoke();
    }

    private final void serializeAsReference(Object obj, Function0<Unit> serializeFunc) {
        Object object;
        Map $this$getOrPut$iv = this.referenceTable;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(obj);
        if (value$iv == null) {
            DeferredSerialization deferredSerialization;
            boolean bl = false;
            DeferredSerialization it = deferredSerialization = new DeferredSerialization(this.referenceTable.size(), serializeFunc);
            boolean bl2 = false;
            this.newReferences.add(it);
            DeferredSerialization answer$iv = deferredSerialization;
            $this$getOrPut$iv.put(obj, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        int id = ((DeferredSerialization)object).getId();
        this.serializeInt(id);
    }

    private final <T> T getOwner(WasmSymbolReadOnly<? extends T> $this$getOwner) {
        if ($this$getOwner instanceof WasmSymbol) {
        } else {
            throw new IllegalStateException(("Unsupported symbol type: " + Reflection.getOrCreateKotlinClass($this$getOwner.getClass())).toString());
        }
        return ((WasmSymbol)$this$getOwner).isBound() ? (T)((WasmSymbol)$this$getOwner).getOwner() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final byte flagsToUByte-Wa3L5BU(boolean[] flags) {
        int result2 = 0;
        result2 = 0;
        boolean[] $this$forEachIndexed$iv = flags;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (boolean item$iv : $this$forEachIndexed$iv) {
            void flag;
            int n = index$iv++;
            boolean bl = item$iv;
            int i = n;
            boolean bl2 = false;
            if (flag == false) continue;
            result2 = UInt.constructor-impl(result2 | UInt.constructor-impl(1 << i));
        }
        return UByte.constructor-impl((byte)result2);
    }

    private final byte toByte(boolean $this$toByte) {
        return (byte)($this$toByte ? 1 : 0);
    }

    private static final Unit serializeWasmFunction$lambda$5$lambda$3(WasmSerializer this$0, WasmFunction $func) {
        this$0.serializeList(((WasmFunction.Defined)$func).getLocals(), (Function1)new Function1<WasmLocal, Unit>((Object)this$0){

            public final void invoke(WasmLocal p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmLocal((WasmSerializer)this.receiver, p0);
            }
        });
        this$0.serializeList(((WasmFunction.Defined)$func).getInstructions(), (Function1)new Function1<WasmInstr, Unit>((Object)this$0){

            public final void invoke(WasmInstr p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmInstr((WasmSerializer)this.receiver, p0);
            }
        });
        this$0.serializeSourceLocation(((WasmFunction.Defined)$func).getStartLocation());
        this$0.serializeSourceLocation(((WasmFunction.Defined)$func).getEndLocation());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmFunction$lambda$5$lambda$4(WasmSerializer this$0, WasmFunction $func) {
        this$0.serializeWasmImportDescriptor(((WasmFunction.Imported)$func).getImportPair());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmFunction$lambda$5(WasmSerializer this$0, WasmFunction $func) {
        this$0.serializeWasmSymbolReadOnly($func.getType(), (Function1)new Function1<WasmFunctionType, Unit>((Object)this$0){

            public final void invoke(WasmFunctionType p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmFunctionType((WasmSerializer)this.receiver, p0);
            }
        });
        WasmFunction wasmFunction = $func;
        if (wasmFunction instanceof WasmFunction.Defined) {
            this$0.withTag-qim9Vi0(0, () -> WasmSerializer.serializeWasmFunction$lambda$5$lambda$3(this$0, $func));
        } else if (wasmFunction instanceof WasmFunction.Imported) {
            this$0.withTag-qim9Vi0(1, () -> WasmSerializer.serializeWasmFunction$lambda$5$lambda$4(this$0, $func));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmGlobal$lambda$7(WasmSerializer this$0, WasmGlobal $global) {
        block0: {
            this$0.serializeWasmType($global.getType());
            this$0.serializeList($global.getInit(), (Function1)new Function1<WasmInstr, Unit>((Object)this$0){

                public final void invoke(WasmInstr p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    WasmSerializer.access$serializeWasmInstr((WasmSerializer)this.receiver, p0);
                }
            });
            WasmImportDescriptor wasmImportDescriptor = $global.getImportPair();
            if (wasmImportDescriptor == null) break block0;
            WasmImportDescriptor it = wasmImportDescriptor;
            boolean bl = false;
            this$0.serializeWasmImportDescriptor(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmFunctionType$lambda$8(WasmSerializer this$0, WasmFunctionType $funcType) {
        this$0.serializeList($funcType.getParameterTypes(), (Function1)new Function1<WasmType, Unit>((Object)this$0){

            public final void invoke(WasmType p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmType((WasmSerializer)this.receiver, p0);
            }
        });
        this$0.serializeList($funcType.getResultTypes(), (Function1)new Function1<WasmType, Unit>((Object)this$0){

            public final void invoke(WasmType p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmType((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTypeDeclaration$lambda$9(WasmSerializer this$0, WasmTypeDeclaration $typeDecl) {
        this$0.serializeWasmFunctionType((WasmFunctionType)$typeDecl);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTypeDeclaration$lambda$10(WasmSerializer this$0, WasmTypeDeclaration $typeDecl) {
        this$0.serializeWasmStructDeclaration((WasmStructDeclaration)$typeDecl);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTypeDeclaration$lambda$11(WasmSerializer this$0, WasmTypeDeclaration $typeDecl) {
        this$0.serializeWasmArrayDeclaration((WasmArrayDeclaration)$typeDecl);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmStructDeclaration$lambda$13(WasmSerializer this$0, WasmStructDeclaration $structDecl) {
        block0: {
            this$0.serializeList($structDecl.getFields(), (Function1)new Function1<WasmStructFieldDeclaration, Unit>((Object)this$0){

                public final void invoke(WasmStructFieldDeclaration p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    WasmSerializer.access$serializeWasmStructFieldDeclaration((WasmSerializer)this.receiver, p0);
                }
            });
            WasmSymbolReadOnly<WasmTypeDeclaration> wasmSymbolReadOnly = $structDecl.getSuperType();
            if (wasmSymbolReadOnly == null) break block0;
            WasmSymbolReadOnly<WasmTypeDeclaration> it = wasmSymbolReadOnly;
            boolean bl = false;
            this$0.serializeWasmSymbolReadOnly(it, (Function1)new Function1<WasmTypeDeclaration, Unit>((Object)this$0){

                public final void invoke(WasmTypeDeclaration p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    WasmSerializer.access$serializeWasmTypeDeclaration((WasmSerializer)this.receiver, p0);
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmArrayDeclaration$lambda$14(WasmSerializer this$0, WasmArrayDeclaration $arrDecl) {
        this$0.serializeString($arrDecl.getField().getName());
        this$0.serializeWasmType($arrDecl.getField().getType());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmMemory$lambda$16(WasmSerializer this$0, WasmMemory $memory) {
        block0: {
            this$0.serializeWasmLimits($memory.getLimits());
            WasmImportDescriptor wasmImportDescriptor = $memory.getImportPair();
            if (wasmImportDescriptor == null) break block0;
            WasmImportDescriptor it = wasmImportDescriptor;
            boolean bl = false;
            this$0.serializeWasmImportDescriptor(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTag$lambda$18(WasmSerializer this$0, WasmTag $tag) {
        block0: {
            this$0.serializeWasmFunctionType($tag.getType());
            WasmImportDescriptor wasmImportDescriptor = $tag.getImportPair();
            if (wasmImportDescriptor == null) break block0;
            WasmImportDescriptor it = wasmImportDescriptor;
            boolean bl = false;
            this$0.serializeWasmImportDescriptor(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmType$lambda$19(WasmSerializer this$0, WasmType $type) {
        this$0.serializeWasmHeapType(((WasmRefType)$type).getHeapType());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmType$lambda$20(WasmSerializer this$0, WasmType $type) {
        this$0.serializeWasmHeapType(((WasmRefNullType)$type).getHeapType());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmHeapType$lambda$22$lambda$21(WasmSerializer this$0, WasmTypeDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmTypeDeclaration(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmHeapType$lambda$22(WasmSerializer this$0, WasmHeapType $type) {
        this$0.serializeWasmSymbolReadOnly(((WasmHeapType.Type)$type).getType(), arg_0 -> WasmSerializer.serializeWasmHeapType$lambda$22$lambda$21(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmInstr$lambda$23(WasmSerializer this$0, WasmInstr $instr) {
        this$0.serializeList($instr.getImmediates(), (Function1)new Function1<WasmImmediate, Unit>((Object)this$0){

            public final void invoke(WasmImmediate p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmImmediate((WasmSerializer)this.receiver, p0);
            }
        });
        this$0.serializeSourceLocation(((WasmInstrWithLocation)$instr).getLocation());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmInstr$lambda$24(WasmSerializer this$0, WasmInstr $instr) {
        this$0.serializeList($instr.getImmediates(), (Function1)new Function1<WasmImmediate, Unit>((Object)this$0){

            public final void invoke(WasmImmediate p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmImmediate((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$25(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmFunctionType(((WasmImmediate.BlockType.Function)$i).getType());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$26(WasmSerializer this$0, WasmImmediate $i) {
        WasmType wasmType = ((WasmImmediate.BlockType.Value)$i).getType();
        Intrinsics.checkNotNull(wasmType);
        this$0.serializeWasmType(wasmType);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$27(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeCatchImmediate((WasmImmediate.Catch)$i);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$28(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt32-WZ4Q5Ns(((WasmImmediate.ConstF32)$i).getRawBits-pVg5ArA());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$29(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt64-VKZWuLQ(((WasmImmediate.ConstF64)$i).getRawBits-s-VKNKU());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$30(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(((WasmImmediate.ConstI32)$i).getValue()));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$31(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt64-VKZWuLQ(ULong.constructor-impl(((WasmImmediate.ConstI64)$i).getValue()));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$32(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeString(((WasmImmediate.ConstString)$i).getValue());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$33(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUByte-7apg3OU(((WasmImmediate.ConstU8)$i).getValue-w2LRezQ());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$35$lambda$34(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$35(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.DataIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$35$lambda$34(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$36(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmElement(((WasmImmediate.ElemIdx)$i).getValue());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$38$lambda$37(WasmSerializer this$0, WasmFunction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmFunction(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$38(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.FuncIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$38$lambda$37(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$40$lambda$39(WasmSerializer this$0, WasmTypeDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmTypeDeclaration(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$40(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.GcType)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$40$lambda$39(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$42$lambda$41(WasmSerializer this$0, WasmGlobal it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmGlobal(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$42(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.GlobalIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$42$lambda$41(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$43(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmHeapType(((WasmImmediate.HeapType)$i).getValue());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$44(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(((WasmImmediate.LabelIdx)$i).getValue()));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$46$lambda$45(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$46(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeList(((WasmImmediate.LabelIdxVector)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$46$lambda$45(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$48$lambda$47(WasmSerializer this$0, WasmLocal it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmLocal(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$48(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.LocalIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$48$lambda$47(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$49(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)$i).getAlign-pVg5ArA());
        this$0.b.writeUInt32-WZ4Q5Ns(((WasmImmediate.MemArg)$i).getOffset-pVg5ArA());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$50(WasmSerializer this$0, WasmImmediate $i) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(((WasmImmediate.MemoryIdx)$i).getValue()));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$52$lambda$51(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$52(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.StructFieldIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$52$lambda$51(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$54$lambda$53(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$54(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.SymbolI32)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$54$lambda$53(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$56$lambda$55(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$56(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly(((WasmImmediate.TableIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$56$lambda$55(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$58$lambda$57(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$58(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmImmediate.TagIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$58$lambda$57(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$60$lambda$59(WasmSerializer this$0, WasmTypeDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmTypeDeclaration(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$60(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeWasmSymbolReadOnly(((WasmImmediate.TypeIdx)$i).getValue(), arg_0 -> WasmSerializer.serializeWasmImmediate$lambda$60$lambda$59(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmImmediate$lambda$61(WasmSerializer this$0, WasmImmediate $i) {
        this$0.serializeList(((WasmImmediate.ValTypeVector)$i).getValue(), (Function1)new Function1<WasmType, Unit>((Object)this$0){

            public final void invoke(WasmType p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmType((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCatchImmediate$lambda$62(WasmSerializer this$0, WasmImmediate.Catch $catch) {
        this$0.serializeList($catch.getImmediates(), (Function1)new Function1<WasmImmediate, Unit>((Object)this$0){

            public final void invoke(WasmImmediate p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmImmediate((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTable$lambda$65(WasmSerializer this$0, WasmTable $table, UInt $max, WasmImportDescriptor $ip) {
        block1: {
            this$0.b.writeUInt32-WZ4Q5Ns($table.getLimits().getMinSize-pVg5ArA());
            UInt uInt = $max;
            if (uInt != null) {
                int it = uInt.unbox-impl();
                boolean bl = false;
                this$0.b.writeUInt32-WZ4Q5Ns(it);
            }
            this$0.serializeWasmType($table.getElementType());
            WasmImportDescriptor wasmImportDescriptor = $ip;
            if (wasmImportDescriptor == null) break block1;
            WasmImportDescriptor it = wasmImportDescriptor;
            boolean bl = false;
            this$0.serializeWasmImportDescriptor(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTableValue$lambda$66(WasmSerializer this$0, WasmTable.Value $value) {
        this$0.serializeList(((WasmTable.Value.Expression)$value).getExpr(), (Function1)new Function1<WasmInstr, Unit>((Object)this$0){

            public final void invoke(WasmInstr p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmInstr((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTableValue$lambda$68$lambda$67(WasmSerializer this$0, WasmFunction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmFunction(it);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmTableValue$lambda$68(WasmSerializer this$0, WasmTable.Value $value) {
        this$0.serializeWasmSymbolReadOnly((WasmSymbolReadOnly)((WasmTable.Value.Function)$value).getFunction(), arg_0 -> WasmSerializer.serializeWasmTableValue$lambda$68$lambda$67(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmElement$lambda$69(WasmSerializer this$0, WasmElement $element) {
        this$0.serializeWasmType($element.getType());
        this$0.serializeList($element.getValues(), (Function1)new Function1<WasmTable.Value, Unit>((Object)this$0){

            public final void invoke(WasmTable.Value p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmTableValue((WasmSerializer)this.receiver, p0);
            }
        });
        this$0.serializeWasmElementMode($element.getMode());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmElementMode$lambda$70(WasmSerializer this$0, WasmElement.Mode $mode) {
        this$0.serializeWasmTable(((WasmElement.Mode.Active)$mode).getTable());
        this$0.serializeList(((WasmElement.Mode.Active)$mode).getOffset(), (Function1)new Function1<WasmInstr, Unit>((Object)this$0){

            public final void invoke(WasmInstr p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmInstr((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmExport$lambda$71(WasmSerializer this$0, WasmExport $export) {
        this$0.serializeWasmFunction((WasmFunction)((WasmExport.Function)$export).getField());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmExport$lambda$72(WasmSerializer this$0, WasmExport $export) {
        this$0.serializeWasmTable((WasmTable)((WasmExport.Table)$export).getField());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmExport$lambda$73(WasmSerializer this$0, WasmExport $export) {
        this$0.serializeWasmMemory((WasmMemory)((WasmExport.Memory)$export).getField());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmExport$lambda$74(WasmSerializer this$0, WasmExport $export) {
        this$0.serializeWasmGlobal((WasmGlobal)((WasmExport.Global)$export).getField());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmExport$lambda$75(WasmSerializer this$0, WasmExport $export) {
        this$0.serializeWasmTag((WasmTag)((WasmExport.Tag)$export).getField());
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmLimits$lambda$77(WasmSerializer this$0, WasmLimits $limit) {
        block0: {
            this$0.b.writeUInt32-WZ4Q5Ns($limit.getMinSize-pVg5ArA());
            UInt uInt = $limit.getMaxSize-0hXNFcg();
            if (uInt == null) break block0;
            int it = uInt.unbox-impl();
            boolean bl = false;
            this$0.b.writeUInt32-WZ4Q5Ns(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeSourceLocation$lambda$81(WasmSerializer this$0, SourceLocation $sl) {
        this$0.serializeString(((SourceLocation.DefinedLocation)$sl).getModule());
        this$0.serializeString(((SourceLocation.DefinedLocation)$sl).getFile());
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(((SourceLocation.DefinedLocation)$sl).getLine()));
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(((SourceLocation.DefinedLocation)$sl).getColumn()));
        return Unit.INSTANCE;
    }

    private static final Unit serializeNullable$lambda$82(Function1 $serializeFunc, Object $value) {
        $serializeFunc.invoke($value);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$83(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeAccessorSignature((IdSignature.AccessorSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$84(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeCommonSignature((IdSignature.CommonSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$85(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeCompositeSignature((IdSignature.CompositeSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$86(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeFileLocalSignature((IdSignature.FileLocalSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$87(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeLocalSignature((IdSignature.LocalSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$88(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeLoweredDeclarationSignature((IdSignature.LoweredDeclarationSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$89(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeScopeLocalDeclaration((IdSignature.ScopeLocalDeclaration)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$90(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeSpecialFakeOverrideSignature((IdSignature.SpecialFakeOverrideSignature)$idSignature);
        return Unit.INSTANCE;
    }

    private static final Unit serializeIdSignature$lambda$91(WasmSerializer this$0, IdSignature $idSignature) {
        this$0.serializeString(((IdSignature.FileSignature)$idSignature).getFileName());
        return Unit.INSTANCE;
    }

    private static final Unit serializeCommonSignature$lambda$96$lambda$95(WasmSerializer this$0, IdSignature.CommonSignature $this_with) {
        block1: {
            this$0.serializeString($this_with.getPackageFqName());
            this$0.serializeString($this_with.getDeclarationFqName());
            Long l = $this_with.getId();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                this$0.b.writeUInt64-VKZWuLQ(ULong.constructor-impl(it));
            }
            this$0.b.writeUInt64-VKZWuLQ(ULong.constructor-impl($this_with.getMask()));
            String string2 = $this_with.getDescription();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            this$0.serializeString(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeFileLocalSignature$lambda$100$lambda$99(WasmSerializer this$0, IdSignature.FileLocalSignature $this_with) {
        block0: {
            this$0.serializeIdSignature($this_with.getContainer());
            this$0.b.writeUInt64-VKZWuLQ(ULong.constructor-impl($this_with.getId()));
            String string2 = $this_with.getDescription();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this$0.serializeString(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeLocalSignature$lambda$104$lambda$103(WasmSerializer this$0, IdSignature.LocalSignature $this_with) {
        block1: {
            this$0.serializeString($this_with.getLocalFqn());
            Long l = $this_with.getHashSig();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                this$0.b.writeUInt64-VKZWuLQ(ULong.constructor-impl(it));
            }
            String string2 = $this_with.getDescription();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            this$0.serializeString(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeScopeLocalDeclaration$lambda$108$lambda$107(WasmSerializer this$0, IdSignature.ScopeLocalDeclaration $this_with) {
        block0: {
            this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl($this_with.getId()));
            String string2 = $this_with.getDescription();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this$0.serializeString(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataElement$lambda$110(WasmSerializer this$0, ConstantDataElement $constantDataElement) {
        this$0.serializeConstantDataCharArray((ConstantDataCharArray)$constantDataElement);
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataElement$lambda$111(WasmSerializer this$0, ConstantDataElement $constantDataElement) {
        this$0.serializeConstantDataCharField((ConstantDataCharField)$constantDataElement);
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataElement$lambda$112(WasmSerializer this$0, ConstantDataElement $constantDataElement) {
        this$0.serializeConstantDataIntArray((ConstantDataIntArray)$constantDataElement);
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataElement$lambda$113(WasmSerializer this$0, ConstantDataElement $constantDataElement) {
        this$0.serializeConstantDataIntField((ConstantDataIntField)$constantDataElement);
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataElement$lambda$114(WasmSerializer this$0, ConstantDataElement $constantDataElement) {
        this$0.serializeConstantDataIntegerArray((ConstantDataIntegerArray)$constantDataElement);
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataElement$lambda$115(WasmSerializer this$0, ConstantDataElement $constantDataElement) {
        this$0.serializeConstantDataStruct((ConstantDataStruct)$constantDataElement);
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataCharArray$lambda$117$lambda$116(WasmSerializer this$0, char it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataCharArray$lambda$117(WasmSerializer this$0, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, arg_0 -> WasmSerializer.serializeConstantDataCharArray$lambda$117$lambda$116(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataCharField$lambda$118(WasmSerializer this$0, char it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataIntArray$lambda$120$lambda$119(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataIntArray$lambda$120(WasmSerializer this$0, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, arg_0 -> WasmSerializer.serializeConstantDataIntArray$lambda$120$lambda$119(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataIntField$lambda$121(WasmSerializer this$0, int it) {
        this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeConstantDataIntegerArray$lambda$122(WasmSerializer this$0, long it) {
        this$0.b.writeUInt64-VKZWuLQ(ULong.constructor-impl(it));
        return Unit.INSTANCE;
    }

    private static final Unit serializeString$lambda$126$lambda$124(WasmSerializer this$0, String $str) {
        String string2 = $str;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        this$0.serializeByteArray(byArray);
        return Unit.INSTANCE;
    }

    private static final Unit serializeString$lambda$126$lambda$125(WasmSerializer this$0, byte[] $charsByteArray) {
        this$0.serializeByteArray($charsByteArray);
        return Unit.INSTANCE;
    }

    private static final Unit serializeString$lambda$126(String $str, WasmSerializer this$0) {
        boolean bl;
        int n;
        int n2;
        Object[] $this$none$iv;
        char[] chars;
        block4: {
            char[] cArray = $str.toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
            $this$none$iv = chars = cArray;
            boolean $i$f$none = false;
            n2 = $this$none$iv.length;
            for (n = 0; n < n2; ++n) {
                char element$iv;
                char it = element$iv = $this$none$iv[n];
                boolean bl2 = false;
                if (!CharsKt.isSurrogate(it)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            $this$none$iv = new boolean[1];
            $this$none$iv[0] = '\u0001';
            this$0.withFlags((boolean[])$this$none$iv, () -> WasmSerializer.serializeString$lambda$126$lambda$124(this$0, $str));
        } else {
            byte[] charsByteArray = new byte[chars.length * 2];
            int index = 0;
            n2 = chars.length;
            for (n = 0; n < n2; ++n) {
                char c;
                char code = c = chars[n];
                charsByteArray[index * 2] = (byte)(code & 0xFF);
                charsByteArray[index * 2 + 1] = (byte)(code >>> 8);
                ++index;
            }
            boolean[] blArray = new boolean[]{false};
            this$0.withFlags(blArray, () -> WasmSerializer.serializeString$lambda$126$lambda$125(this$0, charsByteArray));
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeReferencableElements$lambda$127(WasmSerializer this$0, Function1 $wasmSerializeFunc, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, $wasmSerializeFunc);
        return Unit.INSTANCE;
    }

    private static final Unit serializeReferencableAndDefinable$lambda$129$lambda$128(WasmSerializer this$0, Function1 $wasmSerializeFunc, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, $wasmSerializeFunc);
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmSymbolReadOnly$lambda$132$lambda$131(WasmSerializer this$0, WasmSymbolReadOnly $symbol, Function1 $serializeFunc) {
        block0: {
            Object t = this$0.getOwner($symbol);
            if (t == null) break block0;
            Object it = t;
            boolean bl = false;
            $serializeFunc.invoke(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeWasmSymbolReadOnly$lambda$132(WasmSerializer this$0, WasmSymbolReadOnly $symbol, Function1 $serializeFunc) {
        boolean[] blArray = new boolean[]{this$0.getOwner($symbol) == null};
        this$0.withFlags(blArray, () -> WasmSerializer.serializeWasmSymbolReadOnly$lambda$132$lambda$131(this$0, $symbol, $serializeFunc));
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$134$lambda$133(WasmSerializer this$0, List it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeList(it, (Function1)new Function1<Long, Unit>((Object)this$0){

            public final void invoke(long p0) {
                WasmSerializer.access$serializeLong((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$134(WasmSerializer this$0, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializePair(it, arg_0 -> WasmSerializer.serializeCompiledFileFragment$lambda$141$lambda$134$lambda$133(this$0, arg_0), (Function1)new Function1<WasmType, Unit>((Object)this$0){

            public final void invoke(WasmType p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmType((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$135(WasmSerializer this$0, List it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeList(it, (Function1)new Function1<IdSignature, Unit>((Object)this$0){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$136(WasmSerializer this$0, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, (Function1)new Function1<Integer, Unit>((Object)this$0){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$137(WasmSerializer this$0, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, (Function1)new Function1<Integer, Unit>((Object)this$0){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$138(WasmSerializer this$0, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, (Function1)new Function1<Integer, Unit>((Object)this$0){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$139(WasmSerializer this$0, WasmSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializeWasmSymbolReadOnly(it, (Function1)new Function1<Integer, Unit>((Object)this$0){

            public final void invoke(int p0) {
                WasmSerializer.access$serializeInt((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeCompiledFileFragment$lambda$141$lambda$140(WasmSerializer this$0, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.serializePair(it, (Function1)new Function1<String, Unit>((Object)this$0){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeString((WasmSerializer)this.receiver, p0);
            }
        }, (Function1)new Function1<IdSignature, Unit>((Object)this$0){

            public final void invoke(IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeIdSignature((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeFieldInitializer$lambda$142(WasmSerializer this$0, FieldInitializer $fieldInitializer) {
        this$0.serializeIdSignature($fieldInitializer.getField());
        this$0.serializeList($fieldInitializer.getInstructions(), (Function1)new Function1<WasmInstr, Unit>((Object)this$0){

            public final void invoke(WasmInstr p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                WasmSerializer.access$serializeWasmInstr((WasmSerializer)this.receiver, p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit serializeAssociatedObject$lambda$143(WasmSerializer this$0, AssociatedObject $associatedObject) {
        this$0.serializeIdSignature($associatedObject.getObj());
        this$0.serializeIdSignature($associatedObject.getGetterFunc());
        return Unit.INSTANCE;
    }

    private static final Unit serializeNamedModuleField$lambda$146$lambda$145(WasmNamedModuleField $obj, WasmSerializer this$0, Function0 $serializeFunc) {
        Integer n = $obj.getId();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this$0.b.writeUInt32-WZ4Q5Ns(UInt.constructor-impl(it));
        }
        if (((CharSequence)$obj.getName()).length() > 0) {
            this$0.serializeString($obj.getName());
        }
        $serializeFunc.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit serializeNamedModuleField$lambda$146(WasmSerializer this$0, WasmNamedModuleField $obj, List $flags, Function0 $serializeFunc) {
        Boolean[] booleanArray = new Boolean[]{$obj.getId() == null, ((CharSequence)$obj.getName()).length() == 0};
        boolean[] blArray = CollectionsKt.toBooleanArray(CollectionsKt.plus((Collection)CollectionsKt.listOf(booleanArray), (Iterable)$flags));
        this$0.withFlags(Arrays.copyOf(blArray, blArray.length), () -> WasmSerializer.serializeNamedModuleField$lambda$146$lambda$145($obj, this$0, $serializeFunc));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$serializeString(WasmSerializer $this, String str) {
        $this.serializeString(str);
    }

    public static final /* synthetic */ void access$serializeConstantDataElement(WasmSerializer $this, ConstantDataElement constantDataElement) {
        $this.serializeConstantDataElement(constantDataElement);
    }

    public static final /* synthetic */ void access$serializeIdSignature(WasmSerializer $this, IdSignature idSignature) {
        $this.serializeIdSignature(idSignature);
    }

    public static final /* synthetic */ void access$serializeAssociatedObject(WasmSerializer $this, AssociatedObject associatedObject) {
        $this.serializeAssociatedObject(associatedObject);
    }

    public static final /* synthetic */ void access$serializeWasmLocal(WasmSerializer $this, WasmLocal local) {
        $this.serializeWasmLocal(local);
    }

    public static final /* synthetic */ void access$serializeWasmInstr(WasmSerializer $this, WasmInstr instr) {
        $this.serializeWasmInstr(instr);
    }

    public static final /* synthetic */ void access$serializeWasmFunctionType(WasmSerializer $this, WasmFunctionType funcType) {
        $this.serializeWasmFunctionType(funcType);
    }

    public static final /* synthetic */ void access$serializeWasmType(WasmSerializer $this, WasmType type2) {
        $this.serializeWasmType(type2);
    }

    public static final /* synthetic */ void access$serializeWasmTypeDeclaration(WasmSerializer $this, WasmTypeDeclaration typeDecl) {
        $this.serializeWasmTypeDeclaration(typeDecl);
    }

    public static final /* synthetic */ void access$serializeWasmStructFieldDeclaration(WasmSerializer $this, WasmStructFieldDeclaration structFieldDecl) {
        $this.serializeWasmStructFieldDeclaration(structFieldDecl);
    }

    public static final /* synthetic */ void access$serializeWasmImmediate(WasmSerializer $this, WasmImmediate i) {
        $this.serializeWasmImmediate(i);
    }

    public static final /* synthetic */ void access$serializeWasmTableValue(WasmSerializer $this, WasmTable.Value value2) {
        $this.serializeWasmTableValue(value2);
    }

    public static final /* synthetic */ void access$serializeLong(WasmSerializer $this, long l) {
        $this.serializeLong(l);
    }

    public static final /* synthetic */ void access$serializeInt(WasmSerializer $this, int n) {
        $this.serializeInt(n);
    }

    public static final /* synthetic */ void access$serializeWasmFunction(WasmSerializer $this, WasmFunction func) {
        $this.serializeWasmFunction(func);
    }

    public static final /* synthetic */ void access$serializeWasmGlobal(WasmSerializer $this, WasmGlobal global) {
        $this.serializeWasmGlobal(global);
    }

    public static final /* synthetic */ void access$serializeJsCodeSnippet(WasmSerializer $this, WasmCompiledModuleFragment.JsCodeSnippet jsCodeSnippet) {
        $this.serializeJsCodeSnippet(jsCodeSnippet);
    }

    public static final /* synthetic */ void access$serializeWasmExport(WasmSerializer $this, WasmExport export) {
        $this.serializeWasmExport(export);
    }

    public static final /* synthetic */ void access$serializeFieldInitializer(WasmSerializer $this, FieldInitializer fieldInitializer) {
        $this.serializeFieldInitializer(fieldInitializer);
    }

    public static final /* synthetic */ void access$serializeJsModuleAndQualifierReference(WasmSerializer $this, JsModuleAndQualifierReference obj) {
        $this.serializeJsModuleAndQualifierReference(obj);
    }

    public static final /* synthetic */ void access$serializeClassAssociatedObjects(WasmSerializer $this, ClassAssociatedObjects classAssociatedObjects) {
        $this.serializeClassAssociatedObjects(classAssociatedObjects);
    }

    public static final /* synthetic */ void access$serializeBuiltinIdSignatures(WasmSerializer $this, BuiltinIdSignatures builtinIdSignatures) {
        $this.serializeBuiltinIdSignatures(builtinIdSignatures);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/serialization/WasmSerializer$DeferredSerialization;", "", "id", "", "serializeFunc", "Lkotlin/Function0;", "", "<init>", "(ILkotlin/jvm/functions/Function0;)V", "getId", "()I", "getSerializeFunc", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "backend.wasm"})
    private static final class DeferredSerialization {
        private final int id;
        @NotNull
        private final Function0<Unit> serializeFunc;

        public DeferredSerialization(int id, @NotNull Function0<Unit> serializeFunc) {
            Intrinsics.checkNotNullParameter(serializeFunc, "serializeFunc");
            this.id = id;
            this.serializeFunc = serializeFunc;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final Function0<Unit> getSerializeFunc() {
            return this.serializeFunc;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final Function0<Unit> component2() {
            return this.serializeFunc;
        }

        @NotNull
        public final DeferredSerialization copy(int id, @NotNull Function0<Unit> serializeFunc) {
            Intrinsics.checkNotNullParameter(serializeFunc, "serializeFunc");
            return new DeferredSerialization(id, serializeFunc);
        }

        public static /* synthetic */ DeferredSerialization copy$default(DeferredSerialization deferredSerialization, int n, Function0 function0, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = deferredSerialization.id;
            }
            if ((n2 & 2) != 0) {
                function0 = deferredSerialization.serializeFunc;
            }
            return deferredSerialization.copy(n, function0);
        }

        @NotNull
        public String toString() {
            return "DeferredSerialization(id=" + this.id + ", serializeFunc=" + this.serializeFunc + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.id);
            result2 = result2 * 31 + this.serializeFunc.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeferredSerialization)) {
                return false;
            }
            DeferredSerialization deferredSerialization = (DeferredSerialization)other;
            if (this.id != deferredSerialization.id) {
                return false;
            }
            return Intrinsics.areEqual(this.serializeFunc, deferredSerialization.serializeFunc);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WasmOp.values().length];
            try {
                nArray[WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.PSEUDO_COMMENT_GROUP_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.PSEUDO_COMMENT_GROUP_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.MACRO_IF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.MACRO_ELSE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.MACRO_END_IF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.MACRO_TABLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.MACRO_TABLE_INDEX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmOp.MACRO_TABLE_END.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmImmediate.Catch.CatchType.values().length];
            try {
                nArray[WasmImmediate.Catch.CatchType.CATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediate.Catch.CatchType.CATCH_REF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediate.Catch.CatchType.CATCH_ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediate.Catch.CatchType.CATCH_ALL_REF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

