/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.com.google.inject.internal.BytecodeGen;
import org.jetbrains.kotlin.com.google.inject.internal.CircularDependencyProxy;
import org.jetbrains.kotlin.com.google.inject.internal.DelegatingInvocationHandler;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProvisionException;

final class ConstructionContext<T> {
    T currentReference;
    boolean constructing;
    List<DelegatingInvocationHandler<T>> invocationHandlers;

    ConstructionContext() {
    }

    public T getCurrentReference() {
        return this.currentReference;
    }

    public void removeCurrentReference() {
        this.currentReference = null;
    }

    public void setCurrentReference(T currentReference) {
        this.currentReference = currentReference;
    }

    public boolean isConstructing() {
        return this.constructing;
    }

    public void startConstruction() {
        this.constructing = true;
    }

    public void finishConstruction() {
        this.constructing = false;
        this.invocationHandlers = null;
    }

    public Object createProxy(InjectorImpl.InjectorOptions injectorOptions, Class<?> expectedType) throws InternalProvisionException {
        if (injectorOptions.disableCircularProxies) {
            throw InternalProvisionException.circularDependenciesDisabled(expectedType);
        }
        if (!expectedType.isInterface()) {
            throw InternalProvisionException.cannotProxyClass(expectedType);
        }
        if (this.invocationHandlers == null) {
            this.invocationHandlers = new ArrayList<DelegatingInvocationHandler<T>>();
        }
        DelegatingInvocationHandler invocationHandler = new DelegatingInvocationHandler();
        this.invocationHandlers.add(invocationHandler);
        ClassLoader classLoader = BytecodeGen.getClassLoader(expectedType);
        return expectedType.cast(Proxy.newProxyInstance(classLoader, new Class[]{expectedType, CircularDependencyProxy.class}, invocationHandler));
    }

    public void setProxyDelegates(T delegate) {
        if (this.invocationHandlers != null) {
            for (DelegatingInvocationHandler<T> handler : this.invocationHandlers) {
                handler.setDelegate(delegate);
            }
            this.invocationHandlers = null;
        }
    }
}

