﻿#pragma once

#include <array>
#include <climits>

class LuaIdentify {
public:
    static std::array<unsigned char, UCHAR_MAX + 2> LuaCharType;
    static void AddIdentifyChar(char ch);

private:
};

// 保持lua惯用法

#define ALPHABIT 0
#define DIGITBIT 1
#define PRINTBIT 2
#define SPACEBIT 3
#define XDIGITBIT 4


#define MASK(B) (1 << (B))


/*
** add 1 to char to allow index -1 (EOZ)
*/
#define testprop(c, p) (LuaIdentify::LuaCharType[(c) + 1] & (p))

/*
** 'lalpha' (Lua alphabetic) and 'lalnum' (Lua alphanumeric) both include '_'
*/
#define lislalpha(c) testprop(c, MASK(ALPHABIT))
#define lislalnum(c) testprop(c, (MASK(ALPHABIT) | MASK(DIGITBIT)))
#define lisdigit(c) testprop(c, MASK(DIGITBIT))
#define lisspace(c) testprop(c, MASK(SPACEBIT))
#define lisprint(c) testprop(c, MASK(PRINTBIT))
#define lisxdigit(c) testprop(c, MASK(XDIGITBIT))
