/************************************************************************
*																		*
*		Symbol Table Manager - Jim Schimpf Pandora Products				*			
*  																		*
*		MAC FILE LEXICAL ANALYZER FOR Mac Project Builder Files			*
*																		*
*		Module:CSymbol.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		28-Jul-2002	J.Schimpf	Initial Version						*
*	0.2		21-Jun-2003 J.Schimpf	Make hash table and fcn unsigned as	*
*									per note from Marc Boucher			*
*																		*
*	DESCRIPTION:													    *
*		This class creates and manages a symbol hash table.  It allows	*
*	insertion and find of text symbols.  Each symbol has a void ptr		*
*	attached which contains arbitrary data.								*
*																		*
*																		*
************************************************************************/

#include <stdlib.h>
#include <string.h>

#pragma once

// internal constants

#define DEF_HTBL_SIZE	256

// Internal structures

typedef struct hash_dummy 
		{
			struct hash_dummy *next;		/* Next item in list */
			char *name;						/* Sumbol name */
			void *value;					/* Attached value */
		} HASH_EL;
		
			
/************************************************************
*		OBJECT DEFS
************************************************************/

class  CSymbol {

	public:
	
		CSymbol(  );							// Create symbol table (DEF SIZE)
		CSymbol( int hash_size );				// Create symbol table
		~CSymbol();								// Remove table
		
		void clear(void);						// Clear symbol table
		bool add( char *name,void *ptr);		// Add a symbol
		void *find( char *name);				// Find symbol and rtn ptr
		
		void *find( int which,char *name );		// Find n'th occurance
		
	private:
	
		void init(void);						// Create hash table
		HASH_EL *find_internal( int nth,char *name );	// Find in hash table
		void add_internal( HASH_EL *el );		// Add to hash list

		unsigned int hash_value( char *name );			// Get hash value of name
	
		int 	size;							// # Slots in hash list
		HASH_EL **list;							// Internal HASH list
		
	
};
