/*
 * Decompiled with CFR 0.152.
 */
package org.fontbox.ttf;

import java.io.IOException;
import org.fontbox.ttf.HeaderTable;
import org.fontbox.ttf.MaximumProfileTable;
import org.fontbox.ttf.TTFDataStream;
import org.fontbox.ttf.TTFTable;
import org.fontbox.ttf.TrueTypeFont;

public class IndexToLocationTable
extends TTFTable {
    private static final short SHORT_OFFSETS = 0;
    private static final short LONG_OFFSETS = 1;
    public static final String TAG = "loca";
    private long[] offsets;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HeaderTable head = ttf.getHeader();
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        int numGlyphs = maxp.getNumGlyphs();
        this.offsets = new long[numGlyphs + 1];
        int i = 0;
        while (i < numGlyphs + 1) {
            if (head.getIndexToLocFormat() == 0) {
                this.offsets[i] = data.readUnsignedShort() * 2;
            } else if (head.getIndexToLocFormat() == 1) {
                this.offsets[i] = data.readUnsignedInt();
            } else {
                throw new IOException("Error:TTF.loca unknown offset format.");
            }
            ++i;
        }
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public void setOffsets(long[] offsetsValue) {
        this.offsets = offsetsValue;
    }
}

