/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.pdfbox.pdmodel.interactive.form.PDChoiceField;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.pdfbox.pdmodel.interactive.form.PDRadioCollection;
import org.pdfbox.pdmodel.interactive.form.PDSignature;
import org.pdfbox.pdmodel.interactive.form.PDTextbox;
import org.pdfbox.pdmodel.interactive.form.PDUnknownField;

public class PDFieldFactory {
    private static final int RADIO_BITMASK = 32768;
    private static final int PUSHBUTTON_BITMASK = 65536;
    private static final int RADIOS_IN_UNISON_BITMASK = 0x2000000;
    private static final String FIELD_TYPE_BTN = "Btn";
    private static final String FIELD_TYPE_TX = "Tx";
    private static final String FIELD_TYPE_CH = "Ch";
    private static final String FIELD_TYPE_SIG = "Sig";

    private PDFieldFactory() {
    }

    public static PDField createField(PDAcroForm acroForm, COSDictionary field) throws IOException {
        PDField pdField = new PDUnknownField(acroForm, field);
        if (PDFieldFactory.isButton(pdField)) {
            int flags = pdField.getFieldFlags();
            COSArray kids = (COSArray)field.getDictionaryObject(COSName.getPDFName("Kids"));
            pdField = kids != null || PDFieldFactory.isRadio(flags) ? new PDRadioCollection(acroForm, field) : (PDFieldFactory.isPushButton(flags) ? new PDPushButton(acroForm, field) : new PDCheckbox(acroForm, field));
        } else if (PDFieldFactory.isChoiceField(pdField)) {
            pdField = new PDChoiceField(acroForm, field);
        } else if (PDFieldFactory.isTextbox(pdField)) {
            pdField = new PDTextbox(acroForm, field);
        } else if (PDFieldFactory.isSignature(pdField)) {
            pdField = new PDSignature(acroForm, field);
        }
        return pdField;
    }

    private static boolean isRadio(int flags) {
        return (flags & 0x8000) > 0;
    }

    private static boolean isPushButton(int flags) {
        return (flags & 0x10000) > 0;
    }

    private static boolean isChoiceField(PDField field) throws IOException {
        return FIELD_TYPE_CH.equals(field.findFieldType());
    }

    private static boolean isButton(PDField field) throws IOException {
        String ft = field.findFieldType();
        boolean retval = FIELD_TYPE_BTN.equals(ft);
        List kids = field.getKids();
        if (ft == null && kids != null && kids.size() > 0) {
            Object obj = kids.get(0);
            COSDictionary kidDict = null;
            if (obj instanceof PDField) {
                kidDict = ((PDField)obj).getDictionary();
            } else if (obj instanceof PDAnnotationWidget) {
                kidDict = ((PDAnnotationWidget)obj).getDictionary();
            } else {
                throw new IOException("Error:Unexpected type of kids field:" + obj);
            }
            retval = PDFieldFactory.isButton(new PDUnknownField(field.getAcroForm(), kidDict));
        }
        return retval;
    }

    private static boolean isSignature(PDField field) throws IOException {
        return FIELD_TYPE_SIG.equals(field.findFieldType());
    }

    private static boolean isTextbox(PDField field) throws IOException {
        return FIELD_TYPE_TX.equals(field.findFieldType());
    }
}

