/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;

class Guard {
    private final boolean mAllowed;
    private final String mPkgName;
    private final String mClassName;
    private final boolean mExactMatch;
    private final boolean mLocalOnly;
    static final /* synthetic */ boolean $assertionsDisabled;

    Guard(boolean aAllow, boolean aLocalOnly, String aPkgName, boolean aExactMatch) {
        this.mAllowed = aAllow;
        this.mLocalOnly = aLocalOnly;
        this.mPkgName = aPkgName;
        this.mClassName = null;
        this.mExactMatch = aExactMatch;
    }

    Guard(boolean aAllow, boolean aLocalOnly, String aClassName) {
        this.mAllowed = aAllow;
        this.mLocalOnly = aLocalOnly;
        this.mPkgName = null;
        this.mClassName = aClassName;
        this.mExactMatch = true;
    }

    AccessResult verifyImport(String aForImport) {
        if (!$assertionsDisabled && aForImport == null) {
            throw new AssertionError();
        }
        if (this.mClassName != null) {
            boolean classMatch = this.mClassName.equals(aForImport);
            return this.calculateResult(classMatch);
        }
        if (!$assertionsDisabled && this.mPkgName == null) {
            throw new AssertionError();
        }
        boolean pkgMatch = aForImport.startsWith(this.mPkgName + ".");
        if (pkgMatch && this.mExactMatch) {
            pkgMatch = aForImport.indexOf(46, this.mPkgName.length() + 1) == -1;
        }
        return this.calculateResult(pkgMatch);
    }

    boolean isLocalOnly() {
        return this.mLocalOnly;
    }

    private AccessResult calculateResult(boolean aMatched) {
        if (aMatched) {
            return this.mAllowed ? AccessResult.ALLOWED : AccessResult.DISALLOWED;
        }
        return AccessResult.UNKNOWN;
    }

    static {
        $assertionsDisabled = !Guard.class.desiredAssertionStatus();
    }
}

