/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import apex.common.collect.ConcatenatedCollections;
import apex.common.collect.SinglePrependCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;

public final class MoreCollections {
    private MoreCollections() {
    }

    public static <T> Collection<T> concatCollections(Collection<? extends T> head, Collection<? extends T> tail) {
        Objects.requireNonNull(head, "head was not provided");
        Objects.requireNonNull(tail, "tail was not provided");
        if (tail.isEmpty() && head.isEmpty()) {
            return ImmutableList.of();
        }
        if (tail.isEmpty()) {
            return head;
        }
        if (head.isEmpty()) {
            return tail;
        }
        return new ConcatenatedCollections<T>(head, tail);
    }

    public static <T> Collection<T> prependCollection(T head, Collection<? extends T> tail) {
        Objects.requireNonNull(head, "head was not provided");
        Objects.requireNonNull(tail, "tail was not provided");
        if (tail.isEmpty()) {
            return ImmutableList.of(head);
        }
        return new SinglePrependCollection<T>(head, tail);
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }
}

