/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class UserClassMembers {
    private static final ModifierGroup CLONE_MODIFIERS = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.GLOBAL).build();
    private final List<Statement> statements;
    private final List<AstNode> fieldsAndProperties;
    private final List<Method> methods;
    private final List<Property> properties;
    private final List<Compilation> innerTypes;

    private UserClassMembers(Builder builder) {
        this.statements = builder.statementBuilder.build();
        this.fieldsAndProperties = builder.fieldsAndPropertiesBuilder.build();
        this.methods = builder.methodBuilder.build();
        this.properties = builder.propertyBuilder.build();
        this.innerTypes = builder.innerTypesBuilder.build();
    }

    private static Method createClone(UserClass node, TypeInfo classType) {
        SimpleStatement root = new SimpleStatement(node){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, SystemEmitMethods.CLONE_OBJECT);
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(classType).setReturnType(classType).setEmitSignature("clone", TypeInfos.OBJECT, new TypeInfo[0]).setName("clone").setDuckTyped().setModifiers(CLONE_MODIFIERS).setGenerated(Generated.ANONYMOUS), root);
    }

    private static Method createClinit(UserClass node, final TypeInfo classType, Location loc, final List<Statement> staticStatements) {
        Statement root = new Statement(node){

            @Override
            public final <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
                for (AstNode node : staticStatements) {
                    node.traverse(visitor, scope);
                }
            }

            @Override
            public final void validate(SymbolResolver symbols, ValidationScope scope) {
                for (AstNode node : staticStatements) {
                    node.validate(symbols, scope);
                }
            }

            @Override
            public void emit(Emitter emitter) {
                Emit body = e -> {
                    for (Statement statement : staticStatements) {
                        statement.emit(e);
                    }
                    e.emit(Locations.NONE, 0);
                };
                SystemModeEmit.emitter().withType(classType).withBody(body).emit(emitter);
            }
        };
        ModifierGroup modifiers = ModifierGroup.builder().setLoc(loc).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.STATIC).build();
        return MethodFactory.create(node, StandardMethodInfo.builder().setDefiningType(classType).setReturnType(TypeInfos.VOID).setName("<clinit>").setModifiers(modifiers).setGenerated(Generated.INTERNAL), root);
    }

    public static UserClassMembers create(UserClass node, Errors errors, SourceFile source, AstNode definingNode, TypeInfo classType, ClassDecl body) {
        Builder builder = new Builder(errors, source, definingNode, node);
        for (BlockMember member : AstNodes.filterNotNull(body.members)) {
            member._switch(builder);
        }
        if (definingNode == null) {
            builder.methodBuilder.add(UserClassMembers.createClinit(node, classType, body.name.getLoc(), (List<Statement>)((Object)builder.staticStatementBuilder.build())));
        }
        builder.methodBuilder.add(UserClassMembers.createClone(node, classType));
        return new UserClassMembers(builder);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("fields", this.fieldsAndProperties).add("methods", this.methods).add("properties", this.properties).add("innerTypes", this.innerTypes).toString();
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<AstNode> getFieldsAndProperties() {
        return this.fieldsAndProperties;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Compilation> getInnerTypes() {
        return this.innerTypes;
    }

    private static class Builder
    implements BlockMember.SwitchBlock {
        private final Errors errors;
        private final SourceFile source;
        private final AstNode definingNode;
        private final UserClass node;
        private final ImmutableList.Builder<Statement> staticStatementBuilder;
        private final ImmutableList.Builder<Statement> statementBuilder;
        private final ImmutableList.Builder<AstNode> fieldsAndPropertiesBuilder;
        private final ImmutableList.Builder<Method> methodBuilder;
        private final ImmutableList.Builder<Property> propertyBuilder;
        private final ImmutableList.Builder<Compilation> innerTypesBuilder;

        private Builder(Errors errors, SourceFile source, AstNode definingNode, UserClass node) {
            this.errors = errors;
            this.source = source;
            this.definingNode = definingNode;
            this.node = node;
            this.staticStatementBuilder = ImmutableList.builder();
            this.statementBuilder = ImmutableList.builder();
            this.fieldsAndPropertiesBuilder = ImmutableList.builder();
            this.methodBuilder = ImmutableList.builder();
            this.propertyBuilder = ImmutableList.builder();
            this.innerTypesBuilder = ImmutableList.builder();
        }

        @Override
        public void _case(BlockMember.StmntBlockMember x) {
            this.statementBuilder.add((Object)AstNodes.get().create((AstNode)this.node, x.stmnt));
        }

        @Override
        public void _case(BlockMember.StaticStmntBlockMember x) {
            if (this.definingNode == null) {
                this.staticStatementBuilder.add((Object)AstNodes.get().create((AstNode)this.node, x.stmnt));
            } else {
                this.errors.markInvalid((AstNode)this.node, Locations.from(x.stmnt), I18nSupport.getLabel("invalid.inner.type.no.static.blocks"));
            }
        }

        @Override
        public void _case(BlockMember.FieldMember field) {
            FieldDeclarationStatements statement = AstNodes.get().create((AstNode)this.node, field.variableDecls);
            if (statement.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.staticStatementBuilder.add((Object)statement);
            } else {
                this.statementBuilder.add((Object)statement);
            }
            this.fieldsAndPropertiesBuilder.addAll(FieldFactory.createFields(this.node, field.variableDecls));
        }

        @Override
        public void _case(BlockMember.MethodMember method) {
            this.methodBuilder.add((Object)MethodFactory.createUserMethod(this.node, method.methodDecl));
        }

        @Override
        public void _case(BlockMember.PropertyMember member) {
            if (member.propertyDecl != null) {
                Property property = AstNodes.get().create(this.errors, this.node, member.propertyDecl);
                if (!property.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    this.statementBuilder.add((Object)StatementExecuted.createSynthetic(this.node, member.propertyDecl.name.getLoc(), true, false));
                }
                this.fieldsAndPropertiesBuilder.add((Object)property);
                this.propertyBuilder.add((Object)property);
            }
        }

        @Override
        public void _case(BlockMember.InnerClassMember innerClass) {
            if (this.definingNode == null) {
                this.staticStatementBuilder.add((Object)StatementExecuted.createSynthetic(this.node, innerClass.body.name.getLoc(), false, false));
                this.innerTypesBuilder.add((Object)AstNodes.get().create(this.errors, this.source, this.node, CompilationUnit._ClassDeclUnit(innerClass.body)));
            } else {
                this.errors.markInvalid((AstNode)this.node, innerClass.body.loc, I18nSupport.getLabel("invalid.inner.type.no.inner.types"));
            }
        }

        @Override
        public void _case(BlockMember.InnerInterfaceMember innerInterface) {
            if (this.definingNode == null) {
                this.innerTypesBuilder.add((Object)AstNodes.get().create(this.errors, this.source, this.node, CompilationUnit._InterfaceDeclUnit(innerInterface.body)));
            } else {
                this.errors.markInvalid((AstNode)this.node, innerInterface.body.loc, I18nSupport.getLabel("invalid.inner.type.no.inner.types"));
            }
        }

        @Override
        public void _case(BlockMember.InnerEnumMember innerEnum) {
            if (this.definingNode == null) {
                this.innerTypesBuilder.add((Object)AstNodes.get().create(this.errors, this.source, this.node, CompilationUnit._EnumDeclUnit(innerEnum.body)));
            } else {
                this.errors.markInvalid((AstNode)this.node, innerEnum.body.loc, I18nSupport.getLabel("invalid.inner.type.no.inner.types"));
            }
        }
    }
}

